/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AbstractAggregateOperator;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExtendedEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class GroupIterator
extends CloseableIteratorIteration<BindingSet, QueryEvaluationException> {
    private final SimpleValueFactory vf = SimpleValueFactory.getInstance();
    private final EvaluationStrategy strategy;
    private final BindingSet parentBindings;
    private final Group group;
    private final DB db;
    private final long iterationCacheSyncThreshold;
    private final QueryEvaluationContext context;
    private static final int SWITCH_TO_DISK_BASED_SET_AT_SIZE = 16;
    private static final Predicate<BindingSet> ALWAYS_TRUE_BINDING_SET = t -> true;
    private static final Predicate<Value> ALWAYS_TRUE_VALUE = t -> true;
    private static final LongFunction<Predicate<Value>> ALWAYS_TRUE_VALUE_SUPPLIER = l -> ALWAYS_TRUE_VALUE;

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings, QueryEvaluationContext context) throws QueryEvaluationException {
        this(strategy, group, parentBindings, 0L, context);
    }

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings, long iterationCacheSyncThreshold, QueryEvaluationContext context) throws QueryEvaluationException {
        this.strategy = strategy;
        this.group = group;
        this.parentBindings = parentBindings;
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
        this.context = context;
        if (this.iterationCacheSyncThreshold > 0L) {
            try {
                this.db = DBMaker.newFileDB((File)File.createTempFile("group-eval", null)).deleteFilesAfterClose().closeOnJvmShutdown().make();
            }
            catch (IOException e) {
                throw new QueryEvaluationException("could not initialize temp db", (Throwable)e);
            }
        } else {
            this.db = null;
        }
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (!super.hasIterator()) {
            super.setIterator(this.createIterator());
        }
        return super.hasNext();
    }

    public BindingSet next() throws QueryEvaluationException {
        if (!super.hasIterator()) {
            super.setIterator(this.createIterator());
        }
        return (BindingSet)super.next();
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            if (this.db != null) {
                this.db.close();
            }
        }
    }

    private <T> Set<T> createSet(String setName) {
        if (this.db != null) {
            return new MemoryTillSizeXSet(setName);
        }
        return new HashSet();
    }

    private Iterator<BindingSet> createIterator() throws QueryEvaluationException {
        List<AggregatePredicateCollectorSupplier<?, ?>> aggregates = this.makeAggregates();
        Collection<Entry> entries = this.buildEntries(aggregates);
        Set bindingSets = this.createSet("bindingsets");
        Supplier<MutableBindingSet> makeNewBindingSet = this.parentBindings.isEmpty() ? this.context::createBindingSet : () -> this.context.createBindingSet(this.parentBindings);
        ArrayList<Function<BindingSet, Value>> getValues = new ArrayList<Function<BindingSet, Value>>();
        ArrayList<BiConsumer<Value, MutableBindingSet>> setBindings = new ArrayList<BiConsumer<Value, MutableBindingSet>>();
        BiConsumer<Entry, MutableBindingSet> bindSolution = this.makeBindSolution(aggregates);
        for (String name : this.group.getGroupBindingNames()) {
            Function<BindingSet, Value> getValue = this.context.getValue(name);
            BiConsumer<Value, MutableBindingSet> setBinding = this.context.setBinding(name);
            if (getValue == null) continue;
            getValues.add(getValue);
            setBindings.add(setBinding);
        }
        for (Entry entry : entries) {
            MutableBindingSet sol = makeNewBindingSet.get();
            BindingSet prototype = entry.getPrototype();
            if (prototype != null) {
                for (int i = 0; i < getValues.size(); ++i) {
                    Function getBinding = (Function)getValues.get(i);
                    Value value = (Value)getBinding.apply(prototype);
                    if (value == null) continue;
                    ((BiConsumer)setBindings.get(i)).accept(value, sol);
                }
            }
            bindSolution.accept(entry, sol);
            bindingSets.add(sol);
        }
        return bindingSets.iterator();
    }

    private BiConsumer<Entry, MutableBindingSet> makeBindSolution(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) {
        BiConsumer<Entry, MutableBindingSet> bindSolution = null;
        for (int i = 0; i < aggregates.size(); ++i) {
            AggregatePredicateCollectorSupplier<?, ?> a = aggregates.get(i);
            BiConsumer<Value, MutableBindingSet> setBinding = this.context.setBinding(a.name);
            int j = i;
            BiConsumer<Entry, MutableBindingSet> biConsumer = (e, bs) -> {
                try {
                    Value value = e.collectors.get(j).getFinalValue();
                    if (value != null) {
                        setBinding.accept(value, (MutableBindingSet)bs);
                    }
                }
                catch (ValueExprEvaluationException valueExprEvaluationException) {
                    // empty catch block
                }
            };
            bindSolution = bindSolution == null ? biConsumer : bindSolution.andThen(biConsumer);
        }
        if (bindSolution == null) {
            return (e, bs) -> {};
        }
        return bindSolution;
    }

    private List<AggregatePredicateCollectorSupplier<?, ?>> makeAggregates() {
        ArrayList aggregates = new ArrayList(this.group.getGroupBindingNames().size());
        for (GroupElem ge : this.group.getGroupElements()) {
            AggregatePredicateCollectorSupplier<?, ?> create = this.create(ge);
            if (create == null) continue;
            aggregates.add(create);
        }
        return aggregates;
    }

    private Collection<Entry> buildEntries(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) throws QueryEvaluationException {
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.strategy.precompile(this.group.getArg(), this.context).evaluate(this.parentBindings);){
            long setId = 0L;
            Function<BindingSet, Integer> hashMaker = GroupIterator.hashMaker(this.context, this.group);
            LinkedHashMap<Key, Entry> entries = new LinkedHashMap<Key, Entry>();
            if (!iter.hasNext()) {
                this.emptySolutionSpecialCase(aggregates, entries);
            } else {
                while (iter.hasNext()) {
                    BindingSet sol = (BindingSet)iter.next();
                    Key key = new Key(sol, hashMaker.apply(sol));
                    Entry entry = (Entry)entries.get(key);
                    if (entry == null) {
                        List<AggregateCollector> collectors = this.makeCollectors(aggregates);
                        ArrayList predicates = new ArrayList(aggregates.size());
                        for (AggregatePredicateCollectorSupplier<?, ?> a : aggregates) {
                            predicates.add(a.predicate.apply(setId++));
                        }
                        entry = new Entry(sol, collectors, predicates);
                        entries.put(key, entry);
                    }
                    entry.addSolution(sol, aggregates);
                }
            }
            Collection<Entry> collection = entries.values();
            return collection;
        }
    }

    private void emptySolutionSpecialCase(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates, Map<Key, Entry> entries) {
        if (this.group.getGroupBindingNames().isEmpty()) {
            if (this.group.getGroupElements().isEmpty()) {
                Entry entry = new Entry(null, null, null);
                entries.put(new Key(EmptyBindingSet.getInstance()), entry);
            } else {
                List<AggregateCollector> collectors = this.makeCollectors(aggregates);
                ArrayList predicates = new ArrayList(aggregates.size());
                for (int i = 0; i < aggregates.size(); ++i) {
                    predicates.add(ALWAYS_TRUE_BINDING_SET);
                }
                Entry entry = new Entry(null, collectors, predicates);
                entry.addSolution(EmptyBindingSet.getInstance(), aggregates);
                entries.put(new Key(EmptyBindingSet.getInstance()), entry);
            }
        }
    }

    private List<AggregateCollector> makeCollectors(List<AggregatePredicateCollectorSupplier<?, ?>> aggregates) {
        ArrayList<AggregateCollector> collectors = new ArrayList<AggregateCollector>(aggregates.size());
        for (AggregatePredicateCollectorSupplier<?, ?> a : aggregates) {
            collectors.add((AggregateCollector)a.supplier.get());
        }
        return collectors;
    }

    private static Function<BindingSet, Integer> hashMaker(QueryEvaluationContext context, Group group) {
        Set groupBindingNames = group.getGroupBindingNames();
        int size = groupBindingNames.size();
        if (size == 1) {
            Function<BindingSet, Value> getValue = context.getValue((String)groupBindingNames.iterator().next());
            return bs -> {
                Value value = (Value)getValue.apply((BindingSet)bs);
                return value != null ? value.hashCode() : 0;
            };
        }
        ArrayList<Function<BindingSet, Value>> getValues = new ArrayList<Function<BindingSet, Value>>(size);
        for (String name : groupBindingNames) {
            Function<BindingSet, Value> getValue = context.getValue(name);
            getValues.add(getValue);
        }
        return bs -> {
            int nextHash = 0;
            for (Function getValue : getValues) {
                Value value = (Value)getValue.apply(bs);
                if (value == null) continue;
                nextHash ^= value.hashCode();
            }
            return nextHash;
        };
    }

    private AggregatePredicateCollectorSupplier<?, ?> create(GroupElem ge) throws QueryEvaluationException {
        AggregateOperator operator = ge.getOperator();
        if (operator instanceof Count) {
            if (((Count)operator).getArg() == null) {
                WildCardCountAggregate wildCardCountAggregate = new WildCardCountAggregate((Count)operator);
                LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctBindingSets(x$0) : l -> ALWAYS_TRUE_BINDING_SET;
                return new AggregatePredicateCollectorSupplier<CountCollector, BindingSet>(wildCardCountAggregate, predicate, () -> new CountCollector(), ge.getName());
            }
            CountAggregate agg = new CountAggregate((Count)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<CountCollector, Value>(agg, predicate, () -> new CountCollector(), ge.getName());
        }
        if (operator instanceof Min) {
            MinAggregate agg = new MinAggregate((Min)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<ValueCollector, Value>(agg, predicate, () -> new ValueCollector(), ge.getName());
        }
        if (operator instanceof Max) {
            MaxAggregate agg = new MaxAggregate((Max)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<ValueCollector, Value>(agg, predicate, () -> new ValueCollector(), ge.getName());
        }
        if (operator instanceof Sum) {
            SumAggregate agg = new SumAggregate((Sum)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<IntegerCollector, Value>(agg, predicate, () -> new IntegerCollector(), ge.getName());
        }
        if (operator instanceof Avg) {
            AvgAggregate agg = new AvgAggregate((Avg)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<AvgCollector, Value>(agg, predicate, () -> new AvgCollector(), ge.getName());
        }
        if (operator instanceof Sample) {
            SampleAggregate agg = new SampleAggregate((Sample)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<SampleCollector, Value>(agg, predicate, () -> new SampleCollector(), ge.getName());
        }
        if (operator instanceof GroupConcat) {
            ConcatAggregate agg = new ConcatAggregate((GroupConcat)operator);
            LongFunction predicate = operator.isDistinct() ? x$0 -> new DistinctValues(x$0) : ALWAYS_TRUE_VALUE_SUPPLIER;
            return new AggregatePredicateCollectorSupplier<StringBuilderCollector, Value>(agg, predicate, () -> new StringBuilderCollector(), ge.getName());
        }
        return null;
    }

    private <T> Predicate<T> createPredicate(AggregateOperator operator, long setId) throws QueryEvaluationException {
        if (operator.isDistinct()) {
            if (operator instanceof Count && ((Count)operator).getArg() == null) {
                return new DistinctBindingSets(setId);
            }
            return new DistinctValues(setId);
        }
        return v -> true;
    }

    private class ConcatAggregate
    extends Aggregate<StringBuilderCollector, Value> {
        private String separator;

        public ConcatAggregate(GroupConcat groupConcatOp) throws QueryEvaluationException {
            super((AbstractAggregateOperator)groupConcatOp);
            this.separator = " ";
            ValueExpr separatorExpr = groupConcatOp.getSeparator();
            if (separatorExpr != null) {
                Value separatorValue = GroupIterator.this.strategy.evaluate(separatorExpr, GroupIterator.this.parentBindings);
                this.separator = separatorValue.stringValue();
            }
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, StringBuilderCollector collector) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && distinctValue.test(v)) {
                if (collector.concatenated == null) {
                    collector.concatenated = new StringBuilder();
                } else {
                    collector.concatenated.append(this.separator);
                }
                collector.concatenated.append(v.stringValue());
            }
        }
    }

    private class StringBuilderCollector
    implements AggregateCollector {
        private StringBuilder concatenated;

        private StringBuilderCollector() {
        }

        @Override
        public Value getFinalValue() throws ValueExprEvaluationException {
            if (this.concatenated == null || this.concatenated.length() == 0) {
                return GroupIterator.this.vf.createLiteral("");
            }
            return GroupIterator.this.vf.createLiteral(this.concatenated.toString());
        }
    }

    private class SampleAggregate
    extends Aggregate<SampleCollector, Value> {
        private final Random random;

        public SampleAggregate(Sample operator) {
            super((AbstractAggregateOperator)operator);
            this.random = new Random(System.currentTimeMillis());
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinct, SampleCollector sample) throws QueryEvaluationException {
            Value newValue;
            if ((sample.sample == null || this.random.nextFloat() < 0.5f) && (newValue = this.evaluate(s)) != null) {
                sample.sample = newValue;
            }
        }
    }

    private class SampleCollector
    implements AggregateCollector {
        private Value sample;

        private SampleCollector() {
        }

        @Override
        public Value getFinalValue() throws ValueExprEvaluationException {
            if (this.sample == null) {
                throw new ValueExprEvaluationException("SAMPLE undefined");
            }
            return this.sample;
        }
    }

    private class AvgAggregate
    extends Aggregate<AvgCollector, Value> {
        public AvgAggregate(Avg operator) {
            super((AbstractAggregateOperator)operator);
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, AvgCollector avg) throws QueryEvaluationException {
            if (avg.hasError()) {
                return;
            }
            Value v = this.evaluate(s);
            if (distinctValue.test(v)) {
                if (v instanceof Literal) {
                    Literal nextLiteral = (Literal)v;
                    if (nextLiteral.getDatatype() != null && XMLDatatypeUtil.isNumericDatatype((IRI)nextLiteral.getDatatype())) {
                        avg.sum = MathUtil.compute(avg.sum, nextLiteral, MathExpr.MathOp.PLUS);
                    } else {
                        avg.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                    }
                    ++avg.count;
                } else if (v != null) {
                    avg.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                }
            }
        }
    }

    private class SumAggregate
    extends Aggregate<IntegerCollector, Value> {
        public SumAggregate(Sum operator) {
            super((AbstractAggregateOperator)operator);
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, IntegerCollector sum) throws QueryEvaluationException {
            if (sum.hasError()) {
                return;
            }
            Value v = this.evaluate(s);
            if (v != null) {
                if (v.isLiteral()) {
                    if (distinctValue.test(v)) {
                        Literal literal = (Literal)v;
                        CoreDatatype coreDatatype = literal.getCoreDatatype();
                        if (coreDatatype.isXSDDatatype() && ((CoreDatatype.XSD)coreDatatype).isNumericDatatype()) {
                            sum.value = MathUtil.compute(sum.value, literal, MathExpr.MathOp.PLUS);
                        } else {
                            sum.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                        }
                    }
                } else {
                    sum.setTypeError(new ValueExprEvaluationException("not a number: " + v));
                }
            }
        }
    }

    private class MaxAggregate
    extends Aggregate<ValueCollector, Value> {
        private final ValueComparator comparator;

        public MaxAggregate(Max operator) {
            super((AbstractAggregateOperator)operator);
            this.comparator = new ValueComparator();
            if (GroupIterator.this.strategy instanceof ExtendedEvaluationStrategy) {
                this.comparator.setStrict(false);
            }
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, ValueCollector max) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && distinctValue.test(v)) {
                if (max.value == null) {
                    max.value = v;
                } else if (this.comparator.compare(v, max.value) > 0) {
                    max.value = v;
                }
            }
        }
    }

    private class MinAggregate
    extends Aggregate<ValueCollector, Value> {
        private final ValueComparator comparator;

        public MinAggregate(Min operator) {
            super((AbstractAggregateOperator)operator);
            this.comparator = new ValueComparator();
            if (GroupIterator.this.strategy instanceof ExtendedEvaluationStrategy) {
                this.comparator.setStrict(false);
            }
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, ValueCollector min) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && distinctValue.test(v)) {
                if (min.value == null) {
                    min.value = v;
                } else if (this.comparator.compare(v, min.value) < 0) {
                    min.value = v;
                }
            }
        }
    }

    private class WildCardCountAggregate
    extends Aggregate<CountCollector, BindingSet> {
        public WildCardCountAggregate(Count operator) {
            super((AbstractAggregateOperator)operator, null);
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<BindingSet> distinctValue, CountCollector agv) throws QueryEvaluationException {
            if (!s.isEmpty() && distinctValue.test(s)) {
                ++agv.value;
            }
        }
    }

    private class CountAggregate
    extends Aggregate<CountCollector, Value> {
        public CountAggregate(Count operator) {
            super((AbstractAggregateOperator)operator);
        }

        @Override
        public void processAggregate(BindingSet s, Predicate<Value> distinctValue, CountCollector agv) throws QueryEvaluationException {
            Value value = this.evaluate(s);
            if (value != null && distinctValue.test(value)) {
                ++agv.value;
            }
        }
    }

    private abstract class Aggregate<T extends AggregateCollector, D> {
        private final QueryValueEvaluationStep qes;

        public Aggregate(AbstractAggregateOperator operator) {
            this(operator, groupIterator.strategy.precompile(operator.getArg(), groupIterator.context));
        }

        public Aggregate(AbstractAggregateOperator operator, QueryValueEvaluationStep ves) {
            this.qes = ves;
        }

        public abstract void processAggregate(BindingSet var1, Predicate<D> var2, T var3) throws QueryEvaluationException;

        protected Value evaluate(BindingSet s) throws QueryEvaluationException {
            try {
                return this.qes.evaluate(s);
            }
            catch (ValueExprEvaluationException e) {
                return null;
            }
        }
    }

    private class DistinctBindingSets
    implements Predicate<BindingSet> {
        private final Set<BindingSet> distinctValues;

        public DistinctBindingSets(long setId) {
            this.distinctValues = GroupIterator.this.createSet("distinct-values-" + setId);
        }

        @Override
        public boolean test(BindingSet value) {
            boolean result = this.distinctValues.add(value);
            if (GroupIterator.this.db != null && (long)this.distinctValues.size() % GroupIterator.this.iterationCacheSyncThreshold == 0L) {
                GroupIterator.this.db.commit();
            }
            return result;
        }
    }

    private class DistinctValues
    implements Predicate<Value> {
        private final Set<Value> distinctValues;

        public DistinctValues(long setId) {
            this.distinctValues = GroupIterator.this.createSet("distinct-values-" + setId);
        }

        @Override
        public boolean test(Value value) {
            boolean result = this.distinctValues.add(value);
            if (GroupIterator.this.db != null && (long)this.distinctValues.size() % GroupIterator.this.iterationCacheSyncThreshold == 0L) {
                GroupIterator.this.db.commit();
            }
            return result;
        }
    }

    private class AvgCollector
    implements AggregateCollector {
        private Literal sum;
        private long count;
        private ValueExprEvaluationException typeError;

        private AvgCollector() {
            this.sum = GroupIterator.this.vf.createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
        }

        public void setTypeError(ValueExprEvaluationException typeError) {
            this.typeError = typeError;
        }

        public boolean hasError() {
            return this.typeError != null;
        }

        @Override
        public Value getFinalValue() throws ValueExprEvaluationException {
            if (this.typeError != null) {
                throw this.typeError;
            }
            if (this.count == 0L) {
                return GroupIterator.this.vf.createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
            }
            Literal sizeLit = GroupIterator.this.vf.createLiteral(this.count);
            return MathUtil.compute(this.sum, sizeLit, MathExpr.MathOp.DIVIDE);
        }
    }

    private class IntegerCollector
    implements AggregateCollector {
        private ValueExprEvaluationException typeError;
        private Literal value;

        private IntegerCollector() {
            this.value = GroupIterator.this.vf.createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
        }

        public void setTypeError(ValueExprEvaluationException typeError) {
            this.typeError = typeError;
        }

        public boolean hasError() {
            return this.typeError != null;
        }

        @Override
        public Value getFinalValue() {
            if (this.typeError != null) {
                throw this.typeError;
            }
            return this.value;
        }
    }

    private class ValueCollector
    implements AggregateCollector {
        private Value value;

        private ValueCollector() {
        }

        @Override
        public Value getFinalValue() {
            return this.value;
        }
    }

    private class CountCollector
    implements AggregateCollector {
        private long value;

        private CountCollector() {
        }

        @Override
        public Value getFinalValue() {
            return GroupIterator.this.vf.createLiteral(Long.toString(this.value), (CoreDatatype)CoreDatatype.XSD.INTEGER);
        }
    }

    private static interface AggregateCollector {
        public Value getFinalValue();
    }

    private class AggregatePredicateCollectorSupplier<T extends AggregateCollector, D> {
        public final String name;
        private final Aggregate<T, D> agg;
        private final LongFunction<Predicate<D>> predicate;
        private final Supplier<T> supplier;

        public AggregatePredicateCollectorSupplier(Aggregate<T, D> agg, LongFunction<Predicate<D>> predicate, Supplier<T> supplier, String name) {
            this.agg = agg;
            this.predicate = predicate;
            this.supplier = supplier;
            this.name = name;
        }

        private void operate(BindingSet bs, Predicate<?> predicate, Object t) {
            this.agg.processAggregate(bs, predicate, (AggregateCollector)t);
        }
    }

    private class Entry {
        private final BindingSet prototype;
        private final List<AggregateCollector> collectors;
        private final List<Predicate<?>> predicates;

        public Entry(BindingSet prototype, List<AggregateCollector> collectors, List<Predicate<?>> predicates) throws QueryEvaluationException {
            this.prototype = prototype;
            this.collectors = collectors;
            this.predicates = predicates;
        }

        public void addSolution(BindingSet bs, List<AggregatePredicateCollectorSupplier<?, ?>> operators) {
            for (int i = 0; i < operators.size(); ++i) {
                AggregatePredicateCollectorSupplier<?, ?> aggregatePredicateCollectorSupplier = operators.get(i);
                aggregatePredicateCollectorSupplier.operate(bs, this.predicates.get(i), this.collectors.get(i));
            }
        }

        public BindingSet getPrototype() {
            return this.prototype;
        }
    }

    protected class Key
    implements Serializable {
        private static final long serialVersionUID = 4461951265373324084L;
        private final BindingSet bindingSet;
        private final int hash;

        public Key(BindingSet bindingSet) {
            this.bindingSet = bindingSet;
            int nextHash = 0;
            for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                Value value = bindingSet.getValue(name);
                if (value == null) continue;
                nextHash ^= value.hashCode();
            }
            this.hash = nextHash;
        }

        public Key(BindingSet bindingSet, int hash) {
            this.bindingSet = bindingSet;
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Key && other.hashCode() == this.hash) {
                BindingSet otherBindingSet = ((Key)other).bindingSet;
                for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                    Value v2;
                    Value v1 = this.bindingSet.getValue(name);
                    if (Objects.equals(v1, v2 = otherBindingSet.getValue(name))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class MemoryTillSizeXSet<T>
    extends AbstractSet<T> {
        private Set<T> wrapped = new HashSet<T>();
        private final String setName;

        public MemoryTillSizeXSet(String setName) {
            this.setName = setName;
        }

        @Override
        public boolean add(T e) {
            if (this.wrapped instanceof HashSet && this.wrapped.size() > 16) {
                Set disk = GroupIterator.this.db.getHashSet(this.setName);
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends T> arg0) {
            if (this.wrapped instanceof HashSet && arg0.size() > 16) {
                Set disk = GroupIterator.this.db.getHashSet(this.setName);
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.addAll(arg0);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.wrapped.containsAll(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            return this.wrapped.remove(o);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.wrapped.retainAll(c);
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.wrapped.toArray(arg0);
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }
}

