/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LiteralComparatorFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class MaxInclusiveConstraintComponent
extends SimpleAbstractConstraintComponent {
    Literal maxInclusive;

    public MaxInclusiveConstraintComponent(Literal maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MAX_INCLUSIVE, this.maxInclusive, new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(String varName, boolean negated) {
        if (negated) {
            return this.literalToString(this.maxInclusive) + " >= ?" + varName;
        }
        return this.literalToString(this.maxInclusive) + " < ?" + varName;
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MaxInclusiveConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MaxInclusiveConstraintComponent(this.maxInclusive);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new LiteralComparatorFilter((PlanNode)parent, this.maxInclusive, Compare.CompareOp.GE);
    }
}

