/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.util.concurrent.Future;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutorBase;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParallelTaskBase<T>
implements ParallelTask<T> {
    private static final Logger logger = LoggerFactory.getLogger(ParallelExecutorBase.class);
    protected Future<?> scheduledFuture;
    private CloseableIteration<T, QueryEvaluationException> closableIter;
    private volatile boolean cancelled = false;
    private volatile boolean closed = false;

    @Override
    public void cancel() {
        this.cancelled = true;
        this.close();
    }

    @Override
    public CloseableIteration<T, QueryEvaluationException> performTask() throws Exception {
        if (this.closed) {
            return new EmptyIteration();
        }
        if (this.cancelled) {
            throw new QueryEvaluationException("Evaluation has been cancelled");
        }
        try {
            this.closableIter = this.performTaskInternal();
        }
        catch (Exception e) {
            if (Thread.interrupted() || e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                if (this.closed) {
                    logger.trace("Exception was thrown while performing task, but it was ignored because the task was closed.", (Throwable)e);
                    return new EmptyIteration();
                }
                if (this.cancelled) {
                    throw new QueryEvaluationException("Evaluation has been cancelled", (Throwable)e);
                }
                throw new QueryEvaluationException("Evaluation has been interrupted", (Throwable)e);
            }
            if (this.closed) {
                assert (Thread.currentThread().isInterrupted()) : "Exception was thrown and task was closed, but the current thread is not interrupted which means that the exception was either something bad or some code forgot to re-interrupt the current thread: " + e;
                logger.trace("Exception was thrown while performing task, but it was ignored because the task was closed.", (Throwable)e);
                return new EmptyIteration();
            }
            assert (!this.cancelled && !this.closed);
            throw e;
        }
        if (this.cancelled || this.closed) {
            this.closableIter.close();
        }
        return this.closableIter;
    }

    protected abstract CloseableIteration<T, QueryEvaluationException> performTaskInternal() throws Exception;

    public void setScheduledFuture(Future<?> future) {
        this.scheduledFuture = future;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (Query: " + this.getQueryInfo().getQueryID() + ")";
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                Future<?> scheduledFuture = this.scheduledFuture;
                this.scheduledFuture = null;
                if (scheduledFuture != null) {
                    if (scheduledFuture.isDone()) {
                        logger.trace("Task is already done: {}", (Object)this);
                    } else {
                        logger.debug("Attempting to cancel task {}", (Object)this);
                        boolean successfullyCanceled = scheduledFuture.cancel(true);
                        if (!successfullyCanceled) {
                            logger.debug("Task {} could not be cancelled properly.", (Object)this);
                        }
                    }
                }
            }
            finally {
                if (this.closableIter != null) {
                    this.closableIter.close();
                }
            }
        }
    }
}

