/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers;

import java.util.stream.Stream;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.VariableScopeChange;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class QueryModelTreePrinter
extends AbstractQueryModelVisitor<RuntimeException> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String indentString = "   ";
    private final StringBuilder sb = new StringBuilder(256);
    private int indentLevel = 0;

    public static String printTree(QueryModelNode node) {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        node.visit(treePrinter);
        return treePrinter.getTreeString();
    }

    public String getTreeString() {
        return this.sb.toString();
    }

    @Override
    protected void meetNode(QueryModelNode node) {
        String algorithmName;
        for (int i = 0; i < this.indentLevel; ++i) {
            this.sb.append("   ");
        }
        this.sb.append(node.getSignature());
        if (node instanceof VariableScopeChange && ((VariableScopeChange)((Object)node)).isVariableScopeChange()) {
            this.sb.append(" (new scope)");
        }
        if (node instanceof BinaryTupleOperator && (algorithmName = ((BinaryTupleOperator)node).getAlgorithmName()) != null) {
            this.sb.append(" (").append(algorithmName).append(")");
        }
        QueryModelTreePrinter.appendCostAnnotation(node, this.sb);
        this.sb.append(LINE_SEPARATOR);
        ++this.indentLevel;
        super.meetNode(node);
        --this.indentLevel;
    }

    static String toHumanReadableNumber(double number) {
        Object humanReadbleString = number == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000.0 ? (double)Math.round(number / 100000.0) / 10.0 + "M" : (number > 1000.0 ? (double)Math.round(number / 100.0) / 10.0 + "K" : (number >= 0.0 ? "" + Math.round(number) : "UNKNOWN")));
        return humanReadbleString;
    }

    static String toHumanReadableTime(long nanos) {
        Object humanReadbleString = nanos > 1000000000L ? (double)(nanos / 100000000L) / 10.0 + "s" : (nanos > 1000000L ? (double)(nanos / 100000L) / 10.0 + "ms" : (nanos >= 1000L ? (double)(nanos / 1000L) / 1000.0 + "ms" : (nanos >= 0L ? nanos + "ns" : "UNKNOWN")));
        return humanReadbleString;
    }

    private static void appendCostAnnotation(QueryModelNode node, StringBuilder sb) {
        String costs = Stream.of("costEstimate=" + QueryModelTreePrinter.toHumanReadableNumber(node.getCostEstimate()), "resultSizeEstimate=" + QueryModelTreePrinter.toHumanReadableNumber(node.getResultSizeEstimate()), "resultSizeActual=" + QueryModelTreePrinter.toHumanReadableNumber(node.getResultSizeActual()), "totalTimeActual=" + QueryModelTreePrinter.toHumanReadableTime(node.getTotalTimeNanosActual())).filter(s -> !s.endsWith("UNKNOWN")).reduce((a, b) -> a + ", " + b).orElse("");
        if (!costs.isEmpty()) {
            sb.append(" (").append(costs).append(")");
        }
    }
}

