/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemStatementList {
    private static final MemStatement[] EMPTY_ARRAY = new MemStatement[0];
    private volatile MemStatement[] statements = EMPTY_ARRAY;
    private static final VarHandle STATEMENTS;
    static final VarHandle STATEMENTS_ARRAY;
    private volatile int size;
    private static final VarHandle SIZE;
    private volatile int previouslyInsertedIndex = -1;
    private static final VarHandle PREVIOUSLY_INSERTED_INDEX;
    private volatile int guaranteedLastIndexInUse = -1;
    private static final VarHandle GUARANTEED_LAST_INDEX_IN_USE;
    private volatile boolean prioritiseCleanup;
    private static final VarHandle PRIORITISE_CLEANUP;
    private final StampedLock addRemoveLock = new StampedLock();
    private final AtomicReference<Thread> prioritisedThread = new AtomicReference();

    public MemStatementList() {
    }

    public MemStatementList(int capacity) {
        this.statements = new MemStatement[capacity];
    }

    public int size() {
        return SIZE.getAcquire(this);
    }

    public boolean isEmpty() {
        return SIZE.getAcquire(this) == 0;
    }

    public void add(MemStatement st) throws InterruptedException {
        if (PRIORITISE_CLEANUP.getOpaque(this)) {
            long start = System.currentTimeMillis();
            long stop = start + TimeUnit.SECONDS.toMillis(30L);
            while (stop > System.currentTimeMillis() && PRIORITISE_CLEANUP.getVolatile(this)) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            }
        }
        long readLock = this.addRemoveLock.readLock();
        try {
            while (true) {
                MemStatement[] statements;
                int length;
                if ((length = (statements = this.getStatements()).length) > SIZE.getAcquire(this)) {
                    int i;
                    int previouslyInsertedIndex = PREVIOUSLY_INSERTED_INDEX.getOpaque(this);
                    if (previouslyInsertedIndex >= length) continue;
                    int n = i = previouslyInsertedIndex + 1 >= length ? 0 : previouslyInsertedIndex + 1;
                    while (i != previouslyInsertedIndex) {
                        boolean success;
                        if (statements[i] == null && (success = STATEMENTS_ARRAY.compareAndSet(statements, i, null, st))) {
                            MemStatement[] statementsAfterInsert = this.getStatements();
                            if (statementsAfterInsert != statements && STATEMENTS_ARRAY.getAcquire(statements, i) != st) break;
                            PREVIOUSLY_INSERTED_INDEX.setRelease(this, i);
                            SIZE.getAndAdd(this, 1);
                            this.updateGuaranteedLastIndexInUse(i);
                            return;
                        }
                        i = i + 1 >= length ? 0 : i + 1;
                    }
                }
                if (STATEMENTS.compareAndSet(this, statements, null)) {
                    MemStatement[] newArray = new MemStatement[Math.max(4, length * 2)];
                    if (statements != EMPTY_ARRAY) {
                        System.arraycopy(statements, 0, newArray, 0, length);
                    }
                    STATEMENTS.setRelease(this, newArray);
                }
                if (Thread.interrupted()) break;
            }
            throw new InterruptedException();
        }
        finally {
            this.addRemoveLock.unlockRead(readLock);
        }
    }

    private void updateGuaranteedLastIndexInUse(int newValue) {
        int guaranteedLastIndexInUse = GUARANTEED_LAST_INDEX_IN_USE.getAcquire(this);
        if (guaranteedLastIndexInUse < newValue) {
            while (guaranteedLastIndexInUse < newValue && !GUARANTEED_LAST_INDEX_IN_USE.compareAndSet(this, guaranteedLastIndexInUse, newValue)) {
                guaranteedLastIndexInUse = GUARANTEED_LAST_INDEX_IN_USE.getAcquire(this);
            }
        }
    }

    public void remove(MemStatement st) throws InterruptedException {
        block2: {
            do {
                MemStatement[] statements = this.getStatements();
                boolean success = true;
                for (int i = 0; i < statements.length; ++i) {
                    if (statements[i] != st) continue;
                    success = this.innerRemove(st, statements, i);
                    break;
                }
                if (success) break block2;
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
    }

    public void remove(MemStatement st, int index) throws InterruptedException {
        do {
            MemStatement[] statements;
            if ((statements = this.getStatements())[index] == st && this.innerRemove(st, statements, index)) {
                return;
            }
            this.remove(st);
        } while (!Thread.interrupted());
        throw new InterruptedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerRemove(MemStatement st, MemStatement[] statements, int i) throws InterruptedException {
        long writeLock = this.addRemoveLock.writeLock();
        try {
            if (this.getStatements() != statements) {
                boolean bl = false;
                return bl;
            }
            boolean success = STATEMENTS_ARRAY.compareAndSet(statements, i, st, null);
            if (success) {
                while (true) {
                    int size;
                    boolean decrementedSize;
                    if (!(decrementedSize = SIZE.compareAndSet(this, size = this.size(), size - 1))) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.addRemoveLock.unlockWrite(writeLock);
        }
    }

    public void clear() {
        long writeLock = this.addRemoveLock.writeLock();
        try {
            this.statements = EMPTY_ARRAY;
            this.size = 0;
            this.previouslyInsertedIndex = -1;
            this.guaranteedLastIndexInUse = -10;
            this.prioritiseCleanup = false;
        }
        finally {
            this.addRemoveLock.unlockWrite(writeLock);
        }
    }

    public void cleanSnapshots(int currentSnapshot) throws InterruptedException {
        boolean error;
        do {
            MemStatement[] statements = this.getStatements();
            error = false;
            for (int i = 0; i < statements.length; ++i) {
                boolean success;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                MemStatement statement = statements[i];
                if (statement == null || statement.getTillSnapshot() > currentSnapshot || (success = this.innerRemove(statement, statements, i))) continue;
                error = true;
                break;
            }
            if (error) continue;
            boolean bl = error = !STATEMENTS.compareAndSet(this, statements, statements);
        } while (error);
    }

    public MemStatement getExact(MemResource subject, MemIRI predicate, MemValue object, MemResource context, int snapshot) throws InterruptedException {
        MemStatement[] statements = this.getStatements();
        int lastIndexToCheck = this.getGuaranteedLastIndexInUse();
        for (int i = 0; i <= lastIndexToCheck; ++i) {
            MemStatement memStatement = statements[i];
            if (memStatement == null || !memStatement.exactMatch(subject, predicate, object, context) || !memStatement.isInSnapshot(snapshot)) continue;
            return memStatement;
        }
        return null;
    }

    public MemStatement[] getStatements() throws InterruptedException {
        MemStatement[] statements = STATEMENTS.getAcquire(this);
        while (statements == null) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread.onSpinWait();
            statements = STATEMENTS.getAcquire(this);
        }
        return statements;
    }

    public int getGuaranteedLastIndexInUse() {
        return GUARANTEED_LAST_INDEX_IN_USE.getAcquire(this);
    }

    public void setPrioritiseCleanup(boolean prioritiseCleanup) {
        if (!prioritiseCleanup) {
            if (this.prioritisedThread.compareAndSet(Thread.currentThread(), null)) {
                PRIORITISE_CLEANUP.setVolatile(this, false);
            } else assert (!PRIORITISE_CLEANUP.getVolatile(this));
        } else if (this.prioritisedThread.compareAndSet(null, Thread.currentThread())) {
            Thread.currentThread().setPriority(10);
            PRIORITISE_CLEANUP.setVolatile(this, true);
        } else {
            throw new IllegalStateException("A cleanup thread is already prioritised: " + this.prioritisedThread.get());
        }
    }

    static {
        try {
            SIZE = MethodHandles.lookup().in(MemStatementList.class).findVarHandle(MemStatementList.class, "size", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        try {
            PREVIOUSLY_INSERTED_INDEX = MethodHandles.lookup().in(MemStatementList.class).findVarHandle(MemStatementList.class, "previouslyInsertedIndex", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        try {
            GUARANTEED_LAST_INDEX_IN_USE = MethodHandles.lookup().in(MemStatementList.class).findVarHandle(MemStatementList.class, "guaranteedLastIndexInUse", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        try {
            PRIORITISE_CLEANUP = MethodHandles.lookup().in(MemStatementList.class).findVarHandle(MemStatementList.class, "prioritiseCleanup", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        try {
            STATEMENTS = MethodHandles.lookup().in(MemStatementList.class).findVarHandle(MemStatementList.class, "statements", MemStatement[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        STATEMENTS_ARRAY = MethodHandles.arrayElementVarHandle(MemStatement[].class);
    }
}

