/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSourceHelper;

public class SailConnectionShapeSource
implements ShapeSource {
    private final SailConnection connection;
    private final Resource[] context;

    public SailConnectionShapeSource(SailConnection connection) {
        this(connection, null);
    }

    private SailConnectionShapeSource(SailConnection connection, Resource[] context) {
        this.connection = connection;
        this.context = context;
        assert (connection.isActive());
    }

    @Override
    public SailConnectionShapeSource withContext(Resource[] context) {
        return new SailConnectionShapeSource(this.connection, context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        assert (this.context == null);
        try (Stream<? extends Statement> stream = this.connection.getStatements(null, SHACL.SHAPES_GRAPH, null, false, new Resource[0]).stream();){
            Stream<ShapeSource.ShapesGraph> stream2 = stream.collect(Collectors.groupingBy(Statement::getSubject)).entrySet().stream().map(entry -> new ShapeSource.ShapesGraph((Resource)entry.getKey(), (List)entry.getValue()));
            return stream2;
        }
    }

    private Stream<Resource> getContext(ShapeSource.Predicates predicate) {
        assert (this.context == null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, new Resource[0]).stream().map(Statement::getContext).distinct();
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        return Stream.of(this.getSubjects(ShapeSource.Predicates.TARGET_NODE), this.getSubjects(ShapeSource.Predicates.TARGET_CLASS), this.getSubjects(ShapeSource.Predicates.TARGET_SUBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_OBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_PROP), this.getSubjects(ShapeSource.Predicates.RSX_targetShape)).reduce(Stream::concat).get().distinct();
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        assert (this.context != null);
        return this.connection.hasStatement(subject, RDF.TYPE, type, true, this.context);
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, this.context).stream().map(Statement::getSubject).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(subject, predicate.getIRI(), null, true, this.context).stream().map(Statement::getObject).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        return this.connection.getStatements(id, null, null, true, this.context).stream().map(s -> s);
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        return ShapeSourceHelper.getFirst(this.connection, subject, this.context);
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        return ShapeSourceHelper.getRdfRest(this.connection, subject, this.context);
    }

    @Override
    public void close() {
    }
}

