/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class ContextCollector
extends AbstractQueryModelVisitor<Exception> {
    private final Map<TupleExpr, Var> mContexts = new HashMap<TupleExpr, Var>();

    private ContextCollector() {
    }

    static Map<TupleExpr, Var> collectContexts(TupleExpr theTupleExpr) throws Exception {
        ContextCollector aContextVisitor = new ContextCollector();
        theTupleExpr.visit((QueryModelVisitor)aContextVisitor);
        return aContextVisitor.mContexts;
    }

    public void meet(Join theJoin) throws Exception {
        this.binaryOpMeet((TupleExpr)theJoin, theJoin.getLeftArg(), theJoin.getRightArg());
    }

    public void meet(LeftJoin theJoin) throws Exception {
        this.binaryOpMeet((TupleExpr)theJoin, theJoin.getLeftArg(), theJoin.getRightArg());
    }

    public void meet(Union theOp) throws Exception {
        this.binaryOpMeet((TupleExpr)theOp, theOp.getLeftArg(), theOp.getRightArg());
    }

    public void meet(Difference theOp) throws Exception {
        this.binaryOpMeet((TupleExpr)theOp, theOp.getLeftArg(), theOp.getRightArg());
    }

    public void meet(Intersection theOp) throws Exception {
        this.binaryOpMeet((TupleExpr)theOp, theOp.getLeftArg(), theOp.getRightArg());
    }

    public void meet(Filter theFilter) throws Exception {
        theFilter.getArg().visit((QueryModelVisitor)this);
        if (this.mContexts.containsKey(theFilter.getArg())) {
            Var aCtx = this.mContexts.get(theFilter.getArg());
            this.mContexts.remove(theFilter.getArg());
            this.mContexts.put((TupleExpr)theFilter, aCtx);
        }
    }

    private void binaryOpMeet(TupleExpr theCurrentExpr, TupleExpr theLeftExpr, TupleExpr theRightExpr) throws Exception {
        theLeftExpr.visit((QueryModelVisitor)this);
        Var aLeftCtx = this.mContexts.get(theLeftExpr);
        theRightExpr.visit((QueryModelVisitor)this);
        Var aRightCtx = this.mContexts.get(theRightExpr);
        this.sameCtxCheck(theCurrentExpr, theLeftExpr, aLeftCtx, theRightExpr, aRightCtx);
    }

    public void meet(StatementPattern thePattern) throws Exception {
        Var aCtxVar = thePattern.getContextVar();
        if (aCtxVar != null) {
            this.mContexts.put((TupleExpr)thePattern, aCtxVar);
        }
    }

    private void sameCtxCheck(TupleExpr theCurrentExpr, TupleExpr theLeftExpr, Var theLeftCtx, TupleExpr theRightExpr, Var theRightCtx) {
        if (theLeftCtx != null && theRightCtx != null && this.isSameCtx(theLeftCtx, theRightCtx)) {
            this.mContexts.remove(theLeftExpr);
            this.mContexts.remove(theRightExpr);
            this.mContexts.put(theCurrentExpr, theLeftCtx);
        }
    }

    private boolean isSameCtx(Var v1, Var v2) {
        if (v1 != null && v1.getValue() != null && v2 != null && v2.getValue() != null) {
            return v1.getValue().equals(v2.getValue());
        }
        if (v1 != null && v1.getName() != null && v2 != null && v2.getName() != null) {
            return v1.getName().equals(v2.getName());
        }
        return false;
    }
}

