/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class ClosedConstraintComponent
extends AbstractConstraintComponent {
    private final List<Path> paths;
    private final List<IRI> ignoredProperties;

    public ClosedConstraintComponent(ShapeSource shapeSource, List<Resource> property, Resource ignoredProperties) {
        this.paths = property.stream().flatMap(r -> shapeSource.getObjects((Resource)r, ShapeSource.Predicates.PATH).map(o -> (Resource)o).map(path -> Path.buildPath(shapeSource, path))).collect(Collectors.toList());
        this.ignoredProperties = ignoredProperties != null ? ShaclAstLists.toList(shapeSource, ignoredProperties, IRI.class) : Collections.emptyList();
    }

    public ClosedConstraintComponent(ClosedConstraintComponent closedConstraintComponent) {
        this.paths = closedConstraintComponent.paths;
        this.ignoredProperties = closedConstraintComponent.ignoredProperties;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.CLOSED, (Value)Values.literal((boolean)true), new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.ClosedConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new ClosedConstraintComponent(this);
    }
}

