/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;

class ShapeSourceHelper {
    ShapeSourceHelper() {
    }

    static Value getFirst(SailConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (Stream stream = connection.getStatements(subject, RDF.FIRST, null, true, context).stream();){
            Value value = ShapeSourceHelper.getObject(stream);
            return value;
        }
    }

    static Value getFirst(RepositoryConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (Stream stream = connection.getStatements(subject, RDF.FIRST, null, true, context).stream();){
            Value value = ShapeSourceHelper.getObject(stream);
            return value;
        }
    }

    static Resource getRdfRest(RepositoryConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (Stream stream = connection.getStatements(subject, RDF.REST, null, true, context).stream();){
            Resource resource = (Resource)ShapeSourceHelper.getObject(stream);
            return resource;
        }
    }

    static Resource getRdfRest(SailConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (Stream stream = connection.getStatements(subject, RDF.REST, null, true, context).stream();){
            Resource resource = (Resource)ShapeSourceHelper.getObject(stream);
            return resource;
        }
    }

    private static Value getObject(Stream<? extends Statement> stream) {
        return stream.map(Statement::getObject).findAny().orElse(null);
    }
}

