/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class DateCast
extends CastFunction {
    private static final String ZERO = "0";

    @Override
    protected IRI getXsdDatatype() {
        return XSD.DATE;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidDate(lexicalValue);
    }

    @Override
    protected Literal convert(ValueFactory vf, Value value) throws ValueExprEvaluationException {
        Literal literal;
        IRI datatype;
        if (value instanceof Literal && (XSD.STRING.equals(datatype = (literal = (Literal)value).getDatatype()) || XSD.DATETIME.equals(datatype))) {
            try {
                XMLGregorianCalendar calValue = literal.calendarValue();
                int year = calValue.getYear();
                int month = calValue.getMonth();
                int day = calValue.getDay();
                int timezoneOffset = calValue.getTimezone();
                if (Integer.MIN_VALUE != year && Integer.MIN_VALUE != month && Integer.MIN_VALUE != day) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(year).append("-");
                    DateCast.addZeroIfNeeded(month, builder);
                    builder.append(month).append("-");
                    DateCast.addZeroIfNeeded(day, builder);
                    builder.append(day);
                    if (Integer.MIN_VALUE != timezoneOffset) {
                        int minutes = Math.abs(timezoneOffset);
                        int hours = minutes / 60;
                        minutes -= hours * 60;
                        builder.append(timezoneOffset > 0 ? "+" : "-");
                        DateCast.addZeroIfNeeded(hours, builder);
                        builder.append(hours);
                        builder.append(":");
                        DateCast.addZeroIfNeeded(minutes, builder);
                        builder.append(minutes);
                    }
                    return vf.createLiteral(builder.toString(), XSD.DATE);
                }
                throw this.typeError(literal, null);
            }
            catch (IllegalArgumentException e) {
                throw this.typeError(literal, e);
            }
        }
        throw this.typeError(value, null);
    }

    private static void addZeroIfNeeded(int value, StringBuilder builder) {
        if (value < 10) {
            builder.append(ZERO);
        }
    }
}

