/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import org.eclipse.rdf4j.model.base.AbstractIRI;
import org.eclipse.rdf4j.model.util.URIUtil;

public class SimpleIRI
extends AbstractIRI {
    private static final long serialVersionUID = -7330406348751485330L;
    private String iriString;
    private int localNameIdx;

    protected SimpleIRI() {
    }

    protected SimpleIRI(String iriString) {
        this.setIRIString(iriString);
    }

    protected SimpleIRI(String namespace, String localname) {
        this.setIRIString(namespace, localname);
    }

    protected void setIRIString(String namespace, String localname) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(localname, "localname must not be null");
        String joinedIriString = namespace + localname;
        if (joinedIriString.indexOf(58) < 0) {
            throw new IllegalArgumentException("Not a valid (absolute) IRI: " + joinedIriString);
        }
        this.iriString = joinedIriString;
        this.localNameIdx = namespace.length();
    }

    protected void setIRIString(String iriString) {
        Objects.requireNonNull(iriString, "iriString must not be null");
        if (iriString.indexOf(58) < 0) {
            throw new IllegalArgumentException("Not a valid (absolute) IRI: " + iriString);
        }
        this.iriString = iriString;
        this.localNameIdx = -1;
    }

    @Override
    public String stringValue() {
        return this.iriString;
    }

    @Override
    public String getNamespace() {
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex(this.iriString);
        }
        return this.iriString.substring(0, this.localNameIdx);
    }

    @Override
    public String getLocalName() {
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex(this.iriString);
        }
        return this.iriString.substring(this.localNameIdx);
    }
}

