/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;

public class NumericMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = -4077489124945558638L;
    private final Number number;

    public NumericMemLiteral(Object creator, String label, Number number, IRI datatype) {
        super(creator, label, datatype);
        this.number = number;
    }

    public NumericMemLiteral(Object creator, String label, Number number, CoreDatatype datatype) {
        super(creator, label, datatype);
        this.number = number;
    }

    public NumericMemLiteral(Object creator, Number number, IRI datatype) {
        this(creator, XMLDatatypeUtil.toString((Number)number), number, datatype);
    }

    public NumericMemLiteral(Object creator, byte number) {
        this(creator, number, XSD.BYTE);
    }

    public NumericMemLiteral(Object creator, short number) {
        this(creator, number, XSD.SHORT);
    }

    public NumericMemLiteral(Object creator, int number) {
        this(creator, number, XSD.INT);
    }

    public NumericMemLiteral(Object creator, long n) {
        this(creator, n, XSD.LONG);
    }

    public NumericMemLiteral(Object creator, float n) {
        this(creator, Float.valueOf(n), XSD.FLOAT);
    }

    public NumericMemLiteral(Object creator, double n) {
        this(creator, n, XSD.DOUBLE);
    }

    public byte byteValue() {
        return this.number.byteValue();
    }

    public short shortValue() {
        return this.number.shortValue();
    }

    public int intValue() {
        return this.number.intValue();
    }

    public long longValue() {
        return this.number.longValue();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }
}

