/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Optional;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class Literals {
    public static String getLabel(Literal l, String fallback) {
        return l != null ? l.getLabel() : fallback;
    }

    public static String getLabel(Value v, String fallback) {
        return v instanceof Literal ? Literals.getLabel((Literal)v, fallback) : fallback;
    }

    public static String getLabel(Optional<Value> v, String fallback) {
        return v != null ? Literals.getLabel(v.orElseGet(null), fallback) : fallback;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public static Optional<XSD.Datatype> getXsdDatatype(Literal l) {
        if (l instanceof SimpleLiteral) {
            return ((SimpleLiteral)l).getXsdDatatype();
        }
        return Optional.empty();
    }

    public static byte getByteValue(Literal l, byte fallback) {
        try {
            return l.byteValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static byte getByteValue(Value v, byte fallback) {
        if (v instanceof Literal) {
            return Literals.getByteValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static short getShortValue(Literal l, short fallback) {
        try {
            return l.shortValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static short getShortValue(Value v, short fallback) {
        if (v instanceof Literal) {
            return Literals.getShortValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static int getIntValue(Literal l, int fallback) {
        try {
            return l.intValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static int getIntValue(Value v, int fallback) {
        if (v instanceof Literal) {
            return Literals.getIntValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static long getLongValue(Literal l, long fallback) {
        try {
            return l.longValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static long getLongValue(Value v, long fallback) {
        if (v instanceof Literal) {
            return Literals.getLongValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static BigInteger getIntegerValue(Literal l, BigInteger fallback) {
        try {
            return l.integerValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static BigInteger getIntegerValue(Value v, BigInteger fallback) {
        if (v instanceof Literal) {
            return Literals.getIntegerValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static BigDecimal getDecimalValue(Literal l, BigDecimal fallback) {
        try {
            return l.decimalValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static BigDecimal getDecimalValue(Value v, BigDecimal fallback) {
        if (v instanceof Literal) {
            return Literals.getDecimalValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static float getFloatValue(Literal l, float fallback) {
        try {
            return l.floatValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static float getFloatValue(Value v, float fallback) {
        if (v instanceof Literal) {
            return Literals.getFloatValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static double getDoubleValue(Literal l, double fallback) {
        try {
            return l.doubleValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static double getDoubleValue(Value v, double fallback) {
        if (v instanceof Literal) {
            return Literals.getDoubleValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static boolean getBooleanValue(Literal l, boolean fallback) {
        try {
            return l.booleanValue();
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public static boolean getBooleanValue(Value v, boolean fallback) {
        if (v instanceof Literal) {
            return Literals.getBooleanValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static XMLGregorianCalendar getCalendarValue(Literal l, XMLGregorianCalendar fallback) {
        try {
            return l.calendarValue();
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public static Duration getDurationValue(Literal l, Duration fallback) {
        try {
            return XMLDatatypeUtil.parseDuration(l.getLabel());
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static XMLGregorianCalendar getCalendarValue(Value v, XMLGregorianCalendar fallback) {
        if (v instanceof Literal) {
            return Literals.getCalendarValue((Literal)v, fallback);
        }
        return fallback;
    }

    @Deprecated(since="3.5.0")
    public static Literal createLiteral(ValueFactory valueFactory, Object object) {
        try {
            return Literals.createLiteral(valueFactory, object, false);
        }
        catch (LiteralUtilException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated(since="3.5.0")
    public static Literal createLiteralOrFail(ValueFactory valueFactory, Object object) throws LiteralUtilException {
        return Literals.createLiteral(valueFactory, object, true);
    }

    private static Literal createLiteral(ValueFactory valueFactory, Object object, boolean throwExceptionOnFailure) throws LiteralUtilException {
        if (object == null) {
            throw new NullPointerException("Cannot create a literal from a null");
        }
        if (object instanceof Boolean) {
            return valueFactory.createLiteral((Boolean)object);
        }
        if (object instanceof Byte) {
            return valueFactory.createLiteral((Byte)object);
        }
        if (object instanceof Double) {
            return valueFactory.createLiteral((Double)object);
        }
        if (object instanceof Float) {
            return valueFactory.createLiteral(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return valueFactory.createLiteral((Integer)object);
        }
        if (object instanceof Long) {
            return valueFactory.createLiteral((Long)object);
        }
        if (object instanceof Short) {
            return valueFactory.createLiteral((Short)object);
        }
        if (object instanceof XMLGregorianCalendar) {
            return valueFactory.createLiteral((XMLGregorianCalendar)object);
        }
        if (object instanceof Date) {
            return valueFactory.createLiteral((Date)object);
        }
        if (object instanceof String) {
            return valueFactory.createLiteral(object.toString(), CoreDatatype.XSD.STRING);
        }
        if (throwExceptionOnFailure) {
            throw new LiteralUtilException("Did not recognise object when creating literal");
        }
        return valueFactory.createLiteral(object.toString(), CoreDatatype.XSD.STRING);
    }

    @Deprecated
    public static boolean canCreateLiteral(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Boolean || object instanceof Byte || object instanceof Double || object instanceof Float || object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof XMLGregorianCalendar || object instanceof Date || object instanceof String;
    }

    public static boolean isLanguageLiteral(Literal literal) {
        return literal.getCoreDatatype() == CoreDatatype.RDF.LANGSTRING;
    }

    public static String normalizeLanguageTag(String languageTag) throws IllformedLocaleException {
        new Locale.Builder().setLanguageTag(languageTag);
        String normalizedTag = languageTag.toLowerCase();
        CharSequence[] subtags = normalizedTag.split("-");
        for (int i = 1; i < subtags.length; ++i) {
            String subtag = subtags[i];
            if (subtag.length() == 2) {
                if (((String)subtags[i - 1]).length() <= 1 || !subtag.matches("\\w\\w")) continue;
                subtags[i] = subtag.toUpperCase();
                continue;
            }
            if (subtag.length() != 4 || ((String)subtags[i - 1]).length() <= 1 || !subtag.matches("\\w\\w\\w\\w")) continue;
            subtags[i] = subtag.substring(0, 1).toUpperCase() + subtag.substring(1);
        }
        return String.join((CharSequence)"-", subtags);
    }

    public static boolean isValidLanguageTag(String languageTag) {
        try {
            new Locale.Builder().setLanguageTag(languageTag);
            return true;
        }
        catch (IllformedLocaleException e) {
            return false;
        }
    }

    public static boolean langMatches(String langTag, String langRange) {
        boolean result = false;
        if (langRange.equals("*")) {
            result = langTag.length() > 0;
        } else if (langTag.length() == langRange.length()) {
            result = langTag.equalsIgnoreCase(langRange);
        } else if (langTag.length() > langRange.length()) {
            String prefix = langTag.substring(0, langRange.length());
            result = prefix.equalsIgnoreCase(langRange) && langTag.charAt(langRange.length()) == '-';
        }
        return result;
    }

    protected Literals() {
    }
}

