/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValueInFilter;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class HasValueConstraintComponent
extends AbstractConstraintComponent {
    private final Value hasValue;

    public HasValueConstraintComponent(Value hasValue) {
        this.hasValue = hasValue;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.HAS_VALUE, this.hasValue, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.HasValueConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new HasValueConstraintComponent(this.hasValue);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget target = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode addedTargets;
            Path path = this.getTargetChain().getPath().get();
            if (overrideTargetNode != null) {
                addedTargets = target.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            } else {
                addedTargets = target.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, true, null);
                PlanNode addedByPath = path.getAllAdded(connectionsGroup, validationSettings.getDataGraph(), null);
                addedByPath = target.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), Unique.getInstance(new TrimToTarget(addedByPath), false));
                addedByPath = target.extend(addedByPath, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
                addedTargets = UnionNode.getInstance(addedByPath, addedTargets);
                addedTargets = Unique.getInstance(addedTargets, false);
            }
            BulkedExternalLeftOuterJoin joined = new BulkedExternalLeftOuterJoin(addedTargets, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()));
            GroupByFilter invalidTargets = new GroupByFilter(joined, group -> group.stream().map(ValidationTuple::getValue).noneMatch(v -> this.hasValue.equals(v)));
            return Unique.getInstance(new TrimToTarget(invalidTargets), false);
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode addedTargets = overrideTargetNode != null ? target.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null) : target.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
            PlanNode falseNode = new ValueInFilter(addedTargets, new HashSet<Value>(Collections.singletonList(this.hasValue))).getFalseNode(UnBufferedPlanNode.class);
            return falseNode;
        }
        throw new UnsupportedOperationException("Unknown scope: " + scope);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            return Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return EmptyNode.getInstance();
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable<Value> subject, StatementMatcher.Variable<Value> object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            Path path = this.getTargetChain().getPath().get();
            SparqlFragment targetQueryFragment = path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner, stableRandomVariableProvider, Set.of());
            return SparqlFragment.bgp(List.of(), "BIND(" + this.stringRepresentationOfValue(this.hasValue) + " as " + object.asSparqlVariable() + ")\n" + targetQueryFragment.getFragment(), StatementMatcher.swap(targetQueryFragment.getStatementMatchers(), object, new StatementMatcher.Variable<Value>(this.hasValue)), null);
        }
        return SparqlFragment.filterCondition(List.of(), object.asSparqlVariable() + " = " + this.stringRepresentationOfValue(this.hasValue), List.of());
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        if (scope == ConstraintComponent.Scope.nodeShape) {
            query = (String)query + "\nFILTER(" + effectiveTarget.getTargetVar().asSparqlVariable() + " != " + this.stringRepresentationOfValue(this.hasValue) + ")";
        } else {
            StatementMatcher.Variable<Value> value = StatementMatcher.Variable.VALUE;
            String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new).getFragment();
            query = (String)query + "\nFILTER( NOT EXISTS{\tBIND(" + this.stringRepresentationOfValue(this.hasValue) + " as " + value.asSparqlVariable() + ")\n" + pathQuery + "\n})";
        }
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, null, scope, this, null, null);
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasValueConstraintComponent that = (HasValueConstraintComponent)o;
        return this.hasValue.equals(that.hasValue);
    }

    public int hashCode() {
        return this.hasValue.hashCode() + "HasValueConstraintComponent".hashCode();
    }
}

