/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnectionWrapper;
import org.eclipse.rdf4j.sail.inferencer.fc.config.CustomGraphQueryInferencerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGraphQueryInferencer
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(CustomGraphQueryInferencer.class);
    private ParsedGraphQuery customQuery;
    private ParsedGraphQuery customMatcher;
    private final Collection<Value> watchPredicates = new HashSet<Value>();
    private final Collection<Value> watchSubjects = new HashSet<Value>();
    private final Collection<Value> watchObjects = new HashSet<Value>();
    private boolean hasWatchValues;

    public CustomGraphQueryInferencer() {
    }

    public CustomGraphQueryInferencer(QueryLanguage language, String queryText, String matcherText) throws MalformedQueryException, UnsupportedQueryLanguageException, SailException {
        this.setFields(language, queryText, matcherText);
    }

    public CustomGraphQueryInferencer(NotifyingSail baseSail, QueryLanguage language, String queryText, String matcherText) throws MalformedQueryException, UnsupportedQueryLanguageException, SailException {
        super(baseSail);
        this.setFields(language, queryText, matcherText);
    }

    public final void setFields(QueryLanguage language, String queryText, String matcherText) throws MalformedQueryException, SailException {
        this.customQuery = QueryParserUtil.parseGraphQuery((QueryLanguage)language, (String)queryText, null);
        String matcherQuery = matcherText;
        if (matcherText.trim().isEmpty()) {
            matcherQuery = CustomGraphQueryInferencerConfig.buildMatcherQueryFromRuleQuery(language, queryText);
        }
        this.customMatcher = QueryParserUtil.parseGraphQuery((QueryLanguage)language, (String)matcherQuery, null);
        this.customQuery.getTupleExpr().visit((QueryModelVisitor)new AbstractQueryModelVisitor<SailException>(){

            public void meet(StatementPattern statement) throws SailException {
                Var var = statement.getSubjectVar();
                if (var.hasValue()) {
                    CustomGraphQueryInferencer.this.watchSubjects.add(var.getValue());
                }
                if ((var = statement.getPredicateVar()).hasValue()) {
                    CustomGraphQueryInferencer.this.watchPredicates.add(var.getValue());
                }
                if ((var = statement.getObjectVar()).hasValue()) {
                    CustomGraphQueryInferencer.this.watchObjects.add(var.getValue());
                }
            }
        });
        this.hasWatchValues = !this.watchSubjects.isEmpty() || !this.watchPredicates.isEmpty() || !this.watchObjects.isEmpty();
    }

    public InferencerConnection getConnection() throws SailException {
        try {
            InferencerConnection con = (InferencerConnection)super.getConnection();
            return new Connection(con);
        }
        catch (ClassCastException e) {
            throw new SailException(e.getMessage(), (Throwable)e);
        }
    }

    public void init() throws SailException {
        super.init();
        try (InferencerConnection con = this.getConnection();){
            con.begin();
            con.flushUpdates();
            con.commit();
        }
    }

    public Collection<Value> getWatchSubjects() {
        return Collections.unmodifiableCollection(this.watchSubjects);
    }

    public Collection<Value> getWatchPredicates() {
        return Collections.unmodifiableCollection(this.watchPredicates);
    }

    public Collection<Value> getWatchObjects() {
        return Collections.unmodifiableCollection(this.watchObjects);
    }

    private class Connection
    extends InferencerConnectionWrapper
    implements SailConnectionListener {
        private boolean updateNeeded;

        private Connection(InferencerConnection con) {
            super(con);
            this.updateNeeded = false;
            con.addConnectionListener((SailConnectionListener)this);
        }

        public void statementAdded(Statement statement) {
            this.setUpdateNeededIfMatching(statement);
        }

        public void statementRemoved(Statement statement) {
            this.setUpdateNeededIfMatching(statement);
        }

        private void setUpdateNeededIfMatching(Statement statement) {
            this.updateNeeded = CustomGraphQueryInferencer.this.hasWatchValues ? CustomGraphQueryInferencer.this.watchPredicates.contains(statement.getPredicate()) || CustomGraphQueryInferencer.this.watchSubjects.contains(statement.getSubject()) || CustomGraphQueryInferencer.this.watchObjects.contains(statement.getObject()) : true;
        }

        public void rollback() throws SailException {
            super.rollback();
            this.updateNeeded = false;
        }

        public void flushUpdates() throws SailException {
            super.flushUpdates();
            HashSet<Statement> forRemoval = new HashSet<Statement>(256);
            HashSet<Statement> forAddition = new HashSet<Statement>(256);
            Resource[] contexts = new Resource[]{null};
            while (this.updateNeeded) {
                try {
                    forRemoval.clear();
                    forAddition.clear();
                    this.buildDeltaSets(forRemoval, forAddition);
                    for (Statement st : forRemoval) {
                        this.removeInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    for (Statement st : forAddition) {
                        this.addInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    this.updateNeeded = false;
                }
                catch (RDFHandlerException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof SailException) {
                        throw (SailException)cause;
                    }
                    throw new SailException(cause);
                }
                catch (QueryEvaluationException e) {
                    throw new SailException((Throwable)e);
                }
                super.flushUpdates();
            }
        }

        private void buildDeltaSets(Collection<Statement> forRemoval, Collection<Statement> forAddition) throws SailException, RDFHandlerException, QueryEvaluationException {
            this.evaluateIntoStatements(CustomGraphQueryInferencer.this.customMatcher, forRemoval);
            this.evaluateIntoStatements(CustomGraphQueryInferencer.this.customQuery, forAddition);
            logger.debug("existing virtual properties: {}", (Object)forRemoval.size());
            logger.debug("new virtual properties: {}", (Object)forAddition.size());
            HashSet<Statement> inCommon = new HashSet<Statement>(forRemoval);
            inCommon.retainAll(forAddition);
            forRemoval.removeAll(inCommon);
            forAddition.removeAll(inCommon);
            logger.debug("virtual properties to remove: {}", (Object)forRemoval.size());
            logger.debug("virtual properties to add: {}", (Object)forAddition.size());
        }

        private void evaluateIntoStatements(ParsedGraphQuery query, Collection<Statement> statements) throws SailException, RDFHandlerException, QueryEvaluationException {
            try (CloseableIteration bindingsIter = this.getWrappedConnection().evaluate(query.getTupleExpr(), null, EmptyBindingSet.getInstance(), true);){
                ValueFactory factory = CustomGraphQueryInferencer.this.getValueFactory();
                while (bindingsIter.hasNext()) {
                    BindingSet bindings = (BindingSet)bindingsIter.next();
                    Value subj = bindings.getValue("subject");
                    Value pred = bindings.getValue("predicate");
                    Value obj = bindings.getValue("object");
                    if (!(subj instanceof Resource) || !(pred instanceof IRI) || obj == null) continue;
                    statements.add(factory.createStatement((Resource)subj, (IRI)pred, obj));
                }
            }
        }
    }
}

