/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class ExtensionIterator
extends ConvertingIteration<BindingSet, BindingSet> {
    private final Consumer<MutableBindingSet> setter;
    private final QueryEvaluationContext context;

    public ExtensionIterator(Extension extension, CloseableIteration<BindingSet> iter, EvaluationStrategy strategy, QueryEvaluationContext context) throws QueryEvaluationException {
        super(iter);
        this.context = context;
        this.setter = ExtensionIterator.buildLambdaToEvaluateTheExpressions(extension, strategy, context);
    }

    public ExtensionIterator(CloseableIteration<BindingSet> iter, Consumer<MutableBindingSet> setter, QueryEvaluationContext context) throws QueryEvaluationException {
        super(iter);
        this.setter = setter;
        this.context = context;
    }

    public static Consumer<MutableBindingSet> buildLambdaToEvaluateTheExpressions(Extension extension, EvaluationStrategy strategy, QueryEvaluationContext context) {
        Consumer<MutableBindingSet> consumer = null;
        for (ExtensionElem extElem : extension.getElements()) {
            ValueExpr expr = extElem.getExpr();
            if (expr instanceof AggregateOperator) continue;
            QueryValueEvaluationStep prepared = strategy.precompile(extElem.getExpr(), context);
            BiConsumer<Value, MutableBindingSet> setBinding = context.setBinding(extElem.getName());
            consumer = ExtensionIterator.andThen(consumer, targetBindings -> ExtensionIterator.setValue(setBinding, prepared, targetBindings));
        }
        if (consumer == null) {
            return bs -> {};
        }
        return consumer;
    }

    private static void setValue(BiConsumer<Value, MutableBindingSet> setBinding, QueryValueEvaluationStep prepared, MutableBindingSet targetBindings) {
        try {
            Value targetValue = prepared.evaluate((BindingSet)targetBindings);
            if (targetValue != null) {
                setBinding.accept(targetValue, targetBindings);
            }
        }
        catch (ValueExprEvaluationException e) {
            setBinding.accept(null, targetBindings);
        }
    }

    private static Consumer<MutableBindingSet> andThen(Consumer<MutableBindingSet> consumer, Consumer<MutableBindingSet> next) {
        if (consumer == null) {
            return next;
        }
        return consumer.andThen(next);
    }

    public BindingSet convert(BindingSet sourceBindings) throws QueryEvaluationException {
        MutableBindingSet targetBindings = this.context.createBindingSet(sourceBindings);
        this.setter.accept(targetBindings);
        return targetBindings;
    }
}

