/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.NamespaceAware;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.ContextStatementCollector;
import org.eclipse.rdf4j.rio.helpers.ParseErrorLogger;

public class Rio {
    public static Optional<RDFFormat> getParserFormatForMIMEType(String mimeType) {
        return RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFParserRegistry.getInstance().getKeys());
    }

    public static Optional<RDFFormat> getParserFormatForFileName(String fileName) {
        return RDFFormat.matchFileName((String)fileName, (Iterable)RDFParserRegistry.getInstance().getKeys());
    }

    public static Optional<RDFFormat> getWriterFormatForMIMEType(String mimeType) {
        return RDFFormat.matchMIMEType((String)mimeType, (Iterable)RDFWriterRegistry.getInstance().getKeys());
    }

    public static Optional<RDFFormat> getWriterFormatForFileName(String fileName) {
        return RDFFormat.matchFileName((String)fileName, (Iterable)RDFWriterRegistry.getInstance().getKeys());
    }

    public static RDFParser createParser(RDFFormat format) throws UnsupportedRDFormatException {
        RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getParser();
    }

    public static RDFParser createParser(RDFFormat format, ValueFactory valueFactory) throws UnsupportedRDFormatException {
        RDFParser rdfParser = Rio.createParser(format);
        rdfParser.setValueFactory(valueFactory);
        return rdfParser;
    }

    public static RDFWriter createWriter(RDFFormat format, OutputStream out) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getWriter(out);
    }

    public static RDFWriter createWriter(RDFFormat format, OutputStream out, String baseURI) throws UnsupportedRDFormatException, URISyntaxException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getWriter(out, baseURI);
    }

    public static RDFWriter createWriter(RDFFormat format, Writer writer) throws UnsupportedRDFormatException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getWriter(writer);
    }

    public static RDFWriter createWriter(RDFFormat format, Writer writer, String baseURI) throws UnsupportedRDFormatException, URISyntaxException {
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(Rio.unsupportedFormat(format));
        return factory.getWriter(writer, baseURI);
    }

    public static Model parse(InputStream in, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, null, dataFormat, new ParserConfig(), (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(InputStream in, RDFFormat dataFormat, ParserConfig settings, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, null, dataFormat, settings, (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, baseURI, dataFormat, new ParserConfig(), (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, ParserConfig settings, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, baseURI, dataFormat, settings, (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(in, baseURI, dataFormat, settings, valueFactory, errors, (ModelFactory)new DynamicModelFactory(), contexts);
    }

    public static Model parse(InputStream in, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, ModelFactory modelFactory, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        Model result = modelFactory.createEmptyModel();
        RDFParser parser = Rio.createParser(dataFormat, valueFactory);
        parser.setParserConfig(settings);
        parser.setParseErrorListener(errors);
        parser.setRDFHandler(new ContextStatementCollector((Collection<Statement>)result, valueFactory, contexts));
        parser.parse(in, baseURI);
        return result;
    }

    public static Model parse(Reader reader, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(reader, null, dataFormat, new ParserConfig(), (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(Reader reader, RDFFormat dataFormat, ParserConfig settings, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(reader, null, dataFormat, settings, (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(reader, baseURI, dataFormat, new ParserConfig(), (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), contexts);
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        return Rio.parse(reader, baseURI, dataFormat, settings, valueFactory, errors, (ModelFactory)new DynamicModelFactory(), contexts);
    }

    public static Model parse(Reader reader, String baseURI, RDFFormat dataFormat, ParserConfig settings, ValueFactory valueFactory, ParseErrorListener errors, ModelFactory modelFactory, Resource ... contexts) throws IOException, RDFParseException, UnsupportedRDFormatException {
        Model result = modelFactory.createEmptyModel();
        RDFParser parser = Rio.createParser(dataFormat, valueFactory);
        parser.setParserConfig(settings);
        parser.setParseErrorListener(errors);
        parser.setRDFHandler(new ContextStatementCollector((Collection<Statement>)result, valueFactory, contexts));
        parser.parse(reader, baseURI);
        return result;
    }

    public static void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(model, output, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, OutputStream output, String baseURI, RDFFormat dataFormat) throws RDFHandlerException, UnsupportedRDFormatException, URISyntaxException {
        Rio.write(model, output, baseURI, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, Writer output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(model, output, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, Writer output, String baseURI, RDFFormat dataFormat) throws RDFHandlerException, UnsupportedRDFormatException, URISyntaxException {
        Rio.write(model, output, baseURI, dataFormat, new WriterConfig());
    }

    public static void write(Iterable<Statement> model, OutputStream output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, OutputStream output, String baseURI, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException, UnsupportedRDFormatException, URISyntaxException {
        RDFWriter writer = Rio.createWriter(dataFormat, output, baseURI);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, Writer output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, Writer output, String baseURI, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException, UnsupportedRDFormatException, URISyntaxException {
        RDFWriter writer = Rio.createWriter(dataFormat, output, baseURI);
        writer.setWriterConfig(settings);
        Rio.write(model, (RDFHandler)writer);
    }

    public static void write(Iterable<Statement> model, RDFHandler writer) throws RDFHandlerException {
        writer.startRDF();
        if (model instanceof NamespaceAware) {
            for (Namespace nextNamespace : ((NamespaceAware)model).getNamespaces()) {
                writer.handleNamespace(nextNamespace.getPrefix(), nextNamespace.getName());
            }
        }
        for (Statement st : model) {
            writer.handleStatement(st);
        }
        writer.endRDF();
    }

    public static void write(Statement st, OutputStream output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(st, output, dataFormat, new WriterConfig());
    }

    public static void write(Statement st, OutputStream output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(st, (RDFHandler)writer);
    }

    public static void write(Statement statement, Writer output, RDFFormat dataFormat) throws RDFHandlerException {
        Rio.write(statement, output, dataFormat, new WriterConfig());
    }

    public static void write(Statement statement, Writer output, RDFFormat dataFormat, WriterConfig settings) throws RDFHandlerException {
        RDFWriter writer = Rio.createWriter(dataFormat, output);
        writer.setWriterConfig(settings);
        Rio.write(statement, (RDFHandler)writer);
    }

    public static void write(Statement statement, RDFHandler writer) throws RDFHandlerException {
        writer.startRDF();
        writer.handleStatement(statement);
        writer.endRDF();
    }

    public static void main(String[] args) throws IOException, RDFParseException, RDFHandlerException, UnsupportedRDFormatException {
        if (args.length < 2) {
            System.out.println("Usage: java org.eclipse.rdf4j.rio.Rio <inputFile> <outputFile>");
            System.exit(1);
            return;
        }
        String inputFile = args[0];
        String outputFile = args[1];
        try (FileOutputStream outStream = new FileOutputStream(outputFile);
             FileInputStream inStream = new FileInputStream(inputFile);){
            Rio.createParser(Rio.getParserFormatForFileName(inputFile).orElse(RDFFormat.RDFXML)).setRDFHandler(Rio.createWriter(Rio.getWriterFormatForFileName(outputFile).orElse(RDFFormat.RDFXML), outStream)).parse(inStream, "file:" + inputFile);
        }
    }

    public static Supplier<UnsupportedRDFormatException> unsupportedFormat(RDFFormat unsupportedFormat) {
        return () -> new UnsupportedRDFormatException("Did not recognise RDF format object " + unsupportedFormat);
    }

    public static Supplier<UnsupportedRDFormatException> unsupportedFormat(String unsupportedFormat) {
        return () -> new UnsupportedRDFormatException("Did not recognise RDF format string " + unsupportedFormat);
    }
}

