/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NodeKindFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class NodeKindConstraintComponent
extends SimpleAbstractConstraintComponent {
    NodeKind nodeKind;

    public NodeKindConstraintComponent(Resource nodeKind) {
        this.nodeKind = NodeKind.from(nodeKind);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return "(isIRI(" + variable.asSparqlVariable() + ") && <" + this.nodeKind.iri + "> IN ( <" + SHACL.IRI + ">, <" + SHACL.BLANK_NODE_OR_IRI + ">, <" + SHACL.IRI_OR_LITERAL + "> ) ) ||\n(isLiteral(" + variable.asSparqlVariable() + ") && <" + this.nodeKind.iri + "> IN ( <" + SHACL.LITERAL + ">, <" + SHACL.BLANK_NODE_OR_LITERAL + ">, <" + SHACL.IRI_OR_LITERAL + "> ) ) ||\n(isBlank(" + variable.asSparqlVariable() + ") && <" + this.nodeKind.iri + "> IN ( <" + SHACL.BLANK_NODE + ">, <" + SHACL.BLANK_NODE_OR_IRI + ">, <" + SHACL.BLANK_NODE_OR_LITERAL + "> ) )";
        }
        return "!((isIRI(" + variable.asSparqlVariable() + ") && <" + this.nodeKind.iri + "> IN ( <" + SHACL.IRI + ">, <" + SHACL.BLANK_NODE_OR_IRI + ">, <" + SHACL.IRI_OR_LITERAL + "> ) ) ||\n(isLiteral(" + variable.asSparqlVariable() + ") && <" + this.nodeKind.iri + "> IN ( <" + SHACL.LITERAL + ">, <" + SHACL.BLANK_NODE_OR_LITERAL + ">, <" + SHACL.IRI_OR_LITERAL + "> ) ) ||\n(isBlank(" + variable.asSparqlVariable() + ") && <" + this.nodeKind.iri + "> IN ( <" + SHACL.BLANK_NODE + ">, <" + SHACL.BLANK_NODE_OR_IRI + ">, <" + SHACL.BLANK_NODE_OR_LITERAL + "> ) ))";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.NODE_KIND_PROP, this.nodeKind.iri, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.NodeKindConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new NodeKindConstraintComponent(this.nodeKind.iri);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new NodeKindFilter((PlanNode)parent, this.nodeKind);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeKindConstraintComponent that = (NodeKindConstraintComponent)o;
        return this.nodeKind == that.nodeKind;
    }

    public int hashCode() {
        return this.nodeKind.hashCode() + "NodeKindConstraintComponent".hashCode();
    }

    public static enum NodeKind {
        BlankNode(SHACL.BLANK_NODE),
        IRI(SHACL.IRI),
        Literal(SHACL.LITERAL),
        BlankNodeOrIRI(SHACL.BLANK_NODE_OR_IRI),
        BlankNodeOrLiteral(SHACL.BLANK_NODE_OR_LITERAL),
        IRIOrLiteral(SHACL.IRI_OR_LITERAL);

        private final IRI iri;

        private NodeKind(IRI iri) {
            this.iri = iri;
        }

        public static NodeKind from(Resource resource) {
            for (NodeKind value : NodeKind.values()) {
                if (!value.iri.equals(resource)) continue;
                return value;
            }
            throw new IllegalStateException("Unknown nodeKind: " + resource);
        }
    }
}

