/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class NotValuesIn
implements PlanNode {
    private final PlanNode parent;
    private final PlanNode notIn;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public NotValuesIn(PlanNode parent, PlanNode notIn, ConnectionsGroup connectionsGroup) {
        this.parent = PlanNodeHelper.handleSorting(this, parent, connectionsGroup);
        this.notIn = notIn;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> parentIterator;
            Set<Value> notInValueSet;
            ValidationTuple next;

            @Override
            protected void init() {
                assert (this.notInValueSet == null);
                this.parentIterator = NotValuesIn.this.parent.iterator();
                if (!this.parentIterator.hasNext()) {
                    this.notInValueSet = Set.of();
                } else {
                    this.notInValueSet = new HashSet<Value>();
                    try (CloseableIteration<? extends ValidationTuple> iterator = NotValuesIn.this.notIn.iterator();){
                        while (iterator.hasNext()) {
                            this.notInValueSet.add(((ValidationTuple)iterator.next()).getValue());
                        }
                    }
                    if (this.notInValueSet.isEmpty()) {
                        this.notInValueSet = Collections.emptySet();
                    }
                }
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    if (this.notInValueSet.contains(temp.getValue())) continue;
                    this.next = temp;
                }
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public void localClose() {
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        stringBuilder.append(this.notIn.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
        this.notIn.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "NotValuesIn";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
        this.notIn.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotValuesIn that = (NotValuesIn)o;
        return this.parent.equals(that.parent) && this.notIn.equals(that.notIn);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.notIn);
    }
}

