/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.solr.SolrSearchDocument;
import org.eclipse.rdf4j.sail.solr.SolrUtil;

public class SolrBulkUpdater
implements BulkUpdater {
    private final SolrClient client;
    private final List<SolrInputDocument> addOrUpdateList = new ArrayList<SolrInputDocument>();
    private final List<String> deleteList = new ArrayList<String>();

    public SolrBulkUpdater(SolrClient client) {
        this.client = client;
    }

    public void add(SearchDocument doc) throws IOException {
        SolrDocument document = ((SolrSearchDocument)doc).getDocument();
        this.addOrUpdateList.add(SolrUtil.toSolrInputDocument(document));
    }

    public void update(SearchDocument doc) throws IOException {
        this.add(doc);
    }

    public void delete(SearchDocument doc) throws IOException {
        this.deleteList.add(doc.getId());
    }

    public void end() throws IOException {
        try {
            if (!this.deleteList.isEmpty()) {
                this.client.deleteById(this.deleteList);
            }
            if (!this.addOrUpdateList.isEmpty()) {
                this.client.add(this.addOrUpdateList);
            }
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }
}

