/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.expansion;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.context.ActiveContext;
import no.hasmac.jsonld.context.TermDefinition;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.BlankNode;
import no.hasmac.jsonld.lang.Keywords;
import no.hasmac.jsonld.uri.UriResolver;
import no.hasmac.jsonld.uri.UriUtils;

public final class UriExpansion {
    private static final Logger LOGGER = Logger.getLogger(UriExpansion.class.getName());
    private final ActiveContext activeContext;
    private boolean documentRelative;
    private boolean vocab;
    private boolean uriValidation;
    private JsonObject localContext;
    private Map<String, Boolean> defined;

    private UriExpansion(ActiveContext activeContext) {
        this.activeContext = activeContext;
        this.documentRelative = false;
        this.vocab = false;
        this.localContext = null;
        this.defined = null;
        this.uriValidation = true;
    }

    public static UriExpansion with(ActiveContext activeContext) {
        return new UriExpansion(activeContext);
    }

    public UriExpansion documentRelative(boolean value) {
        this.documentRelative = value;
        return this;
    }

    public UriExpansion vocab(boolean value) {
        this.vocab = value;
        return this;
    }

    public UriExpansion localContext(JsonObject value) {
        this.localContext = value;
        return this;
    }

    public UriExpansion defined(Map<String, Boolean> value) {
        this.defined = value;
        return this;
    }

    public String expand(String value) throws JsonLdError {
        if (value == null || Keywords.contains(value)) {
            return value;
        }
        if (Keywords.matchForm(value)) {
            LOGGER.log(Level.WARNING, "Value [{0}] of keyword form [@1*ALPHA] is not allowed.", value);
            if (this.activeContext.getOptions().isExceptionOnWarning()) {
                throw new JsonLdError(JsonLdErrorCode.UNSPECIFIED, "Value [" + value + "] keyword form [@1*ALPHA] is not allowed.");
            }
            return null;
        }
        this.initLocalContext(value);
        TermDefinition definition = this.activeContext.getTermNullable(value);
        if (definition != null && (Keywords.contains(definition.getUriMapping()) || this.vocab)) {
            return definition.getUriMapping();
        }
        String result = value;
        int indexOfColon = result.indexOf(58, 1);
        if (indexOfColon != -1) {
            String right;
            if (indexOfColon == 1 && result.charAt(0) == '_') {
                return result;
            }
            if (result.length() > indexOfColon + 2 && result.charAt(indexOfColon + 1) == '/' && result.charAt(indexOfColon + 2) == '/') {
                return result;
            }
            String left = result.substring(0, indexOfColon);
            if (BlankNode.hasPrefix(result = this.initPropertyContext(left, right = result.substring(indexOfColon + 1), result)) || UriUtils.isAbsoluteUri(result, this.uriValidation)) {
                return result;
            }
        }
        return this.expandResult(result);
    }

    private void initLocalContext(String value) throws JsonLdError {
        String entryValueString;
        JsonValue entryValue;
        if (this.localContext != null && (entryValue = (JsonValue)this.localContext.get((Object)value)) != null && JsonUtils.isString(entryValue) && this.notDefined(entryValueString = ((JsonString)entryValue).getString())) {
            this.activeContext.newTerm(this.localContext, this.defined).create(value);
        }
    }

    private boolean notDefined(String entryValueString) {
        Boolean b = this.defined.get(entryValueString);
        return b == null || b == false;
    }

    private String initPropertyContext(String prefix, String suffix, String result) throws JsonLdError {
        TermDefinition prefixDefinition;
        if (this.localContext != null && this.notDefined(prefix) && this.localContext.containsKey((Object)prefix)) {
            this.activeContext.newTerm(this.localContext, this.defined).create(prefix);
        }
        if ((prefixDefinition = this.activeContext.getPrefix(prefix)) != null && prefixDefinition.isPrefix()) {
            String uriMapping = prefixDefinition.getUriMapping();
            if (uriMapping != null) {
                return uriMapping.concat(suffix);
            }
            return result;
        }
        return result;
    }

    private String expandResult(String result) {
        if (this.vocab && this.activeContext.getVocabularyMapping() != null) {
            return this.activeContext.getVocabularyMapping().concat(result);
        }
        if (this.documentRelative) {
            return UriResolver.resolve(this.activeContext.getBaseUri(), result);
        }
        return result;
    }

    public UriExpansion uriValidation(boolean uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }
}

