/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LogicalOperatorConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EqualsJoinValue;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class OrConstraintComponent
extends LogicalOperatorConstraintComponent {
    List<Shape> or;

    public OrConstraintComponent(Resource id, ShapeSource shapeSource, Shape.ParseSettings parseSettings, Cache cache) {
        super(id);
        this.or = ShaclAstLists.toList(shapeSource, id, Resource.class).stream().map(r -> new ShaclProperties((Resource)r, shapeSource)).map(p -> {
            if (p.getType() == SHACL.NODE_SHAPE) {
                return NodeShape.getInstance(p, shapeSource, parseSettings, cache);
            }
            if (p.getType() == SHACL.PROPERTY_SHAPE) {
                return PropertyShape.getInstance(p, shapeSource, parseSettings, cache);
            }
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }).collect(Collectors.toList());
    }

    public OrConstraintComponent(OrConstraintComponent orConstraintComponent) {
        super(orConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.OR, this.getId(), new Resource[0]);
        if (!cycleDetection.contains(this.getId())) {
            cycleDetection.add(this.getId());
            this.or.forEach(o -> o.toModel(null, null, model, cycleDetection));
        }
        if (!model.contains(this.getId(), null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(this.or.stream().map(Shape::getId).collect(Collectors.toList()), this.getId(), model);
        }
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        for (Shape shape : this.or) {
            shape.setTargetChain(targetChain.setOptimizable(false));
        }
    }

    public List<Shape> getOr() {
        return Collections.unmodifiableList(this.or);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.OrConstraintComponent;
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        PlanNodeProvider planNodeProvider = overrideTargetNode != null ? overrideTargetNode : BufferedSplitter.getInstance(this.getAllTargetsPlan(connectionsGroup, validationSettings.getDataGraph(), scope, stableRandomVariableProvider), false);
        PlanNode orPlanNodes = this.or.stream().map(or -> or.generateTransactionalValidationPlan(connectionsGroup, validationSettings, planNodeProvider, scope)).reduce((a, b) -> new EqualsJoinValue((PlanNode)a, (PlanNode)b, false, connectionsGroup)).orElse(EmptyNode.getInstance());
        return Unique.getInstance(orPlanNodes, false, connectionsGroup);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        PlanNode allTargets;
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            allTargets = Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan, connectionsGroup), true, connectionsGroup);
        } else {
            allTargets = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, scope, true, null);
        }
        PlanNode planNode = this.or.stream().map(or -> or.getAllTargetsPlan(connectionsGroup, dataGraph, scope, new StatementMatcher.StableRandomVariableProvider())).distinct().reduce((nodes, nodes2) -> UnionNode.getInstanceDedupe(connectionsGroup, nodes, nodes2)).orElse(EmptyNode.getInstance());
        return Unique.getInstance(UnionNode.getInstanceDedupe(connectionsGroup, allTargets, planNode), false, connectionsGroup);
    }

    @Override
    public ConstraintComponent deepClone() {
        OrConstraintComponent constraintComponent = new OrConstraintComponent(this);
        constraintComponent.or = this.or.stream().map(ConstraintComponent::deepClone).map(a -> (Shape)a).collect(Collectors.toList());
        return constraintComponent;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        for (Shape c : this.or) {
            if (!c.requiresEvaluation(connectionsGroup, scope, dataGraph, stableRandomVariableProvider)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable<Value> subject, StatementMatcher.Variable<Value> object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return OrConstraintComponent.buildSparqlValidNodes_rsx_targetShape_inner(subject, object, rdfsSubClassOfReasoner, scope, stableRandomVariableProvider, this.or, this.getTargetChain(), SparqlFragment::union, SparqlFragment::or);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrConstraintComponent that = (OrConstraintComponent)o;
        return this.or.equals(that.or);
    }

    public int hashCode() {
        return this.or.hashCode() + "OrConstraintComponent".hashCode();
    }
}

