/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import no.hasmac.jsonld.JsonLd;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.serialization.RdfToJsonld;
import no.hasmac.rdf.RdfDataset;
import no.hasmac.rdf.RdfGraph;
import no.hasmac.rdf.RdfLiteral;
import no.hasmac.rdf.RdfNQuad;
import no.hasmac.rdf.RdfResource;
import no.hasmac.rdf.RdfTriple;
import no.hasmac.rdf.RdfValue;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.jsonld.JSONLDMode;
import org.eclipse.rdf4j.rio.jsonld.JSONLDSettings;

public class JSONLDWriter
extends AbstractRDFWriter
implements CharSink {
    private final Model model = new LinkedHashModel();
    private final StatementCollector statementCollector = new StatementCollector((Collection)this.model);
    private final String baseURI;
    private final Writer writer;
    private static final SimpleValueFactory vf = SimpleValueFactory.getInstance();

    public JSONLDWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public JSONLDWriter(OutputStream outputStream, String baseURI) {
        this.baseURI = baseURI;
        this.writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
    }

    public JSONLDWriter(Writer writer) {
        this(writer, null);
    }

    public JSONLDWriter(Writer writer, String baseURI) {
        this.baseURI = baseURI;
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.checkWritingStarted();
        this.model.setNamespace(prefix, uri);
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.statementCollector.clear();
        this.model.clear();
    }

    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            JsonLdOptions opts = new JsonLdOptions();
            WriterConfig writerConfig = this.getWriterConfig();
            if (((Boolean)writerConfig.get((RioSetting)JSONLDSettings.HIERARCHICAL_VIEW)).booleanValue()) {
                throw new UnsupportedOperationException("Hierarchical view is not supported by this JSON-LD processor. Use org.eclipse.rdf4j.rio.jsonld.legacy.JSONLDWriter instead.");
            }
            opts.setCompactArrays(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.COMPACT_ARRAYS)).booleanValue());
            opts.setUseRdfType(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.USE_RDF_TYPE)).booleanValue());
            opts.setUseNativeTypes(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.USE_NATIVE_TYPES)).booleanValue());
            opts.setProduceGeneralizedRdf(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.PRODUCE_GENERALIZED_RDF)).booleanValue());
            opts.setUriValidation(false);
            opts.setExceptionOnWarning(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.EXCEPTION_ON_WARNING)).booleanValue());
            if (this.baseURI != null && ((Boolean)writerConfig.get((RioSetting)BasicWriterSettings.BASE_DIRECTIVE)).booleanValue()) {
                opts.setBase(URI.create(this.baseURI));
            }
            JsonArray jsonld = RdfToJsonld.with((RdfDataset)new RdfDataset(){

                public RdfGraph getDefaultGraph() {
                    return new RdfGraph(){

                        public boolean contains(RdfTriple triple) {
                            return JSONLDWriter.this.model.contains(JSONLDWriter.this.toRdf4jResource(triple.getSubject()), JSONLDWriter.this.toRdf4jIri(triple.getPredicate()), JSONLDWriter.this.toRdf4jValue(triple.getObject()), new Resource[]{null});
                        }

                        public List<RdfTriple> toList() {
                            return JSONLDWriter.this.model.filter(null, null, null, new Resource[]{null}).stream().map(x$0 -> JSONLDWriter.toRdfTriple(x$0)).collect(Collectors.toList());
                        }
                    };
                }

                public RdfDataset add(RdfNQuad nquad) {
                    throw new UnsupportedOperationException();
                }

                public RdfDataset add(RdfTriple triple) {
                    throw new UnsupportedOperationException();
                }

                public List<RdfNQuad> toList() {
                    return JSONLDWriter.this.model.filter(null, null, null, new Resource[0]).stream().map(x$0 -> JSONLDWriter.toRdfNQuad(x$0)).collect(Collectors.toList());
                }

                public Set<RdfResource> getGraphNames() {
                    return JSONLDWriter.this.model.contexts().stream().filter(Objects::nonNull).map(x$0 -> JSONLDWriter.toRdfResource(x$0)).collect(Collectors.toSet());
                }

                public Optional<RdfGraph> getGraph(RdfResource graphName) {
                    final Resource context = JSONLDWriter.this.toRdf4jResource(graphName);
                    if (JSONLDWriter.this.model.contexts().contains(context)) {
                        return Optional.of(new RdfGraph(){

                            public boolean contains(RdfTriple triple) {
                                return JSONLDWriter.this.model.contains(JSONLDWriter.this.toRdf4jResource(triple.getSubject()), JSONLDWriter.this.toRdf4jIri(triple.getPredicate()), JSONLDWriter.this.toRdf4jValue(triple.getObject()), new Resource[]{context});
                            }

                            public List<RdfTriple> toList() {
                                return JSONLDWriter.this.model.filter(null, null, null, new Resource[]{context}).stream().map(x$0 -> JSONLDWriter.toRdfTriple(x$0)).collect(Collectors.toList());
                            }
                        });
                    }
                    return Optional.empty();
                }

                public int size() {
                    return JSONLDWriter.this.model.size();
                }
            }).useNativeTypes(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.USE_NATIVE_TYPES)).booleanValue()).useRdfType(((Boolean)writerConfig.get((RioSetting)JSONLDSettings.USE_RDF_TYPE)).booleanValue()).build();
            JSONLDMode mode = this.mapJsonLdMode(this.getWriterConfig().get(JSONLDSettings.JSONLD_MODE));
            switch (mode) {
                case EXPAND: {
                    jsonld = JsonLd.expand((Document)JsonDocument.of((JsonStructure)jsonld)).options(opts).get();
                    break;
                }
                case FRAME: {
                    Document frame = Objects.requireNonNull((Document)this.getWriterConfig().get(JSONLDSettings.FRAME), "Frame Document is required for JSON-LD mode FRAME");
                    jsonld = JsonLd.frame((Document)JsonDocument.of((JsonStructure)jsonld), (Document)frame).options(opts).get();
                    break;
                }
                case FLATTEN: {
                    jsonld = JsonLd.flatten((Document)JsonDocument.of((JsonStructure)jsonld)).options(opts).get();
                    break;
                }
                case COMPACT: {
                    JsonObjectBuilder context = Json.createObjectBuilder();
                    for (Namespace namespace : this.model.getNamespaces()) {
                        if (namespace.getPrefix().isEmpty()) {
                            context.add("@vocab", namespace.getName());
                            continue;
                        }
                        context.add(namespace.getPrefix(), namespace.getName());
                    }
                    jsonld = JsonLd.compact((Document)JsonDocument.of((JsonStructure)jsonld), (Document)JsonDocument.of((JsonStructure)context.build())).options(opts).get();
                }
            }
            if (((Boolean)writerConfig.get((RioSetting)BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
                JsonWriterFactory writerFactory = Json.createWriterFactory(Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", true));
                JsonWriter jsonWriter = writerFactory.createWriter(this.writer);
                jsonWriter.write((JsonStructure)jsonld);
            } else {
                JsonWriter jsonWriter = Json.createWriter((Writer)this.writer);
                jsonWriter.write((JsonStructure)jsonld);
            }
            this.writer.flush();
        }
        catch (IOException | JsonLdError e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
    }

    private JSONLDMode mapJsonLdMode(Object jsonldMode) {
        if (jsonldMode instanceof JSONLDMode) {
            return (JSONLDMode)((Object)jsonldMode);
        }
        if (jsonldMode instanceof org.eclipse.rdf4j.rio.helpers.JSONLDMode) {
            return JSONLDMode.valueOf(jsonldMode.toString());
        }
        throw new IllegalArgumentException("Unknown JSONLDMode: " + jsonldMode);
    }

    private static RdfNQuad toRdfNQuad(Statement statement) {
        return new RdfNQuadAdapter(statement);
    }

    private static RdfTriple toRdfTriple(Statement statement) {
        return new RdfTripleAdapter(statement);
    }

    private static RdfValue toRdfValue(Value node) {
        if (node.isResource()) {
            return JSONLDWriter.toRdfResource((Resource)node);
        }
        if (node.isLiteral()) {
            return new RdfLiteralAdapter(node);
        }
        throw new IllegalArgumentException("Unknown type of node: " + node);
    }

    private static RdfResource toRdfResource(Resource node) {
        return new RdfResourceAdapter(node);
    }

    private Value toRdf4jValue(RdfValue node) {
        if (node instanceof RdfResourceAdapter) {
            return ((RdfResourceAdapter)node).node;
        }
        if (node instanceof RdfLiteralAdapter) {
            return ((RdfLiteralAdapter)node).node;
        }
        if (node.isIRI()) {
            return vf.createIRI(node.getValue());
        }
        if (node.isBlankNode()) {
            return vf.createBNode(node.getValue());
        }
        if (node.isLiteral()) {
            RdfLiteral literal = node.asLiteral();
            if (literal.getLanguage().isPresent()) {
                return vf.createLiteral(node.getValue(), (String)literal.getLanguage().get());
            }
            if (literal.getDatatype() != null) {
                return vf.createLiteral(node.getValue(), vf.createIRI(literal.getDatatype()));
            }
            return vf.createLiteral(node.getValue());
        }
        throw new IllegalArgumentException("Unknown type of node: " + node);
    }

    private IRI toRdf4jIri(RdfResource node) {
        if (node.isIRI()) {
            if (node instanceof RdfResourceAdapter) {
                return (IRI)((RdfResourceAdapter)node).node;
            }
            return vf.createIRI(node.getValue());
        }
        throw new IllegalArgumentException("Unknown type of node: " + node);
    }

    private Resource toRdf4jResource(RdfResource node) {
        if (node instanceof RdfResourceAdapter) {
            return ((RdfResourceAdapter)node).node;
        }
        if (node.isIRI()) {
            return vf.createIRI(node.getValue());
        }
        if (node.isBlankNode()) {
            return vf.createBNode(node.getValue().substring(2));
        }
        throw new IllegalArgumentException("Unknown type of node: " + node);
    }

    public void consumeStatement(Statement st) throws RDFHandlerException {
        this.statementCollector.handleStatement(st);
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add((RioSetting<?>)BasicWriterSettings.PRETTY_PRINT);
        result.add((RioSetting<?>)BasicWriterSettings.BASE_DIRECTIVE);
        result.add((RioSetting<?>)JSONLDSettings.COMPACT_ARRAYS);
        result.add(JSONLDSettings.JSONLD_MODE);
        result.add((RioSetting<?>)JSONLDSettings.USE_RDF_TYPE);
        result.add((RioSetting<?>)JSONLDSettings.USE_NATIVE_TYPES);
        result.add((RioSetting<?>)JSONLDSettings.PRODUCE_GENERALIZED_RDF);
        result.add((RioSetting<?>)JSONLDSettings.EXCEPTION_ON_WARNING);
        result.add(JSONLDSettings.FRAME);
        result.add((RioSetting<?>)org.eclipse.rdf4j.rio.helpers.JSONLDSettings.COMPACT_ARRAYS);
        result.add(org.eclipse.rdf4j.rio.helpers.JSONLDSettings.JSONLD_MODE);
        result.add((RioSetting<?>)org.eclipse.rdf4j.rio.helpers.JSONLDSettings.USE_RDF_TYPE);
        result.add((RioSetting<?>)org.eclipse.rdf4j.rio.helpers.JSONLDSettings.USE_NATIVE_TYPES);
        result.add((RioSetting<?>)org.eclipse.rdf4j.rio.helpers.JSONLDSettings.PRODUCE_GENERALIZED_RDF);
        result.add((RioSetting<?>)org.eclipse.rdf4j.rio.helpers.JSONLDSettings.EXCEPTION_ON_WARNING);
        result.add(org.eclipse.rdf4j.rio.helpers.JSONLDSettings.FRAME);
        return result;
    }

    private static void addPrefixes(Map<String, Object> ctx, Set<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            ctx.put(ns.getPrefix().isEmpty() ? "@vocab" : ns.getPrefix(), ns.getName());
        }
    }

    private static class RdfNQuadAdapter
    implements RdfNQuad {
        private final Statement statement;

        public RdfNQuadAdapter(Statement statement) {
            this.statement = statement;
        }

        public Optional<RdfResource> getGraphName() {
            if (this.statement.getContext() != null) {
                return Optional.of(JSONLDWriter.toRdfResource(this.statement.getContext()));
            }
            return Optional.empty();
        }

        public RdfResource getSubject() {
            return JSONLDWriter.toRdfResource(this.statement.getSubject());
        }

        public RdfResource getPredicate() {
            return JSONLDWriter.toRdfResource((Resource)this.statement.getPredicate());
        }

        public RdfValue getObject() {
            return JSONLDWriter.toRdfValue(this.statement.getObject());
        }
    }

    private static class RdfTripleAdapter
    implements RdfTriple {
        private final Statement statement;

        public RdfTripleAdapter(Statement statement) {
            this.statement = statement;
        }

        public RdfResource getSubject() {
            return JSONLDWriter.toRdfResource(this.statement.getSubject());
        }

        public RdfResource getPredicate() {
            return JSONLDWriter.toRdfResource((Resource)this.statement.getPredicate());
        }

        public RdfValue getObject() {
            return JSONLDWriter.toRdfValue(this.statement.getObject());
        }
    }

    private static class RdfResourceAdapter
    implements RdfResource {
        private final Resource node;

        public RdfResourceAdapter(Resource node) {
            this.node = node;
        }

        public String getValue() {
            if (this.node.isBNode()) {
                return "_:" + ((BNode)this.node).getID();
            }
            return this.node.stringValue();
        }

        public boolean isIRI() {
            return this.node.isIRI();
        }

        public boolean isBlankNode() {
            return this.node.isBNode();
        }

        public int hashCode() {
            return Objects.hash(this.getValue());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof RdfResource) {
                RdfResource other = (RdfResource)obj;
                return Objects.equals(this.getValue(), other.getValue());
            }
            return false;
        }

        public String toString() {
            return Objects.toString(this.getValue());
        }
    }

    private static class RdfLiteralAdapter
    implements RdfLiteral {
        private final Value node;

        public RdfLiteralAdapter(Value node) {
            this.node = node;
        }

        public String getValue() {
            return this.node.stringValue();
        }

        public boolean isLiteral() {
            return true;
        }

        public String getDatatype() {
            return ((Literal)this.node).getDatatype().stringValue();
        }

        public Optional<String> getLanguage() {
            return ((Literal)this.node).getLanguage();
        }

        public int hashCode() {
            return Objects.hash(this.getDatatype(), this.getLanguage().orElse(null), this.getValue());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof RdfLiteral) {
                RdfLiteral other = (RdfLiteral)obj;
                return Objects.equals(this.getDatatype(), other.getDatatype()) && Objects.equals(this.getLanguage().orElse(null), other.getLanguage().orElse("")) && Objects.equals(this.getValue(), other.getValue());
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getValue());
            if (this.getLanguage().isPresent()) {
                builder.append('@');
                builder.append(this.getLanguage().get());
            } else if (this.getDatatype() != null) {
                builder.append("^^");
                builder.append(this.getDatatype());
            }
            return builder.toString();
        }
    }
}

