/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerBigDecimal;
import org.mapdb.serializer.SerializerBigInteger;
import org.mapdb.serializer.SerializerBoolean;
import org.mapdb.serializer.SerializerByte;
import org.mapdb.serializer.SerializerByteArray;
import org.mapdb.serializer.SerializerByteArrayDelta;
import org.mapdb.serializer.SerializerByteArrayDelta2;
import org.mapdb.serializer.SerializerByteArrayNoSize;
import org.mapdb.serializer.SerializerChar;
import org.mapdb.serializer.SerializerCharArray;
import org.mapdb.serializer.SerializerClass;
import org.mapdb.serializer.SerializerDate;
import org.mapdb.serializer.SerializerDouble;
import org.mapdb.serializer.SerializerDoubleArray;
import org.mapdb.serializer.SerializerElsa;
import org.mapdb.serializer.SerializerFloat;
import org.mapdb.serializer.SerializerFloatArray;
import org.mapdb.serializer.SerializerIllegalAccess;
import org.mapdb.serializer.SerializerIntArray;
import org.mapdb.serializer.SerializerInteger;
import org.mapdb.serializer.SerializerIntegerDelta;
import org.mapdb.serializer.SerializerIntegerPacked;
import org.mapdb.serializer.SerializerJava;
import org.mapdb.serializer.SerializerLong;
import org.mapdb.serializer.SerializerLongArray;
import org.mapdb.serializer.SerializerLongDelta;
import org.mapdb.serializer.SerializerLongPacked;
import org.mapdb.serializer.SerializerRecid;
import org.mapdb.serializer.SerializerRecidArray;
import org.mapdb.serializer.SerializerShort;
import org.mapdb.serializer.SerializerShortArray;
import org.mapdb.serializer.SerializerString;
import org.mapdb.serializer.SerializerStringAscii;
import org.mapdb.serializer.SerializerStringDelta;
import org.mapdb.serializer.SerializerStringDelta2;
import org.mapdb.serializer.SerializerStringIntern;
import org.mapdb.serializer.SerializerStringNoSize;
import org.mapdb.serializer.SerializerStringOrigHash;
import org.mapdb.serializer.SerializerUUID;

public interface Serializer<A>
extends Comparator<A> {
    public static final GroupSerializer<Character> CHAR = new SerializerChar();
    public static final GroupSerializer<String> STRING_ORIGHASH = new SerializerStringOrigHash();
    public static final GroupSerializer<String> STRING = new SerializerString();
    public static final GroupSerializer<String> STRING_DELTA = new SerializerStringDelta();
    public static final GroupSerializer<String> STRING_DELTA2 = new SerializerStringDelta2();
    public static final GroupSerializer<String> STRING_INTERN = new SerializerStringIntern();
    public static final GroupSerializer<String> STRING_ASCII = new SerializerStringAscii();
    public static final Serializer<String> STRING_NOSIZE = new SerializerStringNoSize();
    public static final GroupSerializer<Long> LONG = new SerializerLong();
    public static final GroupSerializer<Long> LONG_PACKED = new SerializerLongPacked();
    public static final GroupSerializer<Long> LONG_DELTA = new SerializerLongDelta();
    public static final GroupSerializer<Integer> INTEGER = new SerializerInteger();
    public static final GroupSerializer<Integer> INTEGER_PACKED = new SerializerIntegerPacked();
    public static final GroupSerializer<Integer> INTEGER_DELTA = new SerializerIntegerDelta();
    public static final GroupSerializer<Boolean> BOOLEAN = new SerializerBoolean();
    public static final GroupSerializer<Long> RECID = new SerializerRecid();
    public static final GroupSerializer<long[]> RECID_ARRAY = new SerializerRecidArray();
    public static final GroupSerializer<Object> ILLEGAL_ACCESS = new SerializerIllegalAccess();
    public static final GroupSerializer<byte[]> BYTE_ARRAY = new SerializerByteArray();
    public static final GroupSerializer<byte[]> BYTE_ARRAY_DELTA = new SerializerByteArrayDelta();
    public static final GroupSerializer<byte[]> BYTE_ARRAY_DELTA2 = new SerializerByteArrayDelta2();
    public static final Serializer<byte[]> BYTE_ARRAY_NOSIZE = new SerializerByteArrayNoSize();
    public static final GroupSerializer<char[]> CHAR_ARRAY = new SerializerCharArray();
    public static final GroupSerializer<int[]> INT_ARRAY = new SerializerIntArray();
    public static final GroupSerializer<long[]> LONG_ARRAY = new SerializerLongArray();
    public static final GroupSerializer<double[]> DOUBLE_ARRAY = new SerializerDoubleArray();
    public static final GroupSerializer JAVA = new SerializerJava();
    public static final GroupSerializer ELSA = new SerializerElsa();
    public static final GroupSerializer<UUID> UUID = new SerializerUUID();
    public static final GroupSerializer<Byte> BYTE = new SerializerByte();
    public static final GroupSerializer<Float> FLOAT = new SerializerFloat();
    public static final GroupSerializer<Double> DOUBLE = new SerializerDouble();
    public static final GroupSerializer<Short> SHORT = new SerializerShort();
    public static final GroupSerializer<short[]> SHORT_ARRAY = new SerializerShortArray();
    public static final GroupSerializer<float[]> FLOAT_ARRAY = new SerializerFloatArray();
    public static final GroupSerializer<BigInteger> BIG_INTEGER = new SerializerBigInteger();
    public static final GroupSerializer<BigDecimal> BIG_DECIMAL = new SerializerBigDecimal();
    public static final GroupSerializer<Class<?>> CLASS = new SerializerClass();
    public static final GroupSerializer<Date> DATE = new SerializerDate();

    public void serialize(@NotNull DataOutput2 var1, @NotNull A var2) throws IOException;

    public A deserialize(@NotNull DataInput2 var1, int var2) throws IOException;

    default public int fixedSize() {
        return -1;
    }

    default public boolean isTrusted() {
        return false;
    }

    @Override
    default public int compare(A first, A second) {
        return ((Comparable)first).compareTo(second);
    }

    default public boolean equals(A first, A second) {
        return Objects.equals(first, second);
    }

    default public int hashCode(@NotNull A o, int seed) {
        return DataIO.intHash(o.hashCode() + seed);
    }

    default public boolean needsAvailableSizeHint() {
        return false;
    }

    default public A deserializeFromLong(long input, int available) throws IOException {
        if (available < 0 || available > 8) {
            throw new AssertionError();
        }
        byte[] b = new byte[available];
        DataIO.putLong(b, 0, input, available);
        return this.deserialize(new DataInput2.ByteArray(b), available);
    }

    default public A clone(A value) throws IOException {
        DataOutput2 out = new DataOutput2();
        this.serialize(out, value);
        DataInput2.ByteArray in2 = new DataInput2.ByteArray(out.copyBytes());
        return this.deserialize(in2, out.pos);
    }
}

