/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public final class SingleByteArrayVol
extends Volume {
    protected static final VolumeFactory FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            if (initSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("startSize larger 2GB");
            }
            return new SingleByteArrayVol((int)initSize);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return false;
        }

        @Override
        public boolean handlesReadonly() {
            return false;
        }
    };
    protected final byte[] data;

    public SingleByteArrayVol(int size) {
        this(new byte[size]);
    }

    public SingleByteArrayVol(byte[] data) {
        this.data = data;
    }

    @Override
    public void ensureAvailable(long offset) {
        if (offset > (long)this.data.length) {
            throw new DBException.VolumeMaxSizeExceeded(this.data.length, offset);
        }
    }

    @Override
    public void truncate(long size) {
    }

    @Override
    public void putLong(long offset, long v) {
        DataIO.putLong(this.data, (int)offset, v);
    }

    @Override
    public void putInt(long offset, int value) {
        int pos = (int)offset;
        this.data[pos++] = (byte)(0xFF & value >> 24);
        this.data[pos++] = (byte)(0xFF & value >> 16);
        this.data[pos++] = (byte)(0xFF & value >> 8);
        this.data[pos++] = (byte)(0xFF & value);
    }

    @Override
    public void putByte(long offset, byte value) {
        this.data[(int)offset] = value;
    }

    @Override
    public void putData(long offset, byte[] src, int srcPos, int srcSize) {
        System.arraycopy(src, srcPos, this.data, (int)offset, srcSize);
    }

    @Override
    public void putData(long offset, ByteBuffer buf) {
        buf.get(this.data, (int)offset, buf.remaining());
    }

    @Override
    public void copyTo(long inputOffset, Volume target, long targetOffset, long size) {
        target.putData(targetOffset, this.data, (int)inputOffset, (int)size);
    }

    @Override
    public void clear(long startOffset, long endOffset) {
        int start = (int)startOffset;
        int end = (int)endOffset;
        for (int pos = start; pos < end; pos += CLEAR.length) {
            System.arraycopy(CLEAR, 0, this.data, pos, Math.min(CLEAR.length, end - pos));
        }
    }

    @Override
    public long getLong(long offset) {
        return DataIO.getLong(this.data, (int)offset);
    }

    @Override
    public int getInt(long offset) {
        int pos;
        int end = pos + 4;
        int ret = 0;
        for (pos = (int)offset; pos < end; ++pos) {
            ret = ret << 8 | this.data[pos] & 0xFF;
        }
        return ret;
    }

    @Override
    public byte getByte(long offset) {
        return this.data[(int)offset];
    }

    @Override
    public DataInput2 getDataInput(long offset, int size) {
        return new DataInput2.ByteArray(this.data, (int)offset);
    }

    @Override
    public void getData(long offset, byte[] bytes, int bytesPos, int length) {
        System.arraycopy(this.data, (int)offset, bytes, bytesPos, length);
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public int sliceSize() {
        return -1;
    }

    @Override
    public boolean isSliced() {
        return false;
    }

    @Override
    public long length() {
        return this.data.length;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean getFileLocked() {
        return false;
    }
}

