/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.EmptyStatementPattern;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.federated.evaluation.join.ControlledWorkerBindJoinBase;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelBindLeftJoinTask;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelEmptyBindLeftJoinTask;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class ControlledWorkerBindLeftJoin
extends ControlledWorkerBindJoinBase {
    public ControlledWorkerBindLeftJoin(ControlledWorkerScheduler<BindingSet> scheduler, FederationEvalStrategy strategy, CloseableIteration<BindingSet> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(scheduler, strategy, leftIter, rightArg, bindings, queryInfo);
    }

    @Override
    protected ControlledWorkerBindJoinBase.TaskCreator determineTaskCreator(TupleExpr expr, BindingSet bs) {
        ControlledWorkerBindJoinBase.TaskCreator taskCreator;
        if (expr instanceof StatementTupleExpr) {
            StatementTupleExpr stmt = (StatementTupleExpr)expr;
            taskCreator = new LeftBoundJoinTaskCreator(this.strategy, stmt);
        } else if (expr instanceof EmptyStatementPattern) {
            EmptyStatementPattern stmt = (EmptyStatementPattern)expr;
            taskCreator = new EmptyLeftBoundJoinTaskCreator(this.strategy, stmt);
        } else {
            throw new RuntimeException("Expr is of unexpected type: " + expr.getClass().getCanonicalName() + ". Please report this problem.");
        }
        return taskCreator;
    }

    protected static class EmptyLeftBoundJoinTaskCreator
    implements ControlledWorkerBindJoinBase.TaskCreator {
        protected final FederationEvalStrategy _strategy;
        protected final EmptyStatementPattern _expr;

        public EmptyLeftBoundJoinTaskCreator(FederationEvalStrategy strategy, EmptyStatementPattern expr) {
            this._strategy = strategy;
            this._expr = expr;
        }

        @Override
        public ParallelTask<BindingSet> getTask(ParallelExecutor<BindingSet> control, List<BindingSet> bindings) {
            return new ParallelEmptyBindLeftJoinTask(control, this._strategy, this._expr, bindings);
        }
    }

    protected static class LeftBoundJoinTaskCreator
    implements ControlledWorkerBindJoinBase.TaskCreator {
        protected final FederationEvalStrategy _strategy;
        protected final StatementTupleExpr _expr;

        public LeftBoundJoinTaskCreator(FederationEvalStrategy strategy, StatementTupleExpr expr) {
            this._strategy = strategy;
            this._expr = expr;
        }

        @Override
        public ParallelTask<BindingSet> getTask(ParallelExecutor<BindingSet> control, List<BindingSet> bindings) {
            return new ParallelBindLeftJoinTask(control, this._strategy, this._expr, bindings);
        }
    }
}

