/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;

public class LexicalValueComparator
implements Serializable,
Comparator<Value> {
    private static final long serialVersionUID = -7055973992568220217L;

    @Override
    public int compare(Value o1, Value o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean b1 = o1.isBNode();
        boolean b2 = o2.isBNode();
        if (b1 && b2) {
            return this.compareBNodes((BNode)o1, (BNode)o2);
        }
        if (b1) {
            return -1;
        }
        if (b2) {
            return 1;
        }
        boolean u1 = o1.isIRI();
        boolean u2 = o2.isIRI();
        if (u1 && u2) {
            return this.compareURIs((IRI)o1, (IRI)o2);
        }
        if (u1) {
            return -1;
        }
        if (u2) {
            return 1;
        }
        boolean l1 = o1.isLiteral();
        boolean l2 = o2.isLiteral();
        if (l1 && l2) {
            return this.compareLiterals((Literal)o1, (Literal)o2);
        }
        if (l1) {
            return -1;
        }
        if (l2) {
            return 1;
        }
        return this.compareTriples((Triple)o1, (Triple)o2);
    }

    private int compareBNodes(BNode leftBNode, BNode rightBNode) {
        return leftBNode.getID().compareTo(rightBNode.getID());
    }

    private int compareURIs(IRI leftURI, IRI rightURI) {
        return leftURI.toString().compareTo(rightURI.toString());
    }

    private int compareLiterals(Literal leftLit, Literal rightLit) {
        int result = 0;
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null) {
            if (rightDatatype != null) {
                CoreDatatype leftXmlDatatype = leftLit.getCoreDatatype();
                CoreDatatype rightXmlDatatype = rightLit.getCoreDatatype();
                result = leftXmlDatatype.isXSDDatatype() && rightXmlDatatype.isXSDDatatype() ? this.compareDatatypes((CoreDatatype.XSD)leftXmlDatatype, (CoreDatatype.XSD)rightXmlDatatype) : this.compareDatatypes(leftDatatype, rightDatatype);
            } else {
                result = 1;
            }
        } else if (rightDatatype != null) {
            result = -1;
        }
        if (result == 0) {
            Optional leftLanguage = leftLit.getLanguage();
            Optional rightLanguage = rightLit.getLanguage();
            if (leftLanguage.isPresent()) {
                result = rightLanguage.isPresent() ? ((String)leftLanguage.get()).compareTo((String)rightLanguage.get()) : 1;
            } else if (rightLanguage.isPresent()) {
                result = -1;
            }
        }
        if (result == 0) {
            result = leftLit.getLabel().compareTo(rightLit.getLabel());
        }
        return result;
    }

    private int compareDatatypes(IRI leftDatatype, IRI rightDatatype) {
        if (XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            if (XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            return 1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(leftDatatype)) {
            if (XMLDatatypeUtil.isCalendarDatatype(rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(rightDatatype)) {
            return 1;
        }
        return this.compareURIs(leftDatatype, rightDatatype);
    }

    private int compareDatatypes(CoreDatatype.XSD leftDatatype, CoreDatatype.XSD rightDatatype) {
        if (leftDatatype.isNumericDatatype()) {
            if (rightDatatype.isNumericDatatype()) {
                return this.compareURIs(leftDatatype.getIri(), rightDatatype.getIri());
            }
            return -1;
        }
        if (rightDatatype.isNumericDatatype()) {
            return 1;
        }
        if (leftDatatype.isCalendarDatatype()) {
            if (rightDatatype.isCalendarDatatype()) {
                return this.compareURIs(leftDatatype.getIri(), rightDatatype.getIri());
            }
            return -1;
        }
        if (rightDatatype.isCalendarDatatype()) {
            return 1;
        }
        return this.compareURIs(leftDatatype.getIri(), rightDatatype.getIri());
    }

    private int compareTriples(Triple leftTriple, Triple rightTriple) {
        int c = this.compare((Value)leftTriple.getSubject(), (Value)rightTriple.getSubject());
        if (c == 0 && (c = this.compare((Value)leftTriple.getPredicate(), (Value)rightTriple.getPredicate())) == 0) {
            c = this.compare(leftTriple.getObject(), rightTriple.getObject());
        }
        return c;
    }
}

