/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.zip.CRC32;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.AbstractValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.ConcurrentCache;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.ValueStoreRevision;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbBNode;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbIRI;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbLiteral;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbResource;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBEnvInfo;
import org.lwjgl.util.lmdb.MDBStat;
import org.lwjgl.util.lmdb.MDBVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValueStore
extends AbstractValueFactory {
    private static final Logger logger = LoggerFactory.getLogger(ValueStore.class);
    private static final byte URI_VALUE = 0;
    private static final byte LITERAL_VALUE = 1;
    private static final byte BNODE_VALUE = 2;
    private static final byte NAMESPACE_VALUE = 3;
    private static final byte ID_KEY = 4;
    private static final byte HASH_KEY = 5;
    private static final byte HASHID_KEY = 6;
    private static final int MAX_KEY_SIZE = 16;
    private static final VarHandle PREVIOUS_NAMESPACE_HANDLE;
    private final File dir;
    private final StampedLock revisionLock = new StampedLock();
    private final LmdbValue[] valueCache;
    private final long[] valueCacheId;
    private final int valueCacheMask;
    private final ConcurrentCache<LmdbValue, Long> valueIDCache;
    private final ConcurrentCache<Long, String> namespaceCache;
    private final ConcurrentCache<String, Long> namespaceIDCache;
    private long env;
    private int pageSize;
    private long mapSize;
    private int dbi;
    private int unusedDbi;
    private int freeDbi;
    private int refCountsDbi;
    private long writeTxn;
    private final boolean forceSync;
    private final boolean autoGrow;
    private boolean invalidateRevisionOnCommit = false;
    private final ReadWriteLock txnLock = new ReentrantReadWriteLock();
    private volatile ValueStoreRevision.Default revision;
    private volatile ValueStoreRevision.Lazy lazyRevision;
    private long nextId = 1L;
    private boolean freeIdsAvailable;
    private volatile long nextValueEvictionTime = 0L;
    final Set<Long> unusedRevisionIds = new HashSet<Long>();
    private final ConcurrentCleaner cleaner = new ConcurrentCleaner();
    private final Set<ReadTxn> readTransactions = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final ThreadLocal<ReadTxn> threadLocalReadTxn = ThreadLocal.withInitial(() -> {
        ReadTxn readTxn = new ReadTxn(this.readTransactions);
        readTxn.registerIfNeeded();
        readTxn.cleaner(this.cleaner);
        return readTxn;
    });
    private Object[] previousNamespaceEntry;
    private final long valueEvictionInterval;
    long prevId;
    long prevPrevId;
    private final ConcurrentHashMap<Value, Long> commonVocabulary = new ConcurrentHashMap();

    ValueStore(File dir, LmdbStoreConfig config) throws IOException {
        this.dir = dir;
        this.forceSync = config.getForceSync();
        this.autoGrow = config.getAutoGrow();
        this.mapSize = config.getValueDBSize();
        this.valueEvictionInterval = config.getValueEvictionInterval();
        this.open();
        int cacheSize = ValueStore.nextPowerOfTwo(config.getValueCacheSize());
        this.valueCache = new LmdbValue[cacheSize];
        this.valueCacheId = new long[cacheSize];
        this.valueCacheMask = cacheSize - 1;
        this.valueIDCache = new ConcurrentCache(config.getValueIDCacheSize());
        this.namespaceCache = new ConcurrentCache(config.getNamespaceCacheSize());
        this.namespaceIDCache = new ConcurrentCache(config.getNamespaceIDCacheSize());
        this.setNewRevision();
        this.readTransaction(this.env, (stack, txn) -> {
            long cursor = 0L;
            PointerBuffer pp = stack.mallocPointer(1);
            for (int lookupDbi : new int[]{this.dbi, this.freeDbi}) {
                try {
                    LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)lookupDbi, (PointerBuffer)pp));
                    cursor = pp.get(0);
                    MDBVal keyData = MDBVal.calloc((MemoryStack)stack);
                    keyData.mv_data(stack.bytes(new byte[]{4, -1}));
                    MDBVal valueData = MDBVal.calloc((MemoryStack)stack);
                    int rc = LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)17);
                    rc = rc != 0 ? LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)6) : LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)12);
                    if (rc != 0 || keyData.mv_data().get(0) != 4) continue;
                    this.nextId = Math.max(this.nextId, (this.data2id(keyData.mv_data()) >> 2) + 1L);
                }
                finally {
                    if (cursor != 0L) {
                        LMDB.mdb_cursor_close((long)cursor);
                    }
                }
            }
            return null;
        });
        this.startTransaction(true);
        this.commit();
    }

    private void logValues() throws IOException {
        this.readTransaction(this.env, (stack, txn) -> {
            long cursor = 0L;
            PointerBuffer pp = stack.mallocPointer(1);
            try {
                LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)this.dbi, (PointerBuffer)pp));
                cursor = pp.get(0);
                MDBVal keyData = MDBVal.calloc((MemoryStack)stack);
                keyData.mv_data(stack.bytes(new byte[]{4}));
                MDBVal valueData = MDBVal.calloc((MemoryStack)stack);
                int rc = LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)17);
                while (rc == 0 && keyData.mv_data().get(0) == 4) {
                    long id = this.data2id(keyData.mv_data());
                    try {
                        logger.debug("id {} has value {}", (Object)id, (Object)this.getValue(id));
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug("id {} has namespace value {}", (Object)id, (Object)this.getNamespace(id));
                    }
                    rc = LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)8);
                }
            }
            finally {
                if (cursor != 0L) {
                    LMDB.mdb_cursor_close((long)cursor);
                }
            }
            return null;
        });
    }

    private void open() throws IOException {
        this.dir.mkdirs();
        try (MemoryStack stack2 = MemoryStack.stackPush();){
            PointerBuffer pp = stack2.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_env_create((PointerBuffer)pp));
            this.env = pp.get(0);
        }
        LmdbUtil.E(LMDB.mdb_env_set_maxdbs((long)this.env, (int)6));
        LmdbUtil.E(LMDB.mdb_env_set_maxreaders((long)this.env, (int)256));
        int flags = 0x200000;
        if (!this.forceSync) {
            flags |= 0x50000;
        }
        LmdbUtil.E(LMDB.mdb_env_open((long)this.env, (CharSequence)this.dir.getAbsolutePath(), (int)flags, (int)436));
        this.dbi = LmdbUtil.openDatabase(this.env, null, 262144, null);
        this.readTransaction(this.env, (stack, txn) -> {
            MDBStat stat = MDBStat.malloc((MemoryStack)stack);
            LMDB.mdb_stat((long)txn, (int)this.dbi, (MDBStat)stat);
            boolean isEmpty = stat.ms_entries() == 0L;
            this.pageSize = stat.ms_psize();
            long configMapSize = this.mapSize / (long)this.pageSize * (long)this.pageSize;
            if (configMapSize < 6L * (long)this.pageSize) {
                logger.debug("configMapSize needs to be at least 6 pages");
                configMapSize = 6L * (long)this.pageSize;
            }
            if (isEmpty) {
                LMDB.mdb_env_set_mapsize((long)this.env, (long)configMapSize);
            }
            MDBEnvInfo info = MDBEnvInfo.malloc((MemoryStack)stack);
            LMDB.mdb_env_info((long)this.env, (MDBEnvInfo)info);
            this.mapSize = info.me_mapsize();
            if (this.mapSize < configMapSize) {
                LMDB.mdb_env_set_mapsize((long)this.env, (long)configMapSize);
                this.mapSize = configMapSize;
            }
            return null;
        });
        this.unusedDbi = LmdbUtil.openDatabase(this.env, "unused_ids", 262144, null);
        this.freeDbi = LmdbUtil.openDatabase(this.env, "free_ids", 262144, null);
        this.refCountsDbi = LmdbUtil.openDatabase(this.env, "ref_counts", 262144, null);
        this.readTransaction(this.env, (stack, txn) -> {
            MDBStat stat = MDBStat.malloc((MemoryStack)stack);
            LMDB.mdb_stat((long)txn, (int)this.freeDbi, (MDBStat)stat);
            this.freeIdsAvailable = stat.ms_entries() > 0L;
            LMDB.mdb_stat((long)txn, (int)this.unusedDbi, (MDBStat)stat);
            if (stat.ms_entries() > 0L) {
                this.resizeMap(txn, stat.ms_entries() * 10L);
                this.writeTransaction((stack2, txn2) -> {
                    this.freeUnusedIdsAndValues(stack2, txn2, null);
                    return null;
                });
            }
            return null;
        });
    }

    private long nextId(byte type) throws IOException {
        Long reusedId;
        if (this.freeIdsAvailable && (reusedId = this.writeTransaction((stack, txn) -> {
            long cursor = 0L;
            try {
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)this.freeDbi, (PointerBuffer)pp));
                cursor = pp.get(0);
                MDBVal keyData = MDBVal.calloc((MemoryStack)stack);
                MDBVal valueData = MDBVal.calloc((MemoryStack)stack);
                if (LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)0) == 0) {
                    long value = this.data2id(keyData.mv_data()) >> 2;
                    LmdbUtil.E(LMDB.mdb_cursor_del((long)cursor, (int)0));
                    Long l = value;
                    return l;
                }
                this.freeIdsAvailable = LMDB.mdb_cursor_get((long)cursor, (MDBVal)keyData, (MDBVal)valueData, (int)8) == 0;
                Long l = null;
                return l;
            }
            finally {
                if (cursor != 0L) {
                    LMDB.mdb_cursor_close((long)cursor);
                }
            }
        })) != null) {
            long result = reusedId;
            result = result << 2 | (long)type;
            return result;
        }
        long result = this.nextId++;
        result = result << 2 | (long)type;
        return result;
    }

    protected ByteBuffer idBuffer(MemoryStack stack) {
        return stack.malloc(10);
    }

    protected ByteBuffer id2data(ByteBuffer bb, long id) {
        bb.put((byte)4);
        Varint.writeUnsigned(bb, id);
        return bb;
    }

    protected long data2id(ByteBuffer bb) {
        bb.get();
        return Varint.readUnsigned(bb);
    }

    private void setNewRevision() {
        this.revision = new ValueStoreRevision.Default(this);
        this.lazyRevision = new ValueStoreRevision.Lazy(this.revision);
    }

    ValueStoreRevision getRevision() {
        return this.revision;
    }

    protected byte[] getData(long id) throws IOException {
        return this.readTransaction(this.env, (stack, txn) -> {
            MDBVal keyData = MDBVal.calloc((MemoryStack)stack);
            keyData.mv_data(this.id2data(this.idBuffer(stack), id).flip());
            MDBVal valueData = MDBVal.calloc((MemoryStack)stack);
            if (LMDB.mdb_get((long)txn, (int)this.dbi, (MDBVal)keyData, (MDBVal)valueData) == 0) {
                byte[] valueBytes = new byte[valueData.mv_data().remaining()];
                valueData.mv_data().get(valueBytes);
                return valueBytes;
            }
            return null;
        });
    }

    LmdbValue cachedValue(long id) {
        int idx = (int)(id & (long)this.valueCacheMask);
        if (this.valueCacheId[idx] != id) {
            return null;
        }
        LmdbValue value = this.valueCache[idx];
        if (value != null && value.getInternalID() == id) {
            return value;
        }
        return null;
    }

    void cacheValue(long id, LmdbValue value) {
        int idx = (int)(id & (long)this.valueCacheMask);
        this.valueCacheId[idx] = id;
        this.valueCache[idx] = value;
    }

    private static int nextPowerOfTwo(int n) {
        if (n <= 1) {
            return 1;
        }
        int highest = Integer.highestOneBit(n - 1) << 1;
        return highest > 0 ? highest : 0x40000000;
    }

    public LmdbValue getLazyValue(long id) throws IOException {
        LmdbValue resultValue = this.cachedValue(id);
        if (resultValue == null) {
            switch ((byte)(id & 3L)) {
                case 0: {
                    resultValue = new LmdbIRI((ValueStoreRevision)this.lazyRevision, id);
                    break;
                }
                case 1: {
                    resultValue = new LmdbLiteral(this.lazyRevision, id);
                    break;
                }
                case 2: {
                    resultValue = new LmdbBNode((ValueStoreRevision)this.lazyRevision, id);
                    break;
                }
                default: {
                    throw new IOException("Unsupported value with type id " + (id & 3L));
                }
            }
            this.cacheValue(id, resultValue);
        }
        return resultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LmdbValue getValue(long id) throws IOException {
        long stamp = this.revisionLock.readLock();
        try {
            byte[] data;
            LmdbValue resultValue = this.cachedValue(id);
            if (resultValue == null && (data = this.getData(id)) != null) {
                resultValue = this.data2value(id, data, null);
                this.cacheValue(id, resultValue);
            }
            LmdbValue lmdbValue = resultValue;
            return lmdbValue;
        }
        finally {
            this.revisionLock.unlockRead(stamp);
        }
    }

    public boolean resolveValue(long id, LmdbValue value) {
        try {
            byte[] data = this.getData(id);
            if (data != null) {
                this.data2value(id, data, value);
                return true;
            }
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeMap(long txn, long requiredSize) throws IOException {
        if (this.autoGrow && LmdbUtil.requiresResize(this.mapSize, this.pageSize, txn, requiredSize)) {
            requiredSize = LmdbUtil.getNewSize(this.pageSize, txn, requiredSize);
            boolean readLocked = false;
            try {
                this.txnLock.readLock().unlock();
                readLocked = true;
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
            this.txnLock.writeLock().lock();
            try {
                boolean txnIsRead;
                boolean activeWriteTxn = this.writeTxn != 0L;
                boolean bl = txnIsRead = txn != this.writeTxn;
                if (txnIsRead) {
                    LMDB.mdb_txn_reset((long)txn);
                }
                if (activeWriteTxn) {
                    this.endTransaction(true);
                }
                long oldMapSize = this.mapSize;
                this.mapSize = LmdbUtil.autoGrowMapSize(this.mapSize, this.pageSize, requiredSize);
                logger.info("Resizing map from {} to {}", (Object)oldMapSize, (Object)this.mapSize);
                LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
                if (activeWriteTxn) {
                    this.startTransaction(false);
                }
                if (txnIsRead) {
                    LmdbUtil.E(LMDB.mdb_txn_renew((long)txn));
                }
            }
            finally {
                this.txnLock.writeLock().unlock();
                if (readLocked) {
                    this.txnLock.readLock().lock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementRefCount(MemoryStack stack, long writeTxn, byte[] data) throws IOException {
        if (data[0] == 1 || data[0] == 0) {
            try {
                stack.push();
                ByteBuffer bb = ByteBuffer.wrap(data);
                int idLength = Varint.firstToLength(bb.get(1));
                MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
                MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
                idVal.mv_data(this.idBuffer(stack).put((byte)4).put(data, 1, idLength).flip());
                long newCount = 1L;
                if (LMDB.mdb_get((long)writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, (MDBVal)dataVal) == 0) {
                    newCount = Varint.readUnsigned(dataVal.mv_data()) + 1L;
                }
                ByteBuffer countBb = stack.malloc(Varint.calcLengthUnsigned(newCount));
                Varint.writeUnsigned(countBb, newCount);
                dataVal.mv_data(countBb.flip());
                LmdbUtil.E(LMDB.mdb_put((long)writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, (MDBVal)dataVal, (int)0));
            }
            finally {
                stack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decrementRefCount(MemoryStack stack, long writeTxn, ByteBuffer idBb) throws IOException {
        try {
            stack.push();
            MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
            idVal.mv_data(idBb);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            if (LMDB.mdb_get((long)writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, (MDBVal)dataVal) == 0) {
                long newCount = Varint.readUnsigned(dataVal.mv_data()) - 1L;
                if (newCount <= 0L) {
                    LmdbUtil.E(LMDB.mdb_del((long)writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, null));
                    boolean bl = true;
                    return bl;
                }
                ByteBuffer countBb = stack.malloc(Varint.calcLengthUnsigned(newCount));
                Varint.writeUnsigned(countBb, newCount);
                dataVal.mv_data(countBb.flip());
                LmdbUtil.E(LMDB.mdb_put((long)writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, (MDBVal)dataVal, (int)0));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    private long findId(byte[] data, boolean create) throws IOException {
        Long id = this.readTransaction(this.env, (stack, txn) -> {
            MDBVal dataVal;
            MDBVal hashVal;
            int hashLength;
            ByteBuffer hashBb;
            int maxHashKeyLength;
            MDBVal idVal;
            block15: {
                if (data.length <= 16) {
                    MDBVal dataVal2 = MDBVal.calloc((MemoryStack)stack);
                    dataVal2.mv_data(stack.bytes(data));
                    MDBVal idVal2 = MDBVal.calloc((MemoryStack)stack);
                    if (LMDB.mdb_get((long)txn, (int)this.dbi, (MDBVal)dataVal2, (MDBVal)idVal2) == 0) {
                        return this.data2id(idVal2.mv_data());
                    }
                    if (!create) {
                        return null;
                    }
                    this.resizeMap(txn, 2L * (long)data.length + 20L);
                    long newId = this.nextId(data[0]);
                    this.writeTransaction((stack2, writeTxn) -> {
                        idVal2.mv_data(this.id2data(this.idBuffer(stack), newId).flip());
                        LmdbUtil.E(LMDB.mdb_put((long)writeTxn, (int)this.dbi, (MDBVal)dataVal2, (MDBVal)idVal2, (int)0));
                        LmdbUtil.E(LMDB.mdb_put((long)writeTxn, (int)this.dbi, (MDBVal)idVal2, (MDBVal)dataVal2, (int)0));
                        this.incrementRefCount(stack2, writeTxn, data);
                        return null;
                    });
                    return newId;
                }
                idVal = MDBVal.calloc((MemoryStack)stack);
                ByteBuffer dataBb = ByteBuffer.wrap(data);
                long dataHash = this.hash(data);
                maxHashKeyLength = 20;
                hashBb = stack.malloc(maxHashKeyLength);
                hashBb.put((byte)5);
                Varint.writeUnsigned(hashBb, dataHash);
                hashLength = hashBb.position();
                hashBb.flip();
                hashVal = MDBVal.calloc((MemoryStack)stack);
                hashVal.mv_data(hashBb);
                dataVal = MDBVal.calloc((MemoryStack)stack);
                if (LMDB.mdb_get((long)txn, (int)this.dbi, (MDBVal)hashVal, (MDBVal)dataVal) == 0) {
                    idVal.mv_data(dataVal.mv_data());
                    if (LMDB.mdb_get((long)txn, (int)this.dbi, (MDBVal)idVal, (MDBVal)dataVal) == 0 && dataVal.mv_data().compareTo(dataBb) == 0) {
                        return this.data2id(idVal.mv_data());
                    }
                } else {
                    if (!create) {
                        return null;
                    }
                    this.resizeMap(txn, 2L * (long)data.length + 20L);
                    long newId = this.nextId(data[0]);
                    this.writeTransaction((stack2, writeTxn) -> {
                        dataVal.mv_size((long)data.length);
                        idVal.mv_data(this.id2data(this.idBuffer(stack), newId).flip());
                        LmdbUtil.E(LMDB.mdb_put((long)txn, (int)this.dbi, (MDBVal)hashVal, (MDBVal)idVal, (int)0));
                        LmdbUtil.E(LMDB.mdb_put((long)writeTxn, (int)this.dbi, (MDBVal)idVal, (MDBVal)dataVal, (int)65536));
                        dataVal.mv_data().put(data);
                        this.incrementRefCount(stack2, writeTxn, data);
                        return null;
                    });
                    return newId;
                }
                hashBb.put(0, (byte)6);
                hashVal.mv_data(hashBb);
                long cursor = 0L;
                try {
                    PointerBuffer pp = stack.mallocPointer(1);
                    LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)this.dbi, (PointerBuffer)pp));
                    cursor = pp.get(0);
                    if (LMDB.mdb_cursor_get((long)cursor, (MDBVal)hashVal, (MDBVal)dataVal, (int)17) != 0) break block15;
                    do {
                        if (this.compareRegion(hashVal.mv_data(), 0, hashBb, 0, hashLength) != 0) {
                            break;
                        }
                        ByteBuffer hashIdBb = hashVal.mv_data();
                        hashIdBb.position(hashLength);
                        idVal.mv_data(hashIdBb);
                        if (LMDB.mdb_get((long)txn, (int)this.dbi, (MDBVal)idVal, (MDBVal)dataVal) != 0 || dataVal.mv_data().compareTo(dataBb) != 0) continue;
                        Long l = this.data2id(hashIdBb);
                        return l;
                    } while (LMDB.mdb_cursor_get((long)cursor, (MDBVal)hashVal, (MDBVal)dataVal, (int)8) == 0);
                }
                finally {
                    if (cursor != 0L) {
                        LMDB.mdb_cursor_close((long)cursor);
                    }
                }
            }
            if (!create) {
                return null;
            }
            this.resizeMap(txn, (long)(9 + maxHashKeyLength) + 2L * (long)data.length);
            long newId = this.nextId(data[0]);
            this.writeTransaction((stack2, writeTxn) -> {
                ByteBuffer idBb = this.id2data(this.idBuffer(stack), newId).flip();
                idVal.mv_data(idBb);
                hashBb.limit(hashBb.capacity());
                hashBb.position(hashLength);
                hashBb.put(idBb);
                idBb.rewind();
                hashBb.flip();
                hashVal.mv_data(hashBb);
                dataVal.mv_data(stack.bytes(new byte[0]));
                LmdbUtil.E(LMDB.mdb_put((long)txn, (int)this.dbi, (MDBVal)hashVal, (MDBVal)dataVal, (int)0));
                dataVal.mv_size((long)data.length);
                LmdbUtil.E(LMDB.mdb_put((long)txn, (int)this.dbi, (MDBVal)idVal, (MDBVal)dataVal, (int)65536));
                dataVal.mv_data().put(data);
                this.incrementRefCount(stack2, writeTxn, data);
                return null;
            });
            return newId;
        });
        return id != null ? id : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T readTransaction(long env, LmdbUtil.Transaction<T> transaction) throws IOException {
        this.txnLock.readLock().lock();
        try {
            if (this.writeTxn != 0L) {
                T t = LmdbUtil.readTransaction(env, this.writeTxn, transaction);
                return t;
            }
            T t = this.threadLocalReadTxn.get().execute(transaction, env);
            return t;
        }
        finally {
            this.txnLock.readLock().unlock();
        }
    }

    <T> T writeTransaction(LmdbUtil.Transaction<T> transaction) throws IOException {
        if (this.writeTxn != 0L) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                T t = transaction.exec(stack, this.writeTxn);
                return t;
            }
        }
        return LmdbUtil.transaction(this.env, transaction);
    }

    int compareRegion(ByteBuffer array1, int startIdx1, ByteBuffer array2, int startIdx2, int length) {
        int result = 0;
        for (int i = 0; result == 0 && i < length; ++i) {
            result = (array1.get(startIdx1 + i) & 0xFF) - (array2.get(startIdx2 + i) & 0xFF);
        }
        return result;
    }

    public long getId(Value value) throws IOException {
        return this.getId(value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId(Value value, boolean create) throws IOException {
        long id;
        LmdbValue lmdbValue;
        boolean isOwnValue = this.isOwnValue(value);
        if (isOwnValue && this.revisionIsCurrent(lmdbValue = (LmdbValue)value) && (id = lmdbValue.getInternalID()) != -1L) {
            return id;
        }
        long stamp = this.revisionLock.readLock();
        try {
            Long cachedID = this.valueIDCache.get(value);
            if (cachedID == null) {
                cachedID = this.commonVocabulary.get(value);
            }
            if (cachedID != null) {
                long id2 = cachedID;
                if (isOwnValue) {
                    ((LmdbValue)value).setInternalID(id2, this.revision);
                }
                long l = id2;
                return l;
            }
            byte[] data = this.value2data(value, create);
            if (data == null && value instanceof Literal) {
                data = this.literal2legacy((Literal)value);
            }
            if (data != null) {
                long id3 = this.findId(data, create);
                if (id3 != -1L) {
                    if (isOwnValue) {
                        ((LmdbValue)value).setInternalID(id3, this.revision);
                        this.valueIDCache.put((LmdbValue)value, id3);
                    } else {
                        LmdbValue nv = this.getLmdbValue(value);
                        nv.setInternalID(id3, this.revision);
                        if (nv.isIRI() && ValueStore.isCommonVocabulary((IRI)((Object)nv))) {
                            this.commonVocabulary.put(value, id3);
                        }
                        this.valueIDCache.put(nv, id3);
                    }
                }
                long l = id3;
                return l;
            }
        }
        finally {
            this.revisionLock.unlockRead(stamp);
        }
        return -1L;
    }

    private static boolean isCommonVocabulary(IRI nv) {
        String string = nv.toString();
        return string.startsWith("http://www.w3.org/") || string.startsWith("http://purl.org/") || string.startsWith("http://publications.europa.eu/resource/authority") || string.startsWith("http://xmlns.com/");
    }

    public void gcIds(Collection<Long> ids, Collection<Long> nextIds) throws IOException {
        if (!this.enableGC()) {
            return;
        }
        if (!ids.isEmpty()) {
            this.readTransaction(this.env, (stack1, txn1) -> {
                Collection finalIds = ids;
                Collection finalNextIds = nextIds;
                this.writeTransaction((stack, writeTxn) -> {
                    MDBVal revIdVal = MDBVal.calloc((MemoryStack)stack);
                    MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
                    MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
                    ByteBuffer revIdBb = stack.malloc(19);
                    Varint.writeUnsigned(revIdBb, this.revision.getRevisionId());
                    int revLength = revIdBb.position();
                    for (Long id : finalIds) {
                        this.resizeMap(writeTxn, 10L * (long)ids.size() * 19L);
                        revIdBb.position(revLength).limit(revIdBb.capacity());
                        revIdVal.mv_data(this.id2data(revIdBb, id).flip());
                        idVal.mv_data(revIdBb.slice().position(revLength));
                        if (LMDB.mdb_get((long)writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, (MDBVal)dataVal) == 0) continue;
                        LmdbUtil.E(LMDB.mdb_put((long)writeTxn, (int)this.unusedDbi, (MDBVal)revIdVal, (MDBVal)dataVal, (int)0));
                    }
                    this.deleteValueToIdMappings(stack, writeTxn, finalIds, finalNextIds);
                    this.invalidateRevisionOnCommit = this.enableGC();
                    if (this.nextValueEvictionTime < 0L) {
                        this.nextValueEvictionTime = System.currentTimeMillis() + this.valueEvictionInterval;
                    }
                    return null;
                });
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteValueToIdMappings(MemoryStack stack, long txn, Collection<Long> ids, Collection<Long> newGcIds) throws IOException {
        int maxHashKeyLength = 20;
        ByteBuffer hashBb = stack.malloc(maxHashKeyLength);
        MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
        ByteBuffer idBb = this.idBuffer(stack);
        MDBVal hashVal = MDBVal.calloc((MemoryStack)stack);
        MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
        MDBVal ignoreVal = MDBVal.calloc((MemoryStack)stack);
        ByteBuffer refIdBb = this.idBuffer(stack);
        long valuesCursor = 0L;
        try {
            for (Long id : ids) {
                int dataLength;
                idVal.mv_data(this.id2data(idBb.clear(), id).flip());
                int a = LMDB.mdb_get((long)this.writeTxn, (int)this.refCountsDbi, (MDBVal)idVal, (MDBVal)ignoreVal);
                int b = LMDB.mdb_get((long)txn, (int)this.dbi, (MDBVal)idVal, (MDBVal)dataVal);
                if (a == 0 || b != 0) continue;
                ByteBuffer dataBuffer = dataVal.mv_data();
                if (dataBuffer.get(0) == 1 || dataBuffer.get(0) == 0) {
                    refIdBb.clear().put((byte)4).put(dataBuffer.slice().position(1).limit(1 + Varint.firstToLength(dataBuffer.get(1)))).flip();
                    if (this.decrementRefCount(stack, txn, refIdBb)) {
                        newGcIds.add(Varint.readUnsigned(refIdBb, 1));
                    }
                }
                if ((dataLength = dataBuffer.remaining()) > 16) {
                    byte[] data = new byte[dataLength];
                    dataBuffer.get(data);
                    long dataHash = this.hash(data);
                    hashBb.clear();
                    hashBb.put((byte)5);
                    Varint.writeUnsigned(hashBb, dataHash);
                    int hashLength = hashBb.position();
                    hashBb.flip();
                    hashVal.mv_data(hashBb);
                    if (LMDB.mdb_del((long)txn, (int)this.dbi, (MDBVal)hashVal, (MDBVal)dataVal) == 0) {
                        hashBb.put(0, (byte)6);
                        hashBb.rewind();
                        hashVal.mv_data(hashBb);
                        if (valuesCursor == 0L) {
                            PointerBuffer pp = stack.mallocPointer(1);
                            LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)this.dbi, (PointerBuffer)pp));
                            valuesCursor = pp.get(0);
                        }
                        if (LMDB.mdb_cursor_get((long)valuesCursor, (MDBVal)hashVal, (MDBVal)dataVal, (int)17) != 0 || this.compareRegion(hashVal.mv_data(), 0, hashBb, 0, hashLength) != 0) continue;
                        ByteBuffer idBuffer2 = hashVal.mv_data();
                        idBuffer2.position(hashLength);
                        idVal.mv_data(idBuffer2);
                        hashVal.mv_data(hashBb);
                        LmdbUtil.E(LMDB.mdb_put((long)txn, (int)this.dbi, (MDBVal)hashVal, (MDBVal)idVal, (int)0));
                        LmdbUtil.E(LMDB.mdb_cursor_del((long)valuesCursor, (int)0));
                        continue;
                    }
                    hashBb.put(0, (byte)6);
                    hashBb.limit(hashLength + idVal.mv_data().remaining());
                    hashBb.position(hashLength);
                    hashBb.put(idVal.mv_data());
                    hashBb.flip();
                    hashVal.mv_data(hashBb);
                    LMDB.mdb_del((long)txn, (int)this.dbi, (MDBVal)hashVal, null);
                    continue;
                }
                dataVal.mv_data(dataBuffer);
                LMDB.mdb_del((long)txn, (int)this.dbi, (MDBVal)dataVal, null);
            }
        }
        finally {
            if (valuesCursor != 0L) {
                LMDB.mdb_cursor_close((long)valuesCursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeUnusedIdsAndValues(MemoryStack stack, long txn, Set<Long> revisionIds) throws IOException {
        MDBVal idVal = MDBVal.calloc((MemoryStack)stack);
        MDBVal revIdVal = MDBVal.calloc((MemoryStack)stack);
        MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
        MDBVal emptyVal = MDBVal.calloc((MemoryStack)stack);
        ByteBuffer revIdBb = stack.malloc(19);
        boolean freeIds = false;
        long unusedIdsCursor = 0L;
        try {
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_cursor_open((long)txn, (int)this.unusedDbi, (PointerBuffer)pp));
            unusedIdsCursor = pp.get(0);
            if (revisionIds == null) {
                revisionIds = Collections.singleton(0L);
            }
            block3: for (Long revisionId : revisionIds) {
                revIdBb.clear();
                Varint.writeUnsigned(revIdBb, revisionId);
                revIdVal.mv_data(revIdBb.flip());
                if (LMDB.mdb_cursor_get((long)unusedIdsCursor, (MDBVal)revIdVal, (MDBVal)dataVal, (int)17) != 0) continue;
                do {
                    ByteBuffer keyBb = revIdVal.mv_data();
                    long revisionOfId = Varint.readUnsigned(keyBb);
                    if (revisionId != 0L && revisionOfId != revisionId) continue block3;
                    idVal.mv_data(keyBb);
                    LmdbUtil.E(LMDB.mdb_put((long)txn, (int)this.freeDbi, (MDBVal)idVal, (MDBVal)emptyVal, (int)0));
                    LmdbUtil.E(LMDB.mdb_del((long)txn, (int)this.dbi, (MDBVal)idVal, null));
                    LmdbUtil.E(LMDB.mdb_cursor_del((long)unusedIdsCursor, (int)0));
                    freeIds = true;
                } while (LMDB.mdb_cursor_get((long)unusedIdsCursor, (MDBVal)revIdVal, (MDBVal)dataVal, (int)8) == 0);
            }
        }
        finally {
            if (unusedIdsCursor != 0L) {
                LMDB.mdb_cursor_close((long)unusedIdsCursor);
            }
        }
        this.freeIdsAvailable |= freeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction(boolean resize) throws IOException {
        block10: {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)pp));
                this.writeTxn = pp.get(0);
                if (this.nextValueEvictionTime < 0L || System.currentTimeMillis() < this.nextValueEvictionTime) break block10;
                Set<Long> set = this.unusedRevisionIds;
                synchronized (set) {
                    MDBStat stat = MDBStat.malloc((MemoryStack)stack);
                    LMDB.mdb_stat((long)this.writeTxn, (int)this.unusedDbi, (MDBStat)stat);
                    if (resize) {
                        this.resizeMap(this.writeTxn, stat.ms_entries() * 10L);
                    }
                    this.freeUnusedIdsAndValues(stack, this.writeTxn, this.unusedRevisionIds);
                    this.unusedRevisionIds.clear();
                }
                this.nextValueEvictionTime = -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTransaction(boolean commit) throws IOException {
        if (this.writeTxn != 0L) {
            if (commit) {
                if (this.invalidateRevisionOnCommit) {
                    long stamp = this.revisionLock.writeLock();
                    try {
                        LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                        long revisionId = this.lazyRevision.getRevisionId();
                        this.cleaner.register(this.lazyRevision, () -> {
                            Set<Long> set = this.unusedRevisionIds;
                            synchronized (set) {
                                this.unusedRevisionIds.add(revisionId);
                            }
                            if (this.nextValueEvictionTime < 0L) {
                                this.nextValueEvictionTime = System.currentTimeMillis() + this.valueEvictionInterval;
                            }
                        });
                        this.setNewRevision();
                        this.clearCaches();
                    }
                    finally {
                        this.revisionLock.unlockWrite(stamp);
                    }
                } else {
                    LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                }
            } else {
                LMDB.mdb_txn_abort((long)this.writeTxn);
            }
            this.writeTxn = 0L;
            this.invalidateRevisionOnCommit = false;
        }
    }

    public void commit() throws IOException {
        this.endTransaction(true);
        this.threadLocalReadTxn.get().close();
    }

    public void rollback() throws IOException {
        this.endTransaction(false);
        this.threadLocalReadTxn.get().close();
    }

    public long storeValue(Value value) throws IOException {
        return this.getId(value, true);
    }

    private long hash(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    public void clear() throws IOException {
        this.close();
        new File(this.dir, "data.mdb").delete();
        new File(this.dir, "lock.mdb").delete();
        this.clearCaches();
        this.open();
        this.setNewRevision();
    }

    protected void clearCaches() {
        Arrays.fill(this.valueCache, null);
        Arrays.fill(this.valueCacheId, 0L);
        this.valueIDCache.clear();
        this.namespaceCache.clear();
        this.namespaceIDCache.clear();
        this.commonVocabulary.clear();
        PREVIOUS_NAMESPACE_HANDLE.setRelease(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeReadTransactions() {
        this.txnLock.writeLock().lock();
        try {
            ReadTxn[] snapshot;
            for (ReadTxn readTxn : snapshot = this.readTransactions.toArray(new ReadTxn[0])) {
                readTxn.close();
            }
            this.threadLocalReadTxn.remove();
        }
        finally {
            this.txnLock.writeLock().unlock();
        }
    }

    public void close() throws IOException {
        if (this.env != 0L) {
            this.closeReadTransactions();
            this.endTransaction(false);
            LMDB.mdb_env_close((long)this.env);
            this.env = 0L;
        }
    }

    private boolean isOwnValue(Value value) {
        return value instanceof LmdbValue && ((LmdbValue)value).getValueStoreRevision().getValueStore() == this;
    }

    private boolean revisionIsCurrent(LmdbValue value) {
        return this.revision.equals(value.getValueStoreRevision());
    }

    private byte[] value2data(Value value, boolean create) throws IOException {
        if (value instanceof IRI) {
            return this.uri2data((IRI)value, create);
        }
        if (value instanceof BNode) {
            return this.bnode2data((BNode)value, create);
        }
        if (value instanceof Literal) {
            return this.literal2data((Literal)value, create);
        }
        throw new IllegalArgumentException("value parameter should be a URI, BNode or Literal");
    }

    private byte[] uri2data(IRI uri, boolean create) throws IOException {
        long nsID = this.getNamespaceID(uri.getNamespace(), create);
        if (nsID == -1L) {
            return null;
        }
        byte[] localNameData = uri.getLocalName().getBytes(StandardCharsets.UTF_8);
        int nsIDLength = Varint.calcLengthUnsigned(nsID);
        byte[] uriData = new byte[1 + nsIDLength + localNameData.length];
        uriData[0] = 0;
        Varint.writeUnsigned(ByteBuffer.wrap(uriData, 1, nsIDLength), nsID);
        ByteArrayUtil.put(localNameData, uriData, 1 + nsIDLength);
        return uriData;
    }

    private byte[] bnode2data(BNode bNode, boolean create) {
        byte[] idData = bNode.getID().getBytes(StandardCharsets.UTF_8);
        byte[] bNodeData = new byte[1 + idData.length];
        bNodeData[0] = 2;
        ByteArrayUtil.put(idData, bNodeData, 1);
        return bNodeData;
    }

    private byte[] literal2data(Literal literal, boolean create) throws IOException {
        return this.literal2data(literal.getLabel(), literal.getLanguage(), literal.getDatatype(), create);
    }

    private byte[] literal2legacy(Literal literal) throws IOException {
        IRI dt = literal.getDatatype();
        if (XSD.STRING.equals(dt) || RDF.LANGSTRING.equals(dt)) {
            return this.literal2data(literal.getLabel(), literal.getLanguage(), null, false);
        }
        return this.literal2data(literal.getLabel(), literal.getLanguage(), dt, false);
    }

    private byte[] literal2data(String label, Optional<String> lang, IRI dt, boolean create) throws IOException {
        long datatypeID = -1L;
        if (dt != null && (datatypeID = this.getId(dt, create)) == -1L) {
            return null;
        }
        byte[] langData = null;
        int langDataLength = 0;
        if (lang.isPresent()) {
            langData = lang.get().getBytes(StandardCharsets.UTF_8);
            langDataLength = langData.length;
        }
        byte[] labelData = label.getBytes(StandardCharsets.UTF_8);
        int datatypeIDLength = Varint.calcLengthUnsigned(datatypeID);
        byte[] literalData = new byte[2 + datatypeIDLength + langDataLength + labelData.length];
        ByteBuffer bb = ByteBuffer.wrap(literalData);
        bb.put((byte)1);
        Varint.writeUnsigned(bb, datatypeID);
        bb.put((byte)langDataLength);
        if (langData != null) {
            bb.put(langData);
        }
        bb.put(labelData);
        return literalData;
    }

    private boolean isNamespaceData(byte[] data) {
        return data[0] == 3;
    }

    private LmdbValue data2value(long id, byte[] data, LmdbValue value) throws IOException {
        switch (data[0]) {
            case 0: {
                return this.data2uri(id, data, (LmdbIRI)value);
            }
            case 2: {
                return this.data2bnode(id, data, (LmdbBNode)value);
            }
            case 1: {
                return this.data2literal(id, data, (LmdbLiteral)value);
            }
        }
        throw new IllegalArgumentException("Invalid type " + data[0] + " for value with id " + id);
    }

    private LmdbIRI data2uri(long id, byte[] data, LmdbIRI value) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.get();
        long nsID = Varint.readUnsignedHeap(bb);
        String namespace = this.getNamespace(nsID);
        String localName = new String(data, bb.position(), bb.remaining(), StandardCharsets.UTF_8);
        if (value == null) {
            return new LmdbIRI(this.revision, namespace, localName, id);
        }
        value.setIRIString(namespace + localName);
        return value;
    }

    private LmdbBNode data2bnode(long id, byte[] data, LmdbBNode value) {
        String nodeID = new String(data, 1, data.length - 1, StandardCharsets.UTF_8);
        if (value == null) {
            return new LmdbBNode(this.revision, nodeID, id);
        }
        value.setID(nodeID);
        return value;
    }

    private LmdbLiteral data2literal(long id, byte[] data, LmdbLiteral value) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.get();
        long datatypeID = Varint.readUnsignedHeap(bb);
        IRI datatype = null;
        if (datatypeID != -1L) {
            datatype = (IRI)((Object)this.getValue(datatypeID));
        }
        String lang = null;
        int langLength = bb.get() & 0xFF;
        if (langLength > 0) {
            lang = new String(data, bb.position(), langLength, StandardCharsets.UTF_8);
        }
        String label = new String(data, bb.position() + langLength, data.length - bb.position() - langLength, StandardCharsets.UTF_8);
        if (value == null) {
            if (lang != null) {
                return new LmdbLiteral((ValueStoreRevision)this.revision, label, lang, id);
            }
            if (datatype != null) {
                return new LmdbLiteral((ValueStoreRevision)this.revision, label, datatype, id);
            }
            return new LmdbLiteral((ValueStoreRevision)this.revision, label, XSD.STRING, id);
        }
        value.setLabel(label);
        if (lang != null) {
            value.setLanguage(lang);
            value.setDatatype(CoreDatatype.RDF.LANGSTRING);
        } else if (datatype != null) {
            value.setDatatype(datatype);
        } else {
            value.setDatatype(CoreDatatype.XSD.STRING);
        }
        return value;
    }

    private String data2namespace(byte[] data) {
        return new String(data, 1, data.length - 1, StandardCharsets.UTF_8);
    }

    private long getNamespaceID(String namespace, boolean create) throws IOException {
        Long cacheID = this.namespaceIDCache.get(namespace);
        if (cacheID != null) {
            return cacheID;
        }
        byte[] namespaceBytes = namespace.getBytes(StandardCharsets.UTF_8);
        byte[] namespaceData = new byte[namespaceBytes.length + 1];
        namespaceData[0] = 3;
        System.arraycopy(namespaceBytes, 0, namespaceData, 1, namespaceBytes.length);
        long id = this.findId(namespaceData, create);
        if (id != -1L) {
            this.namespaceIDCache.put(namespace, id);
        }
        return id;
    }

    private String getNamespace(long id) throws IOException {
        byte[] namespaceData;
        Object[] cached = PREVIOUS_NAMESPACE_HANDLE.getAcquire(this);
        if (cached != null && (Long)cached[0] == id) {
            return (String)cached[1];
        }
        Long cacheID = id;
        String namespace = this.namespaceCache.get(cacheID);
        if (namespace == null && (namespaceData = this.getData(id)) != null) {
            namespace = this.data2namespace(namespaceData);
            this.namespaceCache.put(cacheID, namespace);
        }
        PREVIOUS_NAMESPACE_HANDLE.setRelease(this, new Object[]{cacheID, namespace});
        return namespace;
    }

    @Override
    public LmdbIRI createIRI(String uri) {
        return new LmdbIRI((ValueStoreRevision)this.revision, uri);
    }

    @Override
    public LmdbIRI createIRI(String namespace, String localName) {
        return new LmdbIRI((ValueStoreRevision)this.revision, namespace, localName);
    }

    @Override
    public LmdbBNode createBNode(String nodeID) {
        return new LmdbBNode((ValueStoreRevision)this.revision, nodeID);
    }

    @Override
    public LmdbLiteral createLiteral(String value) {
        return new LmdbLiteral((ValueStoreRevision)this.revision, value, CoreDatatype.XSD.STRING);
    }

    @Override
    public LmdbLiteral createLiteral(String value, String language) {
        return new LmdbLiteral((ValueStoreRevision)this.revision, value, language);
    }

    @Override
    public LmdbLiteral createLiteral(String value, IRI datatype) {
        return new LmdbLiteral((ValueStoreRevision)this.revision, value, datatype);
    }

    public LmdbValue getLmdbValue(Value value) {
        if (value instanceof Resource) {
            return this.getLmdbResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getLmdbLiteral((Literal)value);
        }
        throw new IllegalArgumentException("Unknown value type: " + String.valueOf(value.getClass()));
    }

    public LmdbResource getLmdbResource(Resource resource) {
        if (resource instanceof IRI) {
            return this.getLmdbURI((IRI)resource);
        }
        if (resource instanceof BNode) {
            return this.getLmdbBNode((BNode)resource);
        }
        throw new IllegalArgumentException("Unknown resource type: " + String.valueOf(resource.getClass()));
    }

    public LmdbIRI getLmdbURI(IRI uri) {
        if (this.isOwnValue(uri)) {
            return (LmdbIRI)uri;
        }
        return new LmdbIRI((ValueStoreRevision)this.revision, uri.toString());
    }

    public LmdbBNode getLmdbBNode(BNode bnode) {
        if (this.isOwnValue(bnode)) {
            return (LmdbBNode)bnode;
        }
        return new LmdbBNode((ValueStoreRevision)this.revision, bnode.getID());
    }

    public LmdbLiteral getLmdbLiteral(Literal l) {
        if (this.isOwnValue(l)) {
            return (LmdbLiteral)l;
        }
        if (Literals.isLanguageLiteral(l)) {
            return new LmdbLiteral((ValueStoreRevision)this.revision, l.getLabel(), l.getLanguage().get());
        }
        if (l.getCoreDatatype() != CoreDatatype.NONE) {
            return new LmdbLiteral((ValueStoreRevision)this.revision, l.getLabel(), l.getCoreDatatype());
        }
        LmdbIRI datatype = this.getLmdbURI(l.getDatatype());
        return new LmdbLiteral((ValueStoreRevision)this.revision, l.getLabel(), (IRI)datatype, l.getCoreDatatype());
    }

    private boolean enableGC() {
        return this.valueEvictionInterval > 0L;
    }

    public void forceEvictionOfValues() {
        this.nextValueEvictionTime = 0L;
    }

    static {
        try {
            PREVIOUS_NAMESPACE_HANDLE = MethodHandles.lookup().findVarHandle(ValueStore.class, "previousNamespaceEntry", Object[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class ReadTxn {
        private final State state = new State(-1L);
        private boolean registered;
        private final Set<ReadTxn> readTransactions;
        private Cleaner.Cleanable cleaner;

        public ReadTxn(Set<ReadTxn> readTransactions) {
            this.readTransactions = readTransactions;
        }

        public void cleaner(ConcurrentCleaner cleaner) {
            this.cleaner = cleaner.register(this, this.state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized <T> T execute(LmdbUtil.Transaction<T> transaction, long env) throws IOException {
            try (MemoryStack stack = MemoryStack.stackPush();){
                T t;
                this.ensureTxn(env);
                ++this.state.depth;
                try {
                    t = transaction.exec(stack, this.state.txn);
                    this.releaseTxn();
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseTxn();
                        throw throwable;
                    }
                    catch (Exception e) {
                        try {
                            System.gc();
                            Thread.sleep(1L);
                            System.gc();
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        this.ensureTxn(env);
                        ++this.state.depth;
                        T t2 = transaction.exec(stack, this.state.txn);
                        return t2;
                        finally {
                            this.releaseTxn();
                        }
                    }
                }
                return t;
            }
        }

        private void ensureTxn(long env) throws IOException {
            this.registerIfNeeded();
            if (!this.state.initialized) {
                this.startTxn(env);
                this.state.initialized = true;
                return;
            }
            if (this.state.depth == 0L) {
                try {
                    LmdbUtil.E(LMDB.mdb_txn_renew((long)this.state.txn));
                }
                catch (IOException e) {
                    this.closeInternal();
                    this.startTxn(env);
                    this.state.initialized = true;
                }
            }
        }

        private void startTxn(long env) throws IOException {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_txn_begin((long)env, (long)0L, (int)131072, (PointerBuffer)pp));
                this.state.txn = pp.get(0);
            }
        }

        private void releaseTxn() {
            if (this.state.depth == 0L) {
                return;
            }
            --this.state.depth;
            if (this.state.depth == 0L && this.state.initialized) {
                LMDB.mdb_txn_reset((long)this.state.txn);
            }
        }

        private void registerIfNeeded() {
            if (!this.registered) {
                this.readTransactions.add(this);
                this.registered = true;
            }
        }

        private void unregister() {
            this.readTransactions.remove(this);
            this.registered = false;
        }

        private void closeInternal() {
            if (this.state.initialized) {
                this.cleaner.clean();
            }
            if (this.registered) {
                this.unregister();
            }
        }

        void close() {
            this.closeInternal();
        }

        static class State
        implements Runnable {
            public long txn;
            public long depth;
            private boolean initialized;

            public State(long txn) {
                this.txn = txn;
            }

            @Override
            public void run() {
                if (this.initialized) {
                    long txn = this.txn;
                    this.txn = -1L;
                    if (txn != -1L) {
                        try {
                            if (this.depth > 0L) {
                                LMDB.mdb_txn_reset((long)txn);
                                this.depth = 0L;
                            }
                        }
                        finally {
                            LMDB.mdb_txn_abort((long)txn);
                        }
                    }
                    this.initialized = false;
                }
            }
        }
    }
}

