/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class ApplyNormalizeGraphInnerPathsTransform
extends BaseTransform {
    private ApplyNormalizeGraphInnerPathsTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode n : bgp.getLines()) {
            if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                IrBGP inner = g.getWhere();
                inner = ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentPtThenSp(inner, r);
                inner = ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentSpThenPt(inner, r);
                inner = ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentPtThenPt(inner);
                inner = ApplyNormalizeGraphInnerPathsTransform.joinPathWithLaterSp(inner, r);
                inner = ApplyNormalizeGraphInnerPathsTransform.fuseAltInverseTailBGP(inner, r);
                out.add(new IrGraph(g.getGraph(), inner, g.isNewScope()));
                continue;
            }
            if (n instanceof IrBGP || n instanceof IrOptional || n instanceof IrMinus || n instanceof IrUnion || n instanceof IrService) {
                IrNode rec = BaseTransform.rewriteContainers(n, child -> ApplyNormalizeGraphInnerPathsTransform.apply(child, r));
                out.add(rec);
                continue;
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    public static IrBGP fuseAdjacentPtThenSp(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (i + 1 < in.size() && n instanceof IrPathTriple && in.get(i + 1) instanceof IrStatementPattern) {
                Var bridge;
                IrPathTriple pt = (IrPathTriple)n;
                IrStatementPattern sp = (IrStatementPattern)in.get(i + 1);
                Var pv = sp.getPredicate();
                if (ApplyNormalizeGraphInnerPathsTransform.isConstantIriPredicate(sp) && ApplyNormalizeGraphInnerPathsTransform.isAnonPathVar(bridge = pt.getObject())) {
                    String fused;
                    if (ApplyNormalizeGraphInnerPathsTransform.sameVar(bridge, sp.getSubject())) {
                        fused = pt.getPathText() + "/" + ApplyNormalizeGraphInnerPathsTransform.iri(pv, r);
                        IrPathTriple np = new IrPathTriple(pt.getSubject(), fused, sp.getObject(), false, pt.getPathVars());
                        out.add(np);
                        ++i;
                        continue;
                    }
                    if (ApplyNormalizeGraphInnerPathsTransform.sameVar(bridge, sp.getObject())) {
                        fused = pt.getPathText() + "/^" + ApplyNormalizeGraphInnerPathsTransform.iri(pv, r);
                        IrPathTriple np2 = new IrPathTriple(pt.getSubject(), fused, sp.getSubject(), false, pt.getPathVars());
                        out.add(np2);
                        ++i;
                        continue;
                    }
                }
            }
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    IrBGP nb = ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentPtThenSp(b, r);
                    nb = ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentSpThenPt(nb, r);
                    nb = ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentPtThenPt(nb);
                    nb = ApplyNormalizeGraphInnerPathsTransform.joinPathWithLaterSp(nb, r);
                    nb = ApplyNormalizeGraphInnerPathsTransform.fuseAltInverseTailBGP(nb, r);
                    u2.addBranch(nb);
                }
                out.add(u2);
                continue;
            }
            IrNode rec = BaseTransform.rewriteContainers(n, child -> ApplyNormalizeGraphInnerPathsTransform.fuseAdjacentPtThenSp(child, r));
            out.add(rec);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }
}

