/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class OrValueEvaluationStep
implements QueryValueEvaluationStep {
    private final QueryValueEvaluationStep leftArg;
    private final QueryValueEvaluationStep rightArg;

    public OrValueEvaluationStep(QueryValueEvaluationStep leftArg, QueryValueEvaluationStep rightArg) {
        this.leftArg = leftArg;
        this.rightArg = rightArg;
    }

    @Override
    public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.leftArg.evaluate(bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteral.TRUE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.rightArg.evaluate(bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteral.TRUE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.rightArg.evaluate(bindings);
        return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }
}

