/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.order.StatementOrder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;

public class QueryJoinOptimizer
implements QueryOptimizer {
    @Experimental
    public static int MERGE_JOIN_CARDINALITY_SIZE_DIFF_MULTIPLIER = 10;
    @Experimental
    public static boolean USE_MERGE_JOIN_FOR_LAST_STATEMENT_PATTERNS_WHEN_CROSS_JOIN = true;
    private static final int FULL_PAIRWISE_START_LIMIT = 6;
    protected final EvaluationStatistics statistics;
    private final boolean trackResultSize;
    private final TripleSource tripleSource;

    public QueryJoinOptimizer(EvaluationStatistics statistics) {
        this(statistics, false, new EmptyTripleSource());
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics, TripleSource tripleSource) {
        this(statistics, false, tripleSource);
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics, boolean trackResultSize) {
        this(statistics, trackResultSize, new EmptyTripleSource());
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics, boolean trackResultSize, TripleSource tripleSource) {
        this.statistics = statistics;
        this.trackResultSize = trackResultSize;
        this.tripleSource = tripleSource;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new JoinVisitor());
    }

    private static boolean statementPatternWithMinimumOneConstant(TupleExpr cand) {
        return cand instanceof StatementPattern && (((StatementPattern)cand).getSubjectVar() != null && ((StatementPattern)cand).getSubjectVar().hasValue() || ((StatementPattern)cand).getPredicateVar() != null && ((StatementPattern)cand).getPredicateVar().hasValue() || ((StatementPattern)cand).getObjectVar() != null && ((StatementPattern)cand).getObjectVar().hasValue() || ((StatementPattern)cand).getContextVar() != null && ((StatementPattern)cand).getContextVar().hasValue());
    }

    private static int getUnionSize(Set<String> currentListNames, Set<String> candidateBindingNames) {
        int count = 0;
        for (String n : currentListNames) {
            if (candidateBindingNames.contains(n)) continue;
            ++count;
        }
        return candidateBindingNames.size() + count;
    }

    private static int getJoinSize(Set<String> currentListNames, Set<String> names) {
        int count = 0;
        for (String name : names) {
            if (!currentListNames.contains(name)) continue;
            ++count;
        }
        return count;
    }

    private static boolean hasCachedCardinality(TupleExpr tupleExpr) {
        return tupleExpr instanceof AbstractQueryModelNode && ((AbstractQueryModelNode)((Object)tupleExpr)).isCardinalitySet();
    }

    private static final class EmptyTripleSource
    implements TripleSource {
        private EmptyTripleSource() {
        }

        @Override
        public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
            return TripleSource.EMPTY_ITERATION;
        }

        @Override
        public Set<StatementOrder> getSupportedOrders(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
            return Set.of();
        }

        @Override
        public ValueFactory getValueFactory() {
            return null;
        }

        @Override
        public Comparator<Value> getComparator() {
            return null;
        }
    }

    protected class JoinVisitor
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        private Set<String> boundVars;
        private double currentHighestCost;

        protected JoinVisitor() {
            super(QueryJoinOptimizer.this.trackResultSize);
            this.boundVars = new HashSet<String>();
            this.currentHighestCost = 1.0;
        }

        @Override
        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit(this);
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                this.boundVars.addAll(leftJoin.getLeftArg().getBindingNames());
                leftJoin.getRightArg().visit(this);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        @Override
        public void meet(StatementPattern node) throws RuntimeException {
            node.setResultSizeEstimate(Math.max(QueryJoinOptimizer.this.statistics.getCardinality(node), node.getResultSizeEstimate()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void optimizePriorityJoin(Set<String> origBoundVars, TupleExpr join) {
            Set<String> saveBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(origBoundVars);
                join.visit(this);
            }
            finally {
                this.boundVars = saveBoundVars;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void meet(Join node) {
            Set<String> origBoundVars = this.boundVars;
            try {
                List<TupleExpr> priorityArgs;
                this.boundVars = new HashSet<String>(this.boundVars);
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs(node, new ArrayList());
                List<TupleExpr> orderedExtensions = this.getExtensionTupleExprs(joinArgs);
                this.optimizeInNewScope(orderedExtensions);
                joinArgs.removeAll(orderedExtensions);
                List<TupleExpr> subSelects = this.getSubSelects(joinArgs);
                this.optimizeInNewScope(subSelects);
                List<TupleExpr> orderedSubselects = this.reorderSubselects(subSelects);
                joinArgs.removeAll(orderedSubselects);
                if (orderedExtensions.isEmpty()) {
                    priorityArgs = orderedSubselects;
                } else if (orderedSubselects.isEmpty()) {
                    priorityArgs = orderedExtensions;
                } else {
                    priorityArgs = new ArrayList<TupleExpr>(orderedExtensions.size() + orderedSubselects.size());
                    priorityArgs.addAll(orderedExtensions);
                    priorityArgs.addAll(orderedSubselects);
                }
                Deque<TupleExpr> orderedJoinArgs = new ArrayDeque<TupleExpr>(joinArgs.size());
                if (!joinArgs.isEmpty()) {
                    Map<TupleExpr, Double> cardinalityMap = Collections.emptyMap();
                    HashMap<TupleExpr, List<Var>> varsMap = new HashMap<TupleExpr, List<Var>>();
                    for (TupleExpr tupleExpr : joinArgs) {
                        if (tupleExpr instanceof Join) continue;
                        double cardinality = QueryJoinOptimizer.this.statistics.getCardinality(tupleExpr);
                        tupleExpr.setResultSizeEstimate(Math.max(cardinality, tupleExpr.getResultSizeEstimate()));
                        if (!QueryJoinOptimizer.hasCachedCardinality(tupleExpr)) {
                            if (cardinalityMap.isEmpty()) {
                                cardinalityMap = new HashMap<TupleExpr, Double>();
                            }
                            cardinalityMap.put(tupleExpr, cardinality);
                        }
                        if (tupleExpr instanceof ZeroLengthPath) {
                            varsMap.put(tupleExpr, ((ZeroLengthPath)tupleExpr).getVarList());
                            continue;
                        }
                        varsMap.put(tupleExpr, this.getStatementPatternVars(tupleExpr));
                    }
                    HashMap<Var, Integer> varFreqMap = new HashMap<Var, Integer>((varsMap.size() + 1) * 2);
                    for (List varList : varsMap.values()) {
                        this.fillVarFreqMap(varList, varFreqMap);
                    }
                    while (!joinArgs.isEmpty()) {
                        TupleExpr tupleExpr = this.selectNextTupleExpr(joinArgs, cardinalityMap, varsMap, varFreqMap);
                        this.currentHighestCost = Math.max(this.currentHighestCost, tupleExpr.getCostEstimate());
                        joinArgs.remove(tupleExpr);
                        orderedJoinArgs.addLast(tupleExpr);
                        tupleExpr.visit(this);
                        this.boundVars.addAll(tupleExpr.getBindingNames());
                    }
                }
                if (QueryJoinOptimizer.this.statistics.supportsJoinEstimation() && orderedJoinArgs.size() > 2) {
                    orderedJoinArgs = this.reorderJoinArgs(orderedJoinArgs);
                }
                TupleExpr priorityJoins = null;
                if (!priorityArgs.isEmpty()) {
                    priorityJoins = priorityArgs.get(0);
                    for (int i = 1; i < priorityArgs.size(); ++i) {
                        priorityJoins = new Join(priorityJoins, priorityArgs.get(i));
                    }
                }
                if (priorityJoins == null && !orderedJoinArgs.isEmpty()) {
                    Set<Var> set;
                    double cardinality = 0.0;
                    while (orderedJoinArgs.size() > 1 && !(set = orderedJoinArgs.peekFirst().getSupportedOrders(QueryJoinOptimizer.this.tripleSource)).isEmpty()) {
                        TupleExpr left = orderedJoinArgs.removeFirst();
                        TupleExpr right = orderedJoinArgs.removeFirst();
                        HashSet<Var> hashSet = new HashSet<Var>(set);
                        hashSet.retainAll(right.getSupportedOrders(QueryJoinOptimizer.this.tripleSource));
                        if (hashSet.isEmpty() || this.joinOnMultipleVars(left, right) || this.joinSizeIsTooDifferent(Math.max(cardinality, left.getResultSizeEstimate()), right.getResultSizeEstimate())) {
                            orderedJoinArgs.addFirst(right);
                            orderedJoinArgs.addFirst(left);
                            break;
                        }
                        cardinality = Math.max(cardinality, left.getResultSizeEstimate());
                        cardinality = Math.max(cardinality, right.getResultSizeEstimate());
                        Join join = new Join(left, right);
                        join.setOrder((Var)hashSet.toArray()[0]);
                        join.setMergeJoin(true);
                        orderedJoinArgs.addFirst(join);
                    }
                }
                if (!orderedJoinArgs.isEmpty()) {
                    int i = orderedJoinArgs.size() - 1;
                    TupleExpr right = orderedJoinArgs.removeLast();
                    if (!orderedJoinArgs.isEmpty()) {
                        TupleExpr tupleExpr = orderedJoinArgs.removeLast();
                        HashSet<Var> supportedOrders = new HashSet<Var>(tupleExpr.getSupportedOrders(QueryJoinOptimizer.this.tripleSource));
                        supportedOrders.retainAll(right.getSupportedOrders(QueryJoinOptimizer.this.tripleSource));
                        Join join = new Join(tupleExpr, right);
                        if (USE_MERGE_JOIN_FOR_LAST_STATEMENT_PATTERNS_WHEN_CROSS_JOIN) {
                            this.mergeJoinForCrossJoin(orderedJoinArgs, supportedOrders, tupleExpr, right, join);
                        }
                        right = join;
                    }
                    while (!orderedJoinArgs.isEmpty()) {
                        right = new Join(orderedJoinArgs.removeLast(), right);
                    }
                    if (priorityJoins != null) {
                        right = new Join(priorityJoins, right);
                    }
                    node.replaceWith(right);
                    if (priorityJoins != null) {
                        this.optimizePriorityJoin(origBoundVars, priorityJoins);
                    }
                } else {
                    node.replaceWith(priorityJoins);
                }
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        private Deque<TupleExpr> reorderJoinArgs(Deque<TupleExpr> orderedJoinArgs) {
            ArrayList<TupleExpr> tupleExprs = new ArrayList<TupleExpr>(orderedJoinArgs);
            ArrayDeque<TupleExpr> ret = new ArrayDeque<TupleExpr>();
            HashMap cardCache = new HashMap();
            BiFunction<TupleExpr, TupleExpr, Double> getCard = (a, b) -> {
                Map inner = cardCache.computeIfAbsent(a, k -> new HashMap());
                Double cached = (Double)inner.get(b);
                if (cached != null) {
                    return cached;
                }
                double c = QueryJoinOptimizer.this.statistics.getCardinality(new Join((TupleExpr)a, (TupleExpr)b));
                inner.put(b, c);
                cardCache.computeIfAbsent(b, k -> new HashMap()).put(a, c);
                return c;
            };
            while (!tupleExprs.isEmpty()) {
                TupleExpr bestStart;
                if (ret.isEmpty() && (bestStart = this.selectBestStartingExpr(tupleExprs, getCard)) != null) {
                    tupleExprs.remove(bestStart);
                    ret.addLast(bestStart);
                    continue;
                }
                if (ret.isEmpty() || !(tupleExprs.get(0) instanceof StatementPattern)) {
                    ret.addLast((TupleExpr)tupleExprs.remove(0));
                    continue;
                }
                TupleExpr bestCandidate = null;
                double bestCost = Double.MAX_VALUE;
                for (TupleExpr cand : tupleExprs) {
                    if (!QueryJoinOptimizer.statementPatternWithMinimumOneConstant(cand)) continue;
                    for (TupleExpr prev : ret) {
                        double cost;
                        if (!QueryJoinOptimizer.statementPatternWithMinimumOneConstant(prev) || !((cost = getCard.apply(prev, cand).doubleValue()) < bestCost)) continue;
                        bestCost = cost;
                        bestCandidate = cand;
                    }
                }
                if (bestCandidate != null) {
                    tupleExprs.remove(bestCandidate);
                    ret.addLast(bestCandidate);
                    continue;
                }
                ret.addLast((TupleExpr)tupleExprs.remove(0));
            }
            return ret;
        }

        /*
         * WARNING - void declaration
         */
        private TupleExpr selectBestStartingExpr(List<TupleExpr> tupleExprs, BiFunction<TupleExpr, TupleExpr, Double> getCard) {
            double cardB;
            void var5_9;
            ArrayList<TupleExpr> candidates = new ArrayList<TupleExpr>();
            for (TupleExpr tupleExpr : tupleExprs) {
                if (!QueryJoinOptimizer.statementPatternWithMinimumOneConstant(tupleExpr)) continue;
                candidates.add(tupleExpr);
            }
            if (candidates.size() < 2) {
                return null;
            }
            HashMap<TupleExpr, Double> singleCard = new HashMap<TupleExpr, Double>(candidates.size());
            for (TupleExpr candidate : candidates) {
                singleCard.put(candidate, QueryJoinOptimizer.this.statistics.getCardinality(candidate));
            }
            ArrayList<TupleExpr> arrayList = new ArrayList<TupleExpr>(candidates);
            if (arrayList.size() > 6) {
                arrayList.sort(Comparator.comparingDouble(singleCard::get));
                ArrayList arrayList2 = new ArrayList(arrayList.subList(0, Math.min(3, arrayList.size())));
            }
            TupleExpr bestA = null;
            TupleExpr bestB = null;
            double bestCost = Double.MAX_VALUE;
            for (TupleExpr a : var5_9) {
                for (TupleExpr b : candidates) {
                    double cost;
                    if (a == b || !((cost = getCard.apply(a, b).doubleValue()) < bestCost)) continue;
                    bestCost = cost;
                    bestA = a;
                    bestB = b;
                }
            }
            if (bestA == null) {
                return null;
            }
            double cardA = (Double)singleCard.get(bestA);
            return cardA <= (cardB = ((Double)singleCard.get(bestB)).doubleValue()) ? bestA : bestB;
        }

        private void optimizeInNewScope(List<TupleExpr> subSelects) {
            for (TupleExpr subSelect : subSelects) {
                subSelect.visit(new JoinVisitor());
            }
        }

        private boolean joinSizeIsTooDifferent(double cardinality, double second) {
            if (cardinality > second && cardinality / (double)MERGE_JOIN_CARDINALITY_SIZE_DIFF_MULTIPLIER > second) {
                return true;
            }
            return second > cardinality && second / (double)MERGE_JOIN_CARDINALITY_SIZE_DIFF_MULTIPLIER > cardinality;
        }

        private boolean joinOnMultipleVars(TupleExpr first, TupleExpr second) {
            Set<String> firstBindingNames = first.getBindingNames();
            if (firstBindingNames.size() == 1) {
                return false;
            }
            Set<String> secondBindingNames = second.getBindingNames();
            if (secondBindingNames.size() == 1) {
                return false;
            }
            int overlap = 0;
            for (String firstBindingName : firstBindingNames) {
                if (!firstBindingName.startsWith("_const_") && secondBindingNames.contains(firstBindingName)) {
                    ++overlap;
                }
                if (overlap <= true) continue;
                return true;
            }
            return false;
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }

        protected List<Var> getStatementPatternVars(TupleExpr tupleExpr) {
            if (tupleExpr instanceof StatementPattern) {
                return ((StatementPattern)tupleExpr).getVarList();
            }
            if (tupleExpr instanceof BindingSetAssignment) {
                return List.of();
            }
            return new StatementPatternVarCollector(tupleExpr).getVars();
        }

        protected <M extends Map<Var, Integer>> void fillVarFreqMap(List<Var> varList, M varFreqMap) {
            if (varList.isEmpty()) {
                return;
            }
            for (Var var : varList) {
                varFreqMap.compute((Var)var, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    return v + 1;
                });
            }
        }

        private List<TupleExpr> getExtensionTupleExprs(List<TupleExpr> expressions) {
            if (expressions.isEmpty()) {
                return List.of();
            }
            List<TupleExpr> extensions = List.of();
            for (TupleExpr expr : expressions) {
                if (!TupleExprs.containsExtension(expr)) continue;
                if (extensions.isEmpty()) {
                    extensions = List.of(expr);
                    continue;
                }
                if (extensions.size() == 1) {
                    extensions = new ArrayList<TupleExpr>(extensions);
                }
                extensions.add(expr);
            }
            return extensions;
        }

        protected List<TupleExpr> getSubSelects(List<TupleExpr> expressions) {
            if (expressions.isEmpty()) {
                return List.of();
            }
            List<TupleExpr> subselects = List.of();
            for (TupleExpr expr : expressions) {
                if (!TupleExprs.containsSubquery(expr)) continue;
                if (subselects.isEmpty()) {
                    subselects = List.of(expr);
                    continue;
                }
                if (subselects.size() == 1) {
                    subselects = new ArrayList<TupleExpr>(subselects);
                }
                subselects.add(expr);
            }
            return subselects;
        }

        protected List<TupleExpr> reorderSubselects(List<TupleExpr> subSelects) {
            if (subSelects.size() == 1) {
                return subSelects;
            }
            ArrayList<TupleExpr> result = new ArrayList<TupleExpr>();
            if (subSelects.isEmpty()) {
                return result;
            }
            HashMap joinSizes = new HashMap();
            int maxJoinSize = 0;
            for (int i = 0; i < subSelects.size(); ++i) {
                TupleExpr firstArg = subSelects.get(i);
                for (int j = i + 1; j < subSelects.size(); ++j) {
                    TupleExpr secondArg = subSelects.get(j);
                    int joinSize = QueryJoinOptimizer.getJoinSize(firstArg.getBindingNames(), secondArg.getBindingNames());
                    if (joinSize > maxJoinSize) {
                        maxJoinSize = joinSize;
                    }
                    List l = joinSizes.containsKey(joinSize) ? (List)joinSizes.get(joinSize) : new ArrayList();
                    TupleExpr[] tupleTuple = new TupleExpr[]{firstArg, secondArg};
                    l.add(tupleTuple);
                    joinSizes.put(joinSize, l);
                }
            }
            TupleExpr[] maxUnionTupleTuple = null;
            int currentUnionSize = -1;
            List list = (List)joinSizes.get(maxJoinSize);
            for (TupleExpr[] tupleTuple : list) {
                Set<String> names = tupleTuple[0].getBindingNames();
                names.addAll(tupleTuple[1].getBindingNames());
                int unionSize = names.size();
                if (unionSize <= currentUnionSize) continue;
                maxUnionTupleTuple = tupleTuple;
                currentUnionSize = unionSize;
            }
            assert (maxUnionTupleTuple != null);
            result.add((TupleExpr)maxUnionTupleTuple[0]);
            result.add((TupleExpr)maxUnionTupleTuple[1]);
            while (result.size() < subSelects.size()) {
                result.add(this.getNextSubselect(result, subSelects));
            }
            return result;
        }

        private TupleExpr getNextSubselect(List<TupleExpr> currentList, List<TupleExpr> joinArgs) {
            HashSet<String> currentListNames = new HashSet<String>();
            for (TupleExpr expr : currentList) {
                currentListNames.addAll(expr.getBindingNames());
            }
            TupleExpr selected = null;
            int currentUnionSize = -1;
            int currentJoinSize = -1;
            for (TupleExpr candidate : joinArgs) {
                if (currentList.contains(candidate)) continue;
                Set<String> names = candidate.getBindingNames();
                int joinSize = QueryJoinOptimizer.getJoinSize(currentListNames, names);
                Set<String> candidateBindingNames = candidate.getBindingNames();
                int unionSize = QueryJoinOptimizer.getUnionSize(currentListNames, candidateBindingNames);
                if (joinSize > currentJoinSize) {
                    selected = candidate;
                    currentJoinSize = joinSize;
                    currentUnionSize = unionSize;
                    continue;
                }
                if (joinSize != currentJoinSize || unionSize <= currentUnionSize) continue;
                selected = candidate;
                currentUnionSize = unionSize;
            }
            return selected;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap) {
            if (expressions.size() == 1) {
                TupleExpr tupleExpr = expressions.get(0);
                if (tupleExpr.getCostEstimate() < 0.0) {
                    tupleExpr.setCostEstimate(this.getTupleExprCost(tupleExpr, cardinalityMap, varsMap, varFreqMap));
                }
                return tupleExpr;
            }
            QueryModelNode result = null;
            double lowestCost = Double.POSITIVE_INFINITY;
            for (TupleExpr tupleExpr : expressions) {
                double cost = this.getTupleExprCost(tupleExpr, cardinalityMap, varsMap, varFreqMap);
                if (!(cost < lowestCost) && result != null) continue;
                lowestCost = cost;
                result = tupleExpr;
                if (cost != 0.0) continue;
                break;
            }
            assert (result != null);
            result.setCostEstimate(lowestCost);
            return result;
        }

        protected double getTupleExprCost(TupleExpr tupleExpr, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap) {
            if (tupleExpr instanceof BindingSetAssignment) {
                Set<Var> varsUsedInOtherExpressions = varFreqMap.keySet();
                for (String assuredBindingName : tupleExpr.getAssuredBindingNames()) {
                    if (!varsUsedInOtherExpressions.contains(Var.of(assuredBindingName))) continue;
                    return 0.0;
                }
            }
            double cost = QueryJoinOptimizer.hasCachedCardinality(tupleExpr) ? ((AbstractQueryModelNode)((Object)tupleExpr)).getCardinality() : cardinalityMap.get(tupleExpr).doubleValue();
            cost += 5.0;
            List<Var> vars = varsMap.get(tupleExpr);
            List<Var> unboundVars = this.getUnboundVars(vars);
            int constantVars = this.countConstantVars(vars);
            int nonConstantVarCount = vars.size() - constantVars;
            if (nonConstantVarCount > 0) {
                int boundVarCount = nonConstantVarCount - unboundVars.size();
                if (boundVarCount == 0) {
                    cost *= this.currentHighestCost;
                } else {
                    double exp = (double)unboundVars.size() / (double)nonConstantVarCount;
                    cost = Math.pow(cost, exp);
                }
            }
            if (unboundVars.isEmpty()) {
                if (nonConstantVarCount > 0) {
                    cost /= (double)nonConstantVarCount;
                }
            } else {
                int foreignVarFreq = this.getForeignVarFreq(unboundVars, varFreqMap);
                if (foreignVarFreq > 0) {
                    cost /= (double)(1 + foreignVarFreq);
                }
            }
            return cost;
        }

        private int countConstantVars(List<Var> vars) {
            int size = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++size;
            }
            return size;
        }

        protected List<Var> getUnboundVars(List<Var> vars) {
            int size = vars.size();
            if (size == 0) {
                return List.of();
            }
            if (size == 1) {
                Var var = vars.get(0);
                if (!var.hasValue() && var.getName() != null && !this.boundVars.contains(var.getName())) {
                    return List.of(var);
                }
                return List.of();
            }
            List<Var> ret = null;
            for (Var var : vars) {
                if (var.hasValue() || var.getName() == null || this.boundVars.contains(var.getName())) continue;
                if (ret == null) {
                    ret = List.of(var);
                    continue;
                }
                if (ret.size() == 1) {
                    ret = new ArrayList<Var>(ret);
                }
                ret.add(var);
            }
            return ret != null ? ret : Collections.emptyList();
        }

        protected int getForeignVarFreq(List<Var> ownUnboundVars, Map<Var, Integer> varFreqMap) {
            if (ownUnboundVars.isEmpty()) {
                return 0;
            }
            if (ownUnboundVars.size() == 1) {
                return varFreqMap.get(ownUnboundVars.get(0)) - 1;
            }
            int result = -ownUnboundVars.size();
            for (Var var : new HashSet<Var>(ownUnboundVars)) {
                result += varFreqMap.get(var).intValue();
            }
            return result;
        }

        private void mergeJoinForCrossJoin(Deque<TupleExpr> orderedJoinArgs, Set<Var> supportedOrders, TupleExpr left, TupleExpr right, Join join) {
            if (!orderedJoinArgs.isEmpty() && !supportedOrders.isEmpty() && !this.joinOnMultipleVars(left, right) && !this.joinSizeIsTooDifferent(left.getResultSizeEstimate(), right.getResultSizeEstimate()) && left instanceof StatementPattern && right instanceof StatementPattern) {
                HashSet<String> allBindingNamesAbove = new HashSet<String>();
                for (TupleExpr orderedJoinArg : orderedJoinArgs) {
                    allBindingNamesAbove.addAll(orderedJoinArg.getBindingNames());
                }
                if (!allBindingNamesAbove.isEmpty()) {
                    Set<String> joinBindingNames = join.getBindingNames();
                    boolean crossJoin = true;
                    for (String leftBindingName : joinBindingNames) {
                        if (leftBindingName.startsWith("_const_") || !allBindingNamesAbove.contains(leftBindingName)) continue;
                        crossJoin = false;
                        break;
                    }
                    if (crossJoin) {
                        join.setOrder((Var)supportedOrders.toArray()[0]);
                        join.setMergeJoin(true);
                        join.setCacheable(true);
                    }
                }
            }
        }

        private class StatementPatternVarCollector
        extends StatementPatternVisitor {
            private final TupleExpr tupleExpr;
            private List<Var> vars;

            public StatementPatternVarCollector(TupleExpr tupleExpr) {
                this.tupleExpr = tupleExpr;
            }

            @Override
            protected void accept(StatementPattern node) {
                if (this.vars == null) {
                    this.vars = new ArrayList<Var>(node.getVarList());
                } else {
                    this.vars.addAll(node.getVarList());
                }
            }

            public List<Var> getVars() {
                if (this.vars == null) {
                    try {
                        this.tupleExpr.visit(this);
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        throw new IllegalStateException(e);
                    }
                    if (this.vars == null) {
                        this.vars = Collections.emptyList();
                    }
                }
                return this.vars;
            }
        }
    }
}

