/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.apache.lucene.search.uhighlight.CharArrayMatcher;
import org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import org.apache.lucene.search.uhighlight.UHComponents;

public class MemoryIndexOffsetStrategy
extends AnalysisOffsetStrategy {
    private final MemoryIndex memoryIndex;
    private final LeafReader memIndexLeafReader;
    private final CharArrayMatcher preMemIndexFilterAutomaton;

    public MemoryIndexOffsetStrategy(UHComponents components, Analyzer analyzer) {
        super(components, analyzer);
        boolean storePayloads = components.getPhraseHelper().hasPositionSensitivity();
        this.memoryIndex = new MemoryIndex(true, storePayloads);
        this.memIndexLeafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
        this.preMemIndexFilterAutomaton = MemoryIndexOffsetStrategy.buildCombinedAutomaton(components);
    }

    private static CharArrayMatcher buildCombinedAutomaton(UHComponents components) {
        if (components.getTerms() == null || components.getAutomata() == null) {
            return null;
        }
        ArrayList<CharArrayMatcher> allAutomata = new ArrayList<CharArrayMatcher>();
        if (components.getTerms().length > 0) {
            allAutomata.add(CharArrayMatcher.fromTerms(Arrays.asList(components.getTerms())));
        }
        Collections.addAll(allAutomata, components.getAutomata());
        for (SpanQuery spanQuery : components.getPhraseHelper().getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata((Query)spanQuery, components.getFieldMatcher(), true));
        }
        if (allAutomata.size() == 1) {
            return (CharArrayMatcher)allAutomata.get(0);
        }
        return (chars, offset, length) -> {
            for (int i = 0; i < allAutomata.size(); ++i) {
                if (!((CharArrayMatcher)allAutomata.get(i)).match(chars, offset, length)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        if (this.preMemIndexFilterAutomaton != null) {
            tokenStream = MemoryIndexOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
        }
        this.memoryIndex.reset();
        this.memoryIndex.addField(this.getField(), tokenStream);
        if (reader == null) {
            return this.createOffsetsEnumFromReader(this.memIndexLeafReader, 0);
        }
        return this.createOffsetsEnumFromReader((LeafReader)new OverlaySingleDocTermsLeafReader(reader, this.memIndexLeafReader, this.getField(), docId), docId);
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharArrayMatcher matcher) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(x0);
                this.charAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            }

            protected boolean accept() throws IOException {
                return matcher.match(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }
}

