/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.operations.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.operations.IOperation;
import org.polarsys.reqcycle.operations.IReqCycleOperationManager;
import org.polarsys.reqcycle.operations.ReqCycleOperation;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class ReqCycleOperationManager
implements IReqCycleOperationManager {
    private static final String EXT_ID = "operation";
    private Collection<ReqCycleOperation> allOperations;

    @PostConstruct
    protected void init() {
        this.allOperations = this.doGetAllOperations();
    }

    @Override
    public Collection<ReqCycleOperation> getAllOperations() {
        return this.allOperations;
    }

    public Collection<ReqCycleOperation> doGetAllOperations() {
        ArrayList result = Lists.newArrayList();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.operations", EXT_ID);
        Class c = null;
        Object instance = null;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                c = Platform.getBundle((String)e.getContributor().getName()).loadClass(e.getAttribute("path"));
                instance = c.newInstance();
                ZigguratInject.inject((Object[])new Object[]{instance});
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (InvalidRegistryObjectException e1) {
                e1.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (c != null) {
                Method[] method;
                Method[] methodArray = method = c.getDeclaredMethods();
                int n3 = method.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (m.isAnnotationPresent(IOperation.class)) {
                        IOperation op = m.getAnnotation(IOperation.class);
                        ReqCycleOperation reqCycleOp = new ReqCycleOperation(m.getName(), op.value(), instance, m);
                        result.add(reqCycleOp);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public ReqCycleOperation getOperation(String name, Class<?>[] listClass) {
        for (ReqCycleOperation op : this.allOperations) {
            if (!op.getMethod().getName().equals(name)) continue;
            Class<?>[] paramList = op.getMethod().getParameterTypes();
            if (listClass.length == paramList.length) {
                int i = 0;
                while (i < paramList.length) {
                    Class<?> paramClass = paramList[i];
                    if (!paramClass.isAssignableFrom(listClass[i])) {
                        return null;
                    }
                    ++i;
                }
            }
            return op;
        }
        return null;
    }

    @Override
    public ReqCycleOperation getOperationForEditingAttributes(String name, Class<?>[] listClass) {
        for (ReqCycleOperation op : this.allOperations) {
            if (!op.getMethod().getName().equals(name)) continue;
            Class<?>[] paramList = op.getMethod().getParameterTypes();
            if (listClass.length > 0 && listClass.length == paramList.length - 1) {
                int i = 0;
                while (i < listClass.length) {
                    Class<?> paramClass = paramList[i + 1];
                    if (!paramClass.isAssignableFrom(listClass[i])) {
                        return null;
                    }
                    ++i;
                }
            }
            return op;
        }
        return null;
    }
}

