/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.reachables;

import java.net.URISyntaxException;
import javax.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.polarsys.reqcycle.emf.handlers.EMFURIHandler;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.reachables.ReqcycleReachableObject;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.NullReachableObject;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;

public class ReqcycleReachableHandler
extends EMFURIHandler {
    @Inject
    IDataManager dataManager;
    @Inject
    IReachableCreator reachableCreator;

    public boolean handlesURI(URI uri) {
        return ReqcycleReachableHandler.isReqcycle(uri);
    }

    public static boolean isReqcycle(URI uri) {
        return "reqcycle".equals(uri.scheme()) || uri.path().endsWith("reqcycle");
    }

    protected ReachableObject doGetReachableObject(Reachable t) {
        if (t.getPath().endsWith(".reqcycle")) {
            URI resourceUri = URI.createURI((String)t.toString()).trimFragment();
            for (RequirementSource reqSource : this.dataManager.getRequirementSources()) {
                RequirementsContainer content = reqSource.getContents();
                if (content == null || content.eResource() == null || !resourceUri.equals(content.eResource().getURI())) continue;
                try {
                    Reachable reqcycleReachable = this.reachableCreator.getReachable(new java.net.URI("reqcycle://" + URI.encodeSegment((String)reqSource.getName(), (boolean)true)));
                    reqcycleReachable.setFragment(t.getFragment());
                    return new ReqcycleReachableObject(reqcycleReachable, t);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new NullReachableObject();
        }
        if ("reqcycle".equals(t.getScheme())) {
            String reqSourceName = URI.decode((String)t.getHost());
            for (RequirementSource reqSource : this.dataManager.getRequirementSources()) {
                if (!reqSourceName.equals(reqSource.getName())) continue;
                RequirementsContainer content = reqSource.getContents();
                if (content == null || content.eResource() == null) break;
                try {
                    Reachable emfReachable = this.reachableCreator.getReachable(new java.net.URI(content.eResource().getURI().toString()));
                    emfReachable.setFragment(t.getFragment());
                    return new ReqcycleReachableObject(t, emfReachable);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new NullReachableObject();
        }
        return new ReqcycleReachableObject(null, t);
    }
}

