/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.pages;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.swt.SWTResourceManager;
import org.polarsys.reqcycle.export.pages.WizardController;
import org.polarsys.reqcycle.export.transform.IRequirementProvider;

public abstract class AbstractScopeAndOutputPage
extends WizardPage {
    private Text text;
    private CheckboxTreeViewer checkboxTreeViewer;
    private HashSet<IRequirementProvider> requirementSourceResult;
    protected WizardController controller;

    public AbstractScopeAndOutputPage(WizardController controller) {
        super("wizardPage");
        this.controller = controller;
        this.setTitle("Traceability");
        this.setDescription("If selection empty, the traceability will not be exported ");
    }

    public boolean isPageComplete() {
        return !this.text.getText().isEmpty();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group grpProjectsForAnalysis = new Group(composite, 0);
        grpProjectsForAnalysis.setLayout((Layout)new GridLayout(1, false));
        grpProjectsForAnalysis.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpProjectsForAnalysis.setText("Projects selection for analysis");
        Label lblIfSelectionEmpty = new Label((Composite)grpProjectsForAnalysis, 0);
        lblIfSelectionEmpty.setForeground(SWTResourceManager.getColor((int)3));
        lblIfSelectionEmpty.setText("If the selection is empty, the traceability will not be exported.");
        this.checkboxTreeViewer = new CheckboxTreeViewer((Composite)grpProjectsForAnalysis, 67584);
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof IWorkspace) {
                    IWorkspace root = (IWorkspace)element;
                    return new Object[]{root.getRoot()};
                }
                return super.getChildren(element);
            }
        });
        this.checkboxTreeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IProject || element instanceof IWorkspaceRoot;
            }
        }});
        this.checkboxTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.checkboxTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractScopeAndOutputPage.this.checkboxTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                AbstractScopeAndOutputPage.this.controller.clearProjectResults();
                int i = 0;
                while (i < AbstractScopeAndOutputPage.this.checkboxTreeViewer.getCheckedElements().length) {
                    if (AbstractScopeAndOutputPage.this.checkboxTreeViewer.getCheckedElements()[i] instanceof IProject) {
                        AbstractScopeAndOutputPage.this.controller.addProjectResult((IProject)AbstractScopeAndOutputPage.this.checkboxTreeViewer.getCheckedElements()[i]);
                    }
                    ++i;
                }
                AbstractScopeAndOutputPage.this.getWizard().getContainer().updateButtons();
                AbstractScopeAndOutputPage.this.getWizard().getContainer().updateMessage();
            }
        });
        Group grpOutput = new Group(composite, 0);
        grpOutput.setLayout((Layout)new GridLayout(2, false));
        grpOutput.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpOutput.setText("Output");
        this.text = new Text((Composite)grpOutput, 2048);
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.controller.getOutputPath() != null) {
            this.text.setText(this.controller.getOutputPath());
            this.checkExistingFile();
        }
        Button btnNewButton = new Button((Composite)grpOutput, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractScopeAndOutputPage.this.doWidgetSelected();
                FileDialog dlg = new FileDialog(AbstractScopeAndOutputPage.this.getShell(), 8192);
                dlg.setText(AbstractScopeAndOutputPage.this.getFileDialogTitle());
                dlg.setFilterExtensions(AbstractScopeAndOutputPage.this.getAllowedExtensions());
                String selectedDirectory = dlg.open();
                if (selectedDirectory != null) {
                    if ((selectedDirectory = selectedDirectory.replace('\\', '/')).toLowerCase().endsWith(AbstractScopeAndOutputPage.this.getAllowedExtensions()[dlg.getFilterIndex()])) {
                        AbstractScopeAndOutputPage.this.text.setText(selectedDirectory);
                    } else {
                        AbstractScopeAndOutputPage.this.text.setText(String.valueOf(selectedDirectory) + AbstractScopeAndOutputPage.this.getAllowedExtensions()[dlg.getFilterIndex()]);
                    }
                }
                AbstractScopeAndOutputPage.this.controller.setOutputPath(AbstractScopeAndOutputPage.this.text.getText());
                AbstractScopeAndOutputPage.this.checkExistingFile();
                AbstractScopeAndOutputPage.this.getWizard().getContainer().updateButtons();
                AbstractScopeAndOutputPage.this.getWizard().getContainer().updateMessage();
            }
        });
        btnNewButton.setText("...");
    }

    protected void checkExistingFile() {
        if (new File(this.controller.getOutputPath()).exists()) {
            this.setErrorMessage("The file already exists, it will be overriden");
        }
    }

    protected abstract String getCurrentExtension();

    protected void setRequirementSourceResult(HashSet<IRequirementProvider> result) {
        this.requirementSourceResult = result;
    }

    protected HashSet<IRequirementProvider> getRequirementSourceResult() {
        return this.requirementSourceResult;
    }

    public Text getText() {
        return this.text;
    }

    protected abstract String[] getAllowedExtensions();

    protected abstract void doWidgetSelected();

    protected abstract String getFileDialogTitle();
}

