/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.ocl.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IModelConstraintProvider;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.polarsys.reqcycle.utils.ocl.validation.OCLtoEMFConstraintWrapper;

public abstract class AbstractOCLtoEMFConstraintProvider
implements IModelConstraintProvider {
    protected OCL ocl;
    protected Collection<IModelConstraint> allConstraints = Lists.newArrayList();

    public AbstractOCLtoEMFConstraintProvider() {
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        PivotEnvironmentFactory environmentFactory = new PivotEnvironmentFactory(registry, null);
        this.ocl = OCL.newInstance((EnvironmentFactory)environmentFactory);
        for (URI uri : this.getOclUris()) {
            this.loadConstraintsFromCompleteOCL(uri);
        }
    }

    public Collection<IModelConstraint> getBatchConstraints(final EObject eObject, Collection<IModelConstraint> constraints) {
        Collection result = Collections2.filter(this.allConstraints, (Predicate)new Predicate<IModelConstraint>(){

            public boolean apply(IModelConstraint arg0) {
                return arg0.getDescriptor().targetsTypeOf(eObject);
            }
        });
        if (constraints != null) {
            constraints.addAll(result);
            return constraints;
        }
        return result;
    }

    public Collection<IModelConstraint> getLiveConstraints(final Notification notification, Collection<IModelConstraint> constraints) {
        Collection result = Collections2.filter(this.allConstraints, (Predicate)new Predicate<IModelConstraint>(){

            public boolean apply(IModelConstraint arg0) {
                return arg0.getDescriptor().targetsEvent(notification);
            }
        });
        if (constraints != null) {
            constraints.addAll(result);
            return constraints;
        }
        return result;
    }

    protected void loadConstraintsFromCompleteOCL(URI uri) {
        final Resource oclResource = this.ocl.parse(uri);
        Iterable oclConstraints = Iterables.filter((Iterable)new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return oclResource.getAllContents();
            }
        }, Constraint.class);
        Iterable emfConstraints = Iterables.transform((Iterable)oclConstraints, (Function)new Function<Constraint, IModelConstraint>(){

            public IModelConstraint apply(Constraint arg0) {
                return new OCLtoEMFConstraintWrapper(AbstractOCLtoEMFConstraintProvider.this.ocl, arg0);
            }
        });
        Iterables.addAll(this.allConstraints, (Iterable)emfConstraints);
    }

    protected abstract Iterable<URI> getOclUris();
}

