/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Entry;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeconfigurationFactory;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.util.ConfigUtils;
import org.polarsys.reqcycle.traceability.types.engine.impl.ConfigurationValueInjecter;
import org.polarsys.reqcycle.types.IInjectedTypeChecker;
import org.polarsys.reqcycle.types.IInjectedTypeProvider;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;

@Singleton
public class ConfigurationProvider
implements ITypesConfigurationProvider,
IInjectedTypeProvider {
    @Inject
    IConfigurationManager confManager;
    @Inject
    ITypesManager typesManager;

    @Override
    public TypeConfigContainer getContainer() {
        return (TypeConfigContainer)EcoreUtil.copy((EObject)this.doGetContainer());
    }

    @PostConstruct
    void init() {
        this.typesManager.addTypeProvider((IInjectedTypeProvider)this);
    }

    private TypeConfigContainer doGetContainer() {
        Collection conf = this.confManager.getConfiguration(null, null, "org.polarsys.reqcycle.traceability.types", null, null, false);
        TypeConfigContainer configuration = null;
        if (conf != null && !conf.isEmpty()) {
            configuration = (TypeConfigContainer)conf.iterator().next();
        }
        if (configuration == null) {
            configuration = TypeconfigurationFactory.eINSTANCE.createTypeConfigContainer();
            this.saveContainer(configuration);
        }
        int i = 0;
        while (i < configuration.getTypes().size()) {
            Type t = (Type)configuration.getTypes().get(0);
            if (t instanceof CustomType) {
                IType typeJava;
                CustomType custom = (CustomType)t;
                if (custom.getSuperType() == null) {
                    this.delete(custom);
                }
                if ((typeJava = custom.getSuperType().getIType()) == null) {
                    this.delete(custom);
                }
                if (typeJava.isExtensible()) {
                    HashSet descriptorsName = Sets.newHashSet((Iterable)Iterables.transform((Iterable)typeJava.getDescriptors(), (Function)new Function<IType.FieldDescriptor, String>(){

                        public String apply(IType.FieldDescriptor d) {
                            return d.name;
                        }
                    }));
                    if (custom.getEntries().size() != descriptorsName.size()) {
                        this.delete(custom);
                    } else {
                        for (Entry e : custom.getEntries()) {
                            if (descriptorsName.contains(e.getName())) continue;
                            this.delete(custom);
                            break;
                        }
                    }
                } else {
                    this.delete(custom);
                }
            }
            ++i;
        }
        for (IType t : this.typesManager.getAllTypes()) {
            Type typeFromContainer = ConfigUtils.getType(configuration, t.getId());
            if (typeFromContainer != null) continue;
            typeFromContainer = TypeconfigurationFactory.eINSTANCE.createType();
            typeFromContainer.setTypeId(t.getId());
            configuration.getTypes().add((Object)typeFromContainer);
        }
        return configuration;
    }

    protected void delete(CustomType custom) {
        EcoreUtil.delete((EObject)custom, (boolean)true);
    }

    @Override
    public Configuration getConfiguration(String id) {
        Configuration conf = this.doGetConfiguration(id);
        if (conf == null) {
            return null;
        }
        return (Configuration)EcoreUtil.copy((EObject)conf);
    }

    private Configuration doGetConfiguration(final String id) {
        TypeConfigContainer container = this.doGetContainer();
        Configuration conf = (Configuration)Iterables.find(container.getConfigurations(), (Predicate)new Predicate<Configuration>(){

            public boolean apply(Configuration conf) {
                return Objects.equal((Object)conf.getName(), (Object)id);
            }
        }, null);
        return conf;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        TypeConfigContainer container = this.doGetContainer();
        if (container.getDefaultConfiguration() == null) {
            return null;
        }
        TypeConfigContainer copy = (TypeConfigContainer)EcoreUtil.copy((EObject)container);
        return copy.getDefaultConfiguration();
    }

    @Override
    public void save(EObject eobject) {
        if (eobject instanceof TypeConfigContainer) {
            this.saveContainer((TypeConfigContainer)eobject);
        } else if (eobject instanceof Configuration) {
            this.saveConfiguration((Configuration)eobject);
        }
    }

    private void saveConfiguration(Configuration eobject) {
        TypeConfigContainer container = this.doGetContainer();
        Configuration conf = this.doGetConfiguration(eobject.getName());
        if (conf == null) {
            container.getConfigurations().add((Object)conf);
        } else {
            EcoreUtil.replace((EObject)conf, (EObject)eobject);
        }
    }

    private void saveContainer(TypeConfigContainer eobject) {
        try {
            this.confManager.saveConfiguration(Collections.singleton(eobject), null, null, "org.polarsys.reqcycle.traceability.types", null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDefaultConfiguration(Configuration conf) {
        this.saveConfiguration(conf);
        TypeConfigContainer container = this.doGetContainer();
        container.setDefaultConfiguration(conf);
    }

    public Iterable<IType> getTypes() {
        Collection conf = this.confManager.getConfiguration(null, null, "org.polarsys.reqcycle.traceability.types", null, null, false);
        TypeConfigContainer container = null;
        if (conf != null && !conf.isEmpty()) {
            container = (TypeConfigContainer)conf.iterator().next();
        }
        if (container == null) {
            return ImmutableList.of();
        }
        return Iterables.transform((Iterable)Iterables.filter(container.getTypes(), CustomType.class), (Function)new Function<CustomType, IType>(){

            public IType apply(CustomType custom) {
                Type superType = custom.getSuperType();
                IType superTypeJava = superType.getIType();
                return ConfigurationProvider.this.typesManager.newInjectedType(custom.getTypeId(), superTypeJava, (IInjectedTypeChecker.IValueInjecter)new ConfigurationValueInjecter(custom));
            }
        });
    }
}

