/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.StorageHelpersProvider;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.rdf.Queries;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.rdf.ReqVoc;

public class PropertiesStorageHelper {
    private static final ValueFactory valueFactory = ValueFactoryImpl.getInstance();
    private final RepositoryConnection conn;

    PropertiesStorageHelper(RepositoryConnection conn, StorageHelpersProvider storageHelpersProvider) {
        this.conn = conn;
    }

    public static URI getURI(URI owner, String name) {
        String url = owner.stringValue();
        StringBuilder builder = new StringBuilder(url);
        if (url.contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        builder.append("prop=");
        builder.append(name);
        return valueFactory.createURI(builder.toString());
    }

    public URI storeProperty(URI owner, String key, String value, Resource ... contexts) throws RepositoryException {
        URI propUri = PropertiesStorageHelper.getURI(owner, key);
        this.conn.add((Resource)owner, ReqVoc.HAS_PROPERTY, (Value)propUri, contexts);
        this.conn.add((Resource)propUri, RDFS.LABEL, (Value)valueFactory.createLiteral(key, XMLSchema.STRING), contexts);
        this.conn.add((Resource)propUri, RDF.VALUE, (Value)valueFactory.createLiteral(value, XMLSchema.STRING), contexts);
        return propUri;
    }

    public URI addOrUpdateProperty(URI owner, String key, String value, Resource ... contexts) throws RepositoryException {
        URI propUri = PropertiesStorageHelper.getURI(owner, key);
        this.conn.add((Resource)owner, ReqVoc.HAS_PROPERTY, (Value)propUri, contexts);
        this.conn.add((Resource)propUri, RDFS.LABEL, (Value)valueFactory.createLiteral(key, XMLSchema.STRING), contexts);
        if (this.conn.hasStatement((Resource)propUri, RDF.VALUE, null, false, contexts)) {
            this.conn.remove((Resource)propUri, RDF.VALUE, null, contexts);
        }
        this.conn.add((Resource)propUri, RDF.VALUE, (Value)valueFactory.createLiteral(value, XMLSchema.STRING), contexts);
        return propUri;
    }

    public String getStoredProperty(URI owner, String key, Resource context) throws RepositoryException, QueryEvaluationException, MalformedQueryException {
        String queryString = Queries.buildPropertySelectQuery(context);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        query.setBinding("owner", (Value)owner);
        query.setBinding("key", (Value)valueFactory.createLiteral(key, XMLSchema.STRING));
        TupleQueryResult result = query.evaluate();
        String ret = null;
        while (result.hasNext()) {
            BindingSet binding = (BindingSet)result.next();
            Value value = binding.getValue("value");
            if (value == null) continue;
            ret = value.stringValue();
        }
        return ret;
    }

    public void deleteStoredProperty(URI owner, String key, Resource context) throws UpdateExecutionException, MalformedQueryException, RepositoryException {
        String queryString = Queries.buildPropertyDeleteQuery(context);
        Update query = this.conn.prepareUpdate(QueryLanguage.SPARQL, queryString);
        query.setBinding("owner", (Value)owner);
        query.setBinding("key", (Value)valueFactory.createLiteral(key, XMLSchema.STRING));
        query.execute();
    }

    public void storeProperties(URI owner, Map<String, String> props, Resource ... contexts) throws RepositoryException {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.storeProperty(owner, key, value, contexts);
        }
    }

    public Map<String, String> getStoredProperties(URI owner, Resource context) throws RepositoryException, QueryEvaluationException, MalformedQueryException {
        String queryString = Queries.buildPropertySelectQuery(context);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        query.setBinding("owner", (Value)owner);
        TupleQueryResult result = query.evaluate();
        HashMap<String, String> map = new HashMap<String, String>();
        while (result.hasNext()) {
            BindingSet binding = (BindingSet)result.next();
            Value key = binding.getValue("key");
            Value value = binding.getValue("value");
            if (key == null || value == null) continue;
            map.put(key.stringValue(), value.stringValue());
        }
        return map;
    }
}

