/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.ui.prefs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.reqcycle.traceability.storage.IStoragePathProvider;
import org.polarsys.reqcycle.traceability.storage.vars.VarManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class StoragePathPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text txttraceability;
    IStoragePathProvider provider = (IStoragePathProvider)ZigguratInject.make(IStoragePathProvider.class);
    private VarManager varManager = new VarManager();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        top.setLayout((Layout)new GridLayout(4, false));
        Label lblPath = new Label(top, 0);
        lblPath.setText("path : ");
        this.txttraceability = new Text(top, 2048);
        this.txttraceability.setText(this.varManager.getPreferencePattern());
        this.txttraceability.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        final ListViewer listViewer = new ListViewer(top, 2560);
        List list = listViewer.getList();
        listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        listViewer.setInput((Object)this.varManager.getAllPatterns());
        listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StoragePathPreferencePage.this.insert(listViewer);
            }
        });
        GridData gd_list = new GridData(4, 4, true, true, 2, 1);
        gd_list.widthHint = 234;
        list.setLayoutData((Object)gd_list);
        Composite composite = new Composite(top, 0);
        composite.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        Button btnNewButton = new Button(composite, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StoragePathPreferencePage.this.insert(listViewer);
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        btnNewButton.setText("Insert");
        return parent;
    }

    public boolean isValid() {
        return this.txttraceability.getText().length() > 0;
    }

    public boolean performOk() {
        this.varManager.setPreferencePattern(this.txttraceability.getText());
        return super.performOk();
    }

    private void insert(ListViewer listViewer) {
        ISelection selection = listViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            for (Object o : structured) {
                if (!(o instanceof String)) continue;
                String string = (String)o;
                int caret = this.txttraceability.getCaretPosition();
                String value = this.txttraceability.getText();
                String end = value.substring(caret, value.length());
                String start = value.substring(0, caret);
                value = String.valueOf(start) + string + end;
                this.txttraceability.setText(value);
            }
        }
    }
}

