/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.dialogs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.predicates.core.api.ContainsPatternPredicate;
import org.polarsys.reqcycle.predicates.core.api.EnumEqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.EqualPredicate;
import org.polarsys.reqcycle.predicates.core.api.IEAttrPredicate;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.api.OPERATOR;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;

public class PredicateValueEditor
extends TitleAreaDialog {
    private final IPredicate predicate;
    private GenericEAttrPropsEditor editor;
    private Class predicateClass;
    private boolean comparator;
    private OPERATOR operator;
    private ComboViewer viewer;

    public PredicateValueEditor(Shell parentShell, IPredicate predicate, Class c, boolean comparator) {
        super(parentShell);
        this.predicate = predicate;
        this.editor = null;
        this.predicateClass = c;
        this.comparator = comparator;
        this.viewer = null;
    }

    protected Control createDialogArea(Composite parent) {
        IEAttrPredicate pParent;
        EAttribute a;
        EnumEqualPredicate equalPredicate;
        this.setTitle("Edition of predicate : " + this.predicate.getDisplayName());
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(2, false));
        ArrayList possibleValues = Lists.newArrayList();
        if (this.predicate instanceof EnumEqualPredicate && (equalPredicate = (EnumEqualPredicate)this.predicate).eContainer() instanceof IEAttrPredicate && (a = (EAttribute)(pParent = (IEAttrPredicate)equalPredicate.eContainer()).getTypedElement()) != null && a.getEAttributeType() instanceof EEnum) {
            possibleValues.addAll(((EEnum)a.getEAttributeType()).getELiterals());
        }
        this.addEditor(this.predicateClass, "Value : ", container, possibleValues);
        if (this.comparator) {
            Label label = new Label(container, 0);
            label.setText("Comparison operator :");
            this.viewer = new ComboViewer(container);
            this.viewer.add((Object[])OPERATOR.values());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)OPERATOR.values()[0]));
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof OPERATOR) {
                        PredicateValueEditor.this.operator = (OPERATOR)selection.getFirstElement();
                    }
                }
            });
        }
        return container;
    }

    public void addEditor(Class<?> c, String attName, Composite composite, Collection<Object> possibleValues) {
        ContainsPatternPredicate containsPredicate;
        this.editor = new GenericEAttrPropsEditor(composite, 0);
        this.editor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.editor.init(attName, c, possibleValues);
        if (this.predicate instanceof EqualPredicate) {
            EqualPredicate equalPredicate = (EqualPredicate)this.predicate;
            if (equalPredicate.getExpectedObject() != null) {
                this.editor.setInitialValue(equalPredicate.getExpectedObject());
            }
        } else if (this.predicate instanceof ContainsPatternPredicate && (containsPredicate = (ContainsPatternPredicate)this.predicate).getExpectedPattern() != null) {
            this.editor.setInitialValue((Object)containsPredicate.getExpectedPattern());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.editor.isEditionValid()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Some values are not entered or not valid");
            return;
        }
        super.buttonPressed(buttonId);
    }

    public GenericEAttrPropsEditor getEditor() {
        return this.editor;
    }

    public OPERATOR getOperator() {
        return this.operator;
    }
}

