/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.ui.wizard.pages;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractStorageBean;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.IUpdatablePage;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class AbstractSettingPage
extends WizardPage
implements IChangeListener {
    @Inject
    protected IDataModelManager dataManager;
    private ComboViewer cvDataModel;
    private ComboViewer cvScope;
    private Combo cScope;
    private Combo cDataModel;
    private Collection<Scope> inputScope = new ArrayList<Scope>();
    private Text txtFile;
    private Button btnBrowseDestinationFile;
    private Label lblCopyFile;
    private DataBindingContext bindingContext;
    private AbstractStorageBean bean;

    public AbstractSettingPage(String pageName, AbstractStorageBean bean) {
        super(pageName);
        ZigguratInject.inject((Object[])new Object[]{this});
        this.bean = bean;
    }

    public AbstractStorageBean getBean() {
        return this.bean;
    }

    public void createControl(Composite parent) {
        Composite compositeContainer = new Composite(parent, 0);
        compositeContainer = this.doCreateSpecific(compositeContainer);
        this.createModele(compositeContainer, "Model");
        this.createScope(compositeContainer, "Scope");
        this.createDestinationFile(compositeContainer);
        this.hookListeners();
        this.bindingContext = new DataBindingContext();
        this.initDataBindings(this.bindingContext);
        AbstractSettingPage.observeBean(this.bindingContext, this);
    }

    public static void observeBean(DataBindingContext bindingContext, IChangeListener listener) {
        IObservableList list = bindingContext.getValidationStatusProviders();
        for (Object o : list) {
            Binding b = (Binding)o;
            b.getTarget().addChangeListener(listener);
        }
    }

    protected void createModele(Composite compositeContainer, String labelTitleModele) {
        Label lblSeparatorModele = new Label(compositeContainer, 258);
        lblSeparatorModele.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        Label lblDataModel = new Label(compositeContainer, 0);
        lblDataModel.setText(labelTitleModele);
        this.cvDataModel = new ComboViewer(compositeContainer);
        this.cDataModel = this.cvDataModel.getCombo();
        this.cDataModel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cvDataModel.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvDataModel.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDataModel) {
                    return ((IDataModel)element).getName();
                }
                return super.getText(element);
            }
        });
        this.cvDataModel.setInput((Object)this.dataManager.getCurrentDataModels());
    }

    protected void createScope(Composite compositeContainer, String labelTitleScope) {
        Label lblScope = new Label(compositeContainer, 0);
        lblScope.setText(labelTitleScope);
        this.cvScope = new ComboViewer(compositeContainer);
        this.cScope = this.cvScope.getCombo();
        this.cScope.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cScope.setEnabled(false);
        this.cvScope.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvScope.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Scope) {
                    return ((Scope)element).getName();
                }
                return super.getText(element);
            }
        });
        this.cvScope.setInput(this.inputScope);
    }

    protected void hookListeners() {
        this.getDataModelSelectionChangedListener();
    }

    protected void createDestinationFile(Composite compositeContainer) {
        Label lblSeparator = new Label(compositeContainer, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        Composite radioBtnComposite = new Composite(compositeContainer, 0);
        radioBtnComposite.setLayout((Layout)new GridLayout(1, false));
        radioBtnComposite.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        Composite compositeCopy = new Composite(radioBtnComposite, 0);
        compositeCopy.setLayout((Layout)new GridLayout(3, false));
        compositeCopy.setLayoutData((Object)new GridData(4, 4, true, false));
        this.lblCopyFile = new Label(compositeCopy, 0);
        this.lblCopyFile.setText("Repository Folder :");
        this.txtFile = new Text(compositeCopy, 2048);
        this.txtFile.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtFile.setEnabled(false);
        this.btnBrowseDestinationFile = new Button(compositeCopy, 0);
        this.btnBrowseDestinationFile.setText("Browse");
        this.btnBrowseDestinationFile.setEnabled(true);
        this.lblCopyFile.setEnabled(true);
    }

    protected void getDataModelSelectionChangedListener() {
        this.cvDataModel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                AbstractSettingPage.this.inputScope.clear();
                AbstractSettingPage.this.cScope.setEnabled(false);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IDataModel) {
                    AbstractSettingPage.this.cScope.setEnabled(true);
                    AbstractSettingPage.this.inputScope.addAll(AbstractSettingPage.this.dataManager.getScopes((IDataModel)obj));
                }
                AbstractSettingPage.this.cvScope.refresh();
            }
        });
    }

    protected void getDestinationFileSelectionListener() {
        this.btnBrowseDestinationFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(AbstractSettingPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "select location for save");
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof IPath) {
                    IPath path = (IPath)result[0];
                    AbstractSettingPage.this.txtFile.setText(URI.createPlatformResourceURI((String)path.append(AbstractSettingPage.this.getBean().getFileName()).addFileExtension("reqcycle").toString(), (boolean)true).toString());
                }
            }
        });
    }

    protected final DataBindingContext initDataBindings(DataBindingContext bindingContext) {
        IViewerObservableValue observeSingleSelectionCvDataModel = ViewerProperties.singleSelection().observe((Viewer)this.cvDataModel);
        IObservableValue dataPackageBeanObserveValue = PojoProperties.value((String)"dataModel").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeSingleSelectionCvDataModel, dataPackageBeanObserveValue, null, null);
        IViewerObservableValue observeSingleSelectionCvScope = ViewerProperties.singleSelection().observe((Viewer)this.cvScope);
        IObservableValue scopeBeanObserveValue = PojoProperties.value((String)"scope").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeSingleSelectionCvScope, scopeBeanObserveValue, null, null);
        ISWTObservableValue observeTextTxtFileObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtFile);
        IObservableValue modelPathBeanObserveValue = PojoProperties.value((String)"outputPath").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeTextTxtFileObserveWidget, modelPathBeanObserveValue, null, null);
        this.doSpecificInitDataBindings(bindingContext);
        return bindingContext;
    }

    protected void doSpecificInitDataBindings(DataBindingContext bindingContext) {
    }

    public boolean isPageComplete() {
        StringBuffer error = new StringBuffer();
        boolean result = true;
        if (this.getBean().getDataModel() == null) {
            error.append("Choose a Data Model\n");
            result = false;
        }
        if (this.getBean().getScope() == null) {
            error.append("Choose a Scope\n");
            result = false;
        }
        if (!this.getBean().getIsReference().booleanValue() && (this.getBean().getOutputPath() == null || "".equals(this.getBean().getOutputPath()))) {
            error.append("Choose a destination path (Repository folder)\n");
            result = false;
        }
        if (!result) {
            this.setErrorMessage(error.toString());
        } else {
            this.setErrorMessage(null);
        }
        return result;
    }

    protected Composite doCreateSpecific(Composite parent) {
        return parent;
    }

    public void handleChange(ChangeEvent event) {
        this.bindingContext.updateModels();
        this.bindingContext.updateTargets();
        this.getWizard().getContainer().updateButtons();
        this.getWizard().getContainer().updateMessage();
        IWizardPage p = this.getNextPage();
        while (p != null) {
            if (p != this && p instanceof IUpdatablePage) {
                ((IUpdatablePage)p).hasChanged();
            }
            p = p.getNextPage();
        }
    }

    public void setFileName(String fileName) {
        this.getBean().setFileName(fileName);
    }
}

