/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui;

import java.util.StringTokenizer;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.IExceptionHandler;
import org.eclipse.ecf.internal.irc.ui.IRCMessageRenderer;
import org.eclipse.ecf.internal.irc.ui.Messages;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerUI;
import org.eclipse.ecf.presence.ui.chatroom.IMessageRenderer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class IRCUI
extends ChatRoomManagerUI {
    public static final String CHANNEL_PREFIX = "#";
    private static final String COMMAND_PREFIX = "/";
    private static final String COMMAND_DELIM = " ";

    public IRCUI(IContainer container, IChatRoomManager manager) {
        super(container, manager);
    }

    public IRCUI(IContainer container, IChatRoomManager manager, IExceptionHandler exceptionHandler) {
        super(container, manager, exceptionHandler);
    }

    protected String modifyRoomNameForTarget(String roomName) {
        if (!roomName.startsWith(CHANNEL_PREFIX)) {
            return new String(CHANNEL_PREFIX + roomName);
        }
        return roomName;
    }

    protected String[] getRoomsForTarget() {
        int index;
        String initialChannels = this.targetID.getName();
        int protocolSeparator = initialChannels.indexOf("://");
        if (protocolSeparator != -1) {
            initialChannels = initialChannels.substring(protocolSeparator + 3);
        }
        if ((index = initialChannels.lastIndexOf(COMMAND_PREFIX)) != -1) {
            initialChannels = initialChannels.substring(index + 1);
            while (initialChannels.startsWith(COMMAND_PREFIX)) {
                initialChannels = initialChannels.substring(1);
            }
        } else {
            initialChannels = null;
        }
        if (initialChannels == null || initialChannels.equals("") || initialChannels.equals(COMMAND_PREFIX)) {
            return new String[0];
        }
        StringTokenizer toks = new StringTokenizer(initialChannels, ",");
        String[] results = new String[toks.countTokens()];
        int i = 0;
        while (i < results.length) {
            String tmp = toks.nextToken();
            StringBuffer buf = new StringBuffer();
            while (tmp.startsWith("%23")) {
                buf.append(CHANNEL_PREFIX);
                tmp = tmp.substring(3);
            }
            buf.append(tmp);
            results[i] = buf.toString();
            if (!results[i].startsWith(CHANNEL_PREFIX)) {
                results[i] = CHANNEL_PREFIX + results[i];
            }
            ++i;
        }
        return results;
    }

    public String handleCommand(IChatRoomContainer chatRoomContainer, String inputLine) {
        if (inputLine != null && inputLine.startsWith(COMMAND_PREFIX)) {
            StringTokenizer st = new StringTokenizer(inputLine, COMMAND_DELIM);
            int countTokens = st.countTokens();
            String[] tokens = new String[countTokens];
            int i = 0;
            while (i < countTokens) {
                tokens[i] = st.nextToken();
                ++i;
            }
            String command = tokens[0];
            while (command.startsWith(COMMAND_PREFIX)) {
                command = command.substring(1);
            }
            String[] args = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, args, 0, tokens.length - 1);
            if (command.equalsIgnoreCase(Messages.IRCUI_JOIN_COMMAND)) {
                this.chatroomview.joinRoom(this.manager.getChatRoomInfo(args[0]), args.length > 1 ? args[1] : "");
                return null;
            }
            if (command.equalsIgnoreCase(Messages.IRCUI_QUIT_COMMAND)) {
                ID connectedID = this.container.getConnectedID();
                if (connectedID != null && MessageDialog.openQuestion((Shell)this.chatroomview.getSite().getShell(), (String)Messages.IRCUI_DISCONNECT_CONFIRM_TITLE, (String)NLS.bind((String)Messages.IRCUI_DISCONNECT_CONFIRM_MESSAGE, (Object)connectedID.getName()))) {
                    this.chatroomview.disconnect();
                }
                return null;
            }
            if (chatRoomContainer != null && command.equalsIgnoreCase(Messages.IRCUI_PART_COMMAND) && MessageDialog.openQuestion((Shell)this.chatroomview.getSite().getShell(), (String)Messages.IRCUI_DEPART_CONFIRM_TITLE, (String)NLS.bind((String)Messages.IRCUI_DEPART_CONFIRM_MESSAGE, (Object)chatRoomContainer.getConnectedID().getName()))) {
                chatRoomContainer.disconnect();
                return null;
            }
        }
        return inputLine;
    }

    protected IMessageRenderer getDefaultMessageRenderer() {
        return new IRCMessageRenderer();
    }
}

