/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients;

import java.util.Map;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.clients.IMessageReceiver;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.IPresenceListener;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;

public class XMPPChatClient {
    IContainer container = null;
    IPresenceContainerAdapter presence = null;
    IChatMessageSender sender = null;
    ID userID = null;
    IMessageReceiver receiver = null;
    IPresenceListener presenceListener = null;

    public XMPPChatClient() {
        this(null);
    }

    public XMPPChatClient(IMessageReceiver receiver) {
        this.receiver = receiver;
    }

    public XMPPChatClient(IMessageReceiver receiver, IPresenceListener presenceListener) {
        this(receiver);
        this.presenceListener = presenceListener;
    }

    public IContainer setupContainer() throws ECFException {
        if (this.container == null) {
            this.container = ContainerFactory.getDefault().createContainer("ecf.xmpp.smack");
        }
        return this.container;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public void setupPresence() throws ECFException {
        if (this.presence == null) {
            this.presence = (IPresenceContainerAdapter)this.container.getAdapter(IPresenceContainerAdapter.class);
            if (this.presence == null) {
                throw new ECFException("adapter is null");
            }
            this.sender = this.presence.getChatManager().getChatMessageSender();
            this.presence.getChatManager().addMessageListener(new IIMMessageListener(){

                public void handleMessageEvent(IIMMessageEvent messageEvent) {
                    if (messageEvent instanceof IChatMessageEvent) {
                        IChatMessage m = ((IChatMessageEvent)messageEvent).getChatMessage();
                        if (XMPPChatClient.this.receiver != null) {
                            XMPPChatClient.this.receiver.handleMessage(m);
                        }
                    }
                }
            });
            if (this.presenceListener != null) {
                this.presence.getRosterManager().addPresenceListener(this.presenceListener);
            }
        }
    }

    public void connect(String account, String password) throws ECFException {
        this.setupContainer();
        this.setupPresence();
        this.doConnect(account, password);
    }

    public void doConnect(String account, String password) throws ECFException {
        this.userID = this.createID(account);
        this.container.connect(this.userID, ConnectContextFactory.createPasswordConnectContext((String)password));
    }

    public ID createID(String name) {
        return IDFactory.getDefault().createID(this.container.getConnectNamespace(), name);
    }

    public void sendChat(String jid, String msg) {
        if (this.sender != null) {
            try {
                this.sender.sendChatMessage(this.createID(jid), msg);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendChat(ID targetID, String msg) {
        if (this.sender != null) {
            try {
                this.sender.sendChatMessage(targetID, msg);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendProperties(String jid, Map properties) {
        if (this.sender != null) {
            try {
                this.sender.sendChatMessage(this.createID(jid), null, IChatMessage.Type.CHAT, null, null, properties);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isConnected() {
        if (this.container == null) {
            return false;
        }
        return this.container.getConnectedID() != null;
    }

    public synchronized void close() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
            this.presence = null;
            this.sender = null;
            this.receiver = null;
            this.userID = null;
        }
    }
}

