/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.ui.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;
import org.eclipse.ecf.presence.search.ICriteria;
import org.eclipse.ecf.presence.search.ICriterion;
import org.eclipse.ecf.presence.search.IRestriction;
import org.eclipse.ecf.presence.search.IResult;
import org.eclipse.ecf.presence.search.IResultList;
import org.eclipse.ecf.presence.search.ISearch;
import org.eclipse.ecf.presence.search.IUserSearchCompleteEvent;
import org.eclipse.ecf.presence.search.IUserSearchEvent;
import org.eclipse.ecf.presence.search.IUserSearchListener;
import org.eclipse.ecf.presence.search.IUserSearchManager;
import org.eclipse.ecf.presence.search.UserSearchException;
import org.eclipse.ecf.presence.ui.MultiRosterAccount;
import org.eclipse.ecf.presence.ui.UserSearchView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class SearchContactDialog
extends Dialog {
    Button closeButton;
    Button searchButton;
    MultiRosterAccount account;
    Button addContactButton;
    Button runInBackgroundButton;
    Table tableResult;
    Table tableFields;

    public SearchContactDialog(Shell parentShell, MultiRosterAccount account) {
        super(parentShell);
        this.account = account;
    }

    protected void addListeners() {
        this.searchButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                IUserSearchManager userManager = SearchContactDialog.this.account.getPresenceContainerAdapter().getUserSearchManager();
                try {
                    IRestriction selection = userManager.createRestriction();
                    ICriteria criteria = userManager.createCriteria();
                    TableItem[] items = SearchContactDialog.this.tableFields.getItems();
                    int i = 0;
                    while (i < items.length) {
                        TableItem item = items[i];
                        if (item.getChecked()) {
                            ICriterion criterion = selection.eq(item.getText(0), item.getText(1));
                            criteria.add(criterion);
                        }
                        ++i;
                    }
                    if (SearchContactDialog.this.runInBackgroundButton.getSelection()) {
                        SearchContactDialog.this.callAsynchronous(userManager, criteria);
                        SearchContactDialog.this.close();
                    } else {
                        ISearch search = userManager.search(criteria);
                        IResultList resultList = search.getResultList();
                        SearchContactDialog.this.tableResult.removeAll();
                        Iterator iterator = resultList.getResults().iterator();
                        while (iterator.hasNext()) {
                            IResult result = (IResult)iterator.next();
                            TableItem item = new TableItem(SearchContactDialog.this.tableResult, 0);
                            item.setText(0, result.getUser().getName());
                            item.setText(1, result.getUser().getID().getName());
                        }
                    }
                }
                catch (UserSearchException e1) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, e1.getLocalizedMessage(), (Throwable)e1));
                }
            }
        });
        this.addContactButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem contact = SearchContactDialog.this.tableResult.getSelection()[0];
                if (MessageDialog.openConfirm(null, (String)Messages.AddContactDialog_DialogTitle, (String)NLS.bind((String)Messages.SearchContactDialog_AddContactMessage, (Object)contact.getText(0)))) {
                    IPresenceContainerAdapter ipca = SearchContactDialog.this.account.getPresenceContainerAdapter();
                    IRosterSubscriptionSender sender = ipca.getRosterManager().getRosterSubscriptionSender();
                    try {
                        sender.sendRosterAdd(contact.getText(1), contact.getText(0), null);
                    }
                    catch (ECFException e1) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, e1.getLocalizedMessage(), (Throwable)e1));
                    }
                    SearchContactDialog.this.close();
                }
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SearchContactDialog_DialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        this.closeButton = this.getButton(0);
        this.closeButton.setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        boolean editableColumn = true;
        try {
            parent = (Composite)super.createDialogArea(parent);
            parent.setLayout((Layout)new GridLayout(2, false));
            String[] fields = null;
            IUserSearchManager userManager = this.account.getPresenceContainerAdapter().getUserSearchManager();
            fields = userManager.getUserPropertiesFields();
            GridData searchButtonData = new GridData(131072, 768, false, false, 1, 1);
            GridData addContactData = new GridData(131072, 768, true, false, 1, 1);
            Group group = new Group(parent, 16);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setText(Messages.SearchContactDialog_InfoSearchFields);
            Group groupContact = new Group(parent, 16);
            groupContact.setLayout((Layout)new GridLayout(2, false));
            groupContact.setText(Messages.SearchContactDialog_InfoContactFields);
            this.tableResult = new Table((Composite)groupContact, 67586);
            this.tableResult.setLinesVisible(true);
            this.tableResult.setHeaderVisible(true);
            GridData dataTable = new GridData(768, 1040, true, true, 2, 1);
            dataTable.heightHint = 200;
            this.tableResult.setLayoutData((Object)dataTable);
            new TableColumn(this.tableResult, 0).setText(Messages.SearchContactDialog_TableResultColumnName);
            new TableColumn(this.tableResult, 0).setText(Messages.SearchContactDialog_TableResultColumnUsername);
            new TableItem(this.tableResult, 0);
            int i = 0;
            while (i < 2) {
                this.tableResult.getColumn(i).setWidth(130);
                ++i;
            }
            this.addContactButton = new Button((Composite)groupContact, 131080);
            this.addContactButton.setText(Messages.SearchContactDialog_ButtonAddContact);
            this.addContactButton.setLayoutData((Object)addContactData);
            this.tableFields = new Table((Composite)group, 2082);
            this.tableFields.setLinesVisible(true);
            this.tableFields.setHeaderVisible(true);
            dataTable = new GridData(768, 1040, true, true, 2, 1);
            dataTable.heightHint = 200;
            this.tableFields.setLayoutData((Object)dataTable);
            TableColumn colField = new TableColumn(this.tableFields, 0);
            colField.setText(Messages.SearchContactDialog_TableSearchColumnField);
            TableColumn colValue = new TableColumn(this.tableFields, 0);
            colValue.setText(Messages.SearchContactDialog_TableSearchColumnValue);
            colValue.setWidth(130);
            int i2 = 0;
            while (i2 < fields.length) {
                TableItem item = new TableItem(this.tableFields, 0);
                item.setText(new String[]{fields[i2], ""});
                item.setChecked(true);
                ++i2;
            }
            TableItem[] items = this.tableFields.getItems();
            int i3 = 0;
            while (i3 < items.length) {
                final TableEditor editor = new TableEditor(this.tableFields);
                Text text = new Text((Composite)this.tableFields, 0);
                text.setText(items[i3].getText(1));
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        editor.getItem().setText(1, ((Text)editor.getEditor()).getText());
                    }
                });
                text.selectAll();
                text.setFocus();
                editor.grabHorizontal = true;
                editor.setEditor((Control)text, items[i3], 1);
                ++i3;
            }
            colField.pack();
            this.runInBackgroundButton = new Button((Composite)group, 32);
            this.runInBackgroundButton.setText(Messages.SearchContactDialog_RunInBackground);
            this.runInBackgroundButton.setToolTipText(Messages.SearchContactDialog_RunInBackGroundToolTip);
            this.searchButton = new Button((Composite)group, 131080);
            this.searchButton.setText(Messages.SearchContactDialog_ButtonSearch);
            this.searchButton.setLayoutData((Object)searchButtonData);
        }
        catch (ECFException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, e.getLocalizedMessage(), (Throwable)e));
            new Label(parent, 16384).setText(e.getLocalizedMessage());
        }
        this.addListeners();
        SearchContactDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void callAsynchronous(IUserSearchManager userManager, ICriteria criteria) {
        IUserSearchListener listener = new IUserSearchListener(){

            public void handleUserSearchEvent(IUserSearchEvent event) {
                if (event instanceof IUserSearchCompleteEvent) {
                    SearchContactDialog.this.fireEventComplete((IUserSearchCompleteEvent)event);
                }
            }
        };
        userManager.search(criteria, listener);
    }

    protected void fireEventComplete(final IUserSearchCompleteEvent event) {
        new UIJob(Messages.SearchContactDialog_UserSearchJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    UserSearchView view = (UserSearchView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ecf.presence.ui.UserSearchView");
                    view.showMessage(Messages.SearchContactDialog_SearchingMessage);
                    view.addMultiRosterAccount(SearchContactDialog.this.account);
                    view.addResult(event.getSearch().getResultList());
                }
                catch (PartInitException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, e.getLocalizedMessage(), (Throwable)e));
                    return new Status(4, "org.eclipse.ecf.presence.ui", 4, "Exception showing search results view", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

