/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ecf.internal.remoteservices.ui.EndpointDiscoveryView;
import org.eclipse.ecf.internal.remoteservices.ui.Messages;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;

public class DiscoveryComponent
implements EndpointEventListener {
    private static final String RSA_SYMBOLICNAME = "org.eclipse.ecf.osgi.services.remoteserviceadmin";
    private static DiscoveryComponent instance;
    private BundleContext context;
    private RemoteServiceAdmin rsa;
    private EndpointDiscoveryView discoveryView;
    private IEndpointDescriptionLocator edLocator;
    private List<EndpointEvent> history;

    void bindRemoteServiceAdmin(RemoteServiceAdmin r) {
        this.rsa = r;
    }

    void unbindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        rsa = null;
    }

    void bindEndpointDescriptionLocator(IEndpointDescriptionLocator locator) {
        this.edLocator = locator;
    }

    void unbindEndpointDescriptionLocator(IEndpointDescriptionLocator locator) {
        this.edLocator = null;
    }

    public IEndpointDescriptionLocator getEndpointDescriptionLocator() {
        return this.edLocator;
    }

    public static DiscoveryComponent getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setView(EndpointDiscoveryView edv) {
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            this.discoveryView = edv;
        }
    }

    RemoteServiceAdmin getRSA() {
        return this.rsa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(BundleContext context) throws Exception {
        this.history = new ArrayList<EndpointEvent>();
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            instance = this;
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            instance = null;
            this.discoveryView = null;
            this.rsa = null;
            this.context = null;
            if (this.history != null) {
                this.history.clear();
                this.history = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startRSA() throws BundleException {
        Bundle rsaBundle = null;
        BundleContext ctxt = null;
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            ctxt = this.context;
            if (ctxt == null) {
                return;
            }
        }
        Bundle[] bundleArray = ctxt.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals(RSA_SYMBOLICNAME)) {
                rsaBundle = b;
            }
            ++n2;
        }
        if (rsaBundle == null) {
            throw new BundleException(Messages.DiscoveryComponent_ERROR_MSG_CANNOT_FIND_RSA_BUNDLE);
        }
        rsaBundle.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EndpointEvent> getHistory() {
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            return this.history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointChanged(EndpointEvent event, String filter) {
        EndpointDiscoveryView view = null;
        List<EndpointEvent> h = null;
        DiscoveryComponent discoveryComponent = this;
        synchronized (discoveryComponent) {
            h = this.history;
            view = this.discoveryView;
        }
        if (view != null) {
            view.handleEndpointChanged(event);
        } else if (h != null) {
            h.add(event);
        }
    }
}

