/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLContainerMapping;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XMLAnyAttributeMapping
extends DatabaseMapping
implements XMLMapping,
XMLContainerMapping {
    private XMLField field;
    private MappedKeyMapContainerPolicy containerPolicy = new MappedKeyMapContainerPolicy(HashMap.class);
    private AbstractNullPolicy wrapperNullPolicy;
    private boolean isDefaultEmptyContainer = true;
    private boolean isNamespaceDeclarationIncluded;
    private boolean isSchemaInstanceIncluded;
    private boolean isWriteOnly;
    private boolean reuseContainer;

    public XMLAnyAttributeMapping() {
        this.containerPolicy.setKeyMapping(new XMLDirectMapping());
        this.isNamespaceDeclarationIncluded = true;
        this.isSchemaInstanceIncluded = true;
    }

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    public void buildClone(Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    public void buildCloneFromRow(AbstractRecord Record2, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public Object clone() {
        XMLAnyAttributeMapping mapping = null;
        mapping = (XMLAnyAttributeMapping)super.clone();
        mapping.setContainerPolicy(this.getContainerPolicy());
        mapping.setField(this.getField());
        return mapping;
    }

    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        ContainerPolicy cp;
        if (this.getField() != null) {
            this.setField(this.getDescriptor().buildField(this.getField()));
        }
        if ((cp = this.getContainerPolicy()) != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
    }

    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    public void setXPath(String xpath) {
        this.field = new XMLField(xpath);
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    public void setContainerPolicy(ContainerPolicy cp) {
        if (!cp.isMappedKeyMapPolicy()) {
            throw DescriptorException.invalidContainerPolicy(cp, this.getClass());
        }
        if (((MappedKeyMapContainerPolicy)cp).getKeyMapping() == null) {
            ((MappedKeyMapContainerPolicy)cp).setKeyMapping(new XMLDirectMapping());
        }
        this.containerPolicy = (MappedKeyMapContainerPolicy)cp;
    }

    public void setField(DatabaseField field) {
        this.field = (XMLField)field;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        XMLRecord record = (XMLRecord)row;
        if (this.getField() != null) {
            Object nested = record.get(this.getField());
            if (nested instanceof Vector) {
                nested = ((Vector)nested).firstElement();
            }
            if (!(nested instanceof XMLRecord)) {
                return null;
            }
            record = (XMLRecord)nested;
        }
        return this.buildObjectValuesFromDOMRecord((DOMRecord)record, executionSession, sourceQuery);
    }

    private Object buildObjectValuesFromDOMRecord(DOMRecord record, AbstractSession session, ObjectBuildingQuery query) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object container = null;
        if (this.reuseContainer) {
            Object currentObject = record.getCurrentObject();
            Object value = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
            container = value != null ? value : cp.containerInstance();
        } else {
            container = cp.containerInstance();
        }
        Element root = (Element)record.getDOM();
        NamedNodeMap attributes = root.getAttributes();
        int numberOfAtts = attributes.getLength();
        for (int i = 0; i < numberOfAtts; ++i) {
            Attr next = (Attr)attributes.item(i);
            String localName = next.getLocalName();
            if (null == localName) {
                localName = next.getName();
            }
            String namespaceURI = next.getNamespaceURI();
            boolean includeAttribute = true;
            if (!this.isNamespaceDeclarationIncluded && "http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                includeAttribute = false;
            } else if (!this.isSchemaInstanceIncluded && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI)) {
                includeAttribute = false;
            }
            if (!includeAttribute) continue;
            String value = next.getValue();
            QName key = new QName(namespaceURI, localName);
            cp.addInto(key, value, container, session);
        }
        return container;
    }

    protected XMLDescriptor getDescriptor(XMLRecord xmlRecord, AbstractSession session) throws XMLMarshalException {
        QName rootQName;
        XMLContext xmlContext = xmlRecord.getUnmarshaller().getXMLContext();
        XMLDescriptor xmlDescriptor = xmlContext.getDescriptor(rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName()));
        if (null == xmlDescriptor) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(xmlRecord.getLocalName());
        }
        return xmlDescriptor;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        this.writeSingleValue(attributeValue, object, (XMLRecord)row, session);
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow) {
        XMLDescriptor referenceDescriptor = (XMLDescriptor)session.getDescriptor(attributeValue.getClass());
        if (referenceDescriptor != null && referenceDescriptor.getDefaultRootElement() != null) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)referenceDescriptor.getObjectBuilder();
            return objectBuilder.buildRow(attributeValue, session, referenceDescriptor.buildField(referenceDescriptor.getDefaultRootElement()), (XMLRecord)parentRow);
        }
        return null;
    }

    public boolean isXMLMapping() {
        return true;
    }

    public Vector getFields() {
        return this.collectFields();
    }

    public void useMapClass(Class concreteMapClass) {
        if (!Helper.classImplementsInterface(concreteMapClass, Map.class)) {
            throw DescriptorException.illegalContainerClass(concreteMapClass);
        }
        this.containerPolicy.setContainerClass(concreteMapClass);
    }

    public void writeSingleValue(Object attributeValue, Object parent, XMLRecord row, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        if (attributeValue == null || cp.sizeFor(attributeValue) == 0) {
            return;
        }
        DOMRecord record = (DOMRecord)row;
        if (record.getDOM().getNodeType() != 1) {
            return;
        }
        DOMRecord recordToModify = record;
        Element root = (Element)record.getDOM();
        if (this.field != null) {
            root = (Element)XPathEngine.getInstance().create((XMLField)this.getField(), root, session);
            recordToModify = new DOMRecord(root);
        }
        ArrayList<Namespace> extraNamespaces = new ArrayList<Namespace>();
        NamespaceResolver nr = recordToModify.getNamespaceResolver();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Map.Entry entry = (Map.Entry)cp.nextEntry(iter, session);
            Object key = entry.getKey();
            if (key == null || !(key instanceof QName)) continue;
            Object value = entry.getValue();
            QName attributeName = (QName)key;
            String namespaceURI = attributeName.getNamespaceURI();
            String qualifiedName = attributeName.getLocalPart();
            if (nr != null) {
                String prefix = nr.resolveNamespaceURI(attributeName.getNamespaceURI());
                if (prefix != null && prefix.length() > 0) {
                    qualifiedName = prefix + ':' + qualifiedName;
                } else if (attributeName.getNamespaceURI() != null && attributeName.getNamespaceURI().length() > 0) {
                    String generatedPrefix = nr.generatePrefix();
                    qualifiedName = generatedPrefix + ':' + qualifiedName;
                    nr.put(generatedPrefix, attributeName.getNamespaceURI());
                    extraNamespaces.add(new Namespace(generatedPrefix, attributeName.getNamespaceURI()));
                    recordToModify.getNamespaceResolver().put(generatedPrefix, attributeName.getNamespaceURI());
                }
            }
            if (namespaceURI != null) {
                root.setAttributeNS(namespaceURI, qualifiedName, value.toString());
                continue;
            }
            root.setAttribute(attributeName.getLocalPart(), value.toString());
        }
        ((XMLObjectBuilder)this.descriptor.getObjectBuilder()).writeExtraNamespaces(extraNamespaces, recordToModify);
        ((XMLObjectBuilder)this.descriptor.getObjectBuilder()).removeExtraNamespacesFromNamespaceResolver(recordToModify, extraNamespaces, session);
    }

    public void useMapClassName(String concreteMapClassName) {
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(concreteMapClassName);
        policy.setKeyMapping(new XMLDirectMapping());
        this.setContainerPolicy(policy);
    }

    public boolean isNamespaceDeclarationIncluded() {
        return this.isNamespaceDeclarationIncluded;
    }

    public void setNamespaceDeclarationIncluded(boolean isNamespaceDeclarationIncluded) {
        this.isNamespaceDeclarationIncluded = isNamespaceDeclarationIncluded;
    }

    public boolean isSchemaInstanceIncluded() {
        return this.isSchemaInstanceIncluded;
    }

    public void setSchemaInstanceIncluded(boolean isSchemaInstanceIncluded) {
        this.isSchemaInstanceIncluded = isSchemaInstanceIncluded;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    public boolean isDefaultEmptyContainer() {
        return this.isDefaultEmptyContainer;
    }

    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.isDefaultEmptyContainer = defaultEmptyContainer;
    }

    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }
}

