/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import org.eclipse.persistence.jpa.internal.jpql.AbstractPathResolver;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

public final class StateFieldResolver
extends AbstractPathResolver {
    private Boolean enumType;
    private String stateFieldPath;

    StateFieldResolver(Resolver parent, String path, String stateFieldPath) {
        super(parent, path);
        this.stateFieldPath = stateFieldPath;
    }

    public void accept(ResolverVisitor visitor) {
        visitor.visit(this);
    }

    IType buildType() {
        return this.getTypeHelper().convertPrimitive(super.buildType());
    }

    ITypeDeclaration buildTypeDeclaration() {
        IType type = this.getEnumType();
        if (type != null) {
            this.enumType = Boolean.TRUE;
            return type.getTypeDeclaration();
        }
        this.enumType = Boolean.FALSE;
        return super.buildTypeDeclaration();
    }

    private IType getEnumType() {
        return this.stateFieldPath != null ? this.getTypeRepository().getEnumType(this.stateFieldPath) : null;
    }

    public String getStateFieldPath() {
        return this.stateFieldPath;
    }

    public boolean isEnumType() {
        if (this.enumType == null) {
            this.getType();
        }
        return this.enumType;
    }

    public String toString() {
        return this.stateFieldPath;
    }
}

