/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IMappingType;

public final class MappingTypeHelper {
    public static boolean isCollectionMapping(IMapping mapping) {
        return MappingTypeHelper.isCollectionMapping(MappingTypeHelper.mappingType(mapping));
    }

    public static boolean isCollectionMapping(IMappingType mappingType) {
        switch (mappingType) {
            case BASIC_COLLECTION: 
            case BASIC_MAP: 
            case ELEMENT_COLLECTION: 
            case MANY_TO_MANY: 
            case ONE_TO_MANY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyMapping(IMapping mapping) {
        return MappingTypeHelper.isPropertyMapping(MappingTypeHelper.mappingType(mapping));
    }

    public static boolean isPropertyMapping(IMappingType mappingType) {
        switch (mappingType) {
            case BASIC: 
            case ID: 
            case VERSION: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRelationshipMapping(IMapping mapping) {
        return MappingTypeHelper.isRelationshipMapping(MappingTypeHelper.mappingType(mapping));
    }

    public static boolean isRelationshipMapping(IMappingType mappingType) {
        switch (mappingType) {
            case ELEMENT_COLLECTION: 
            case MANY_TO_MANY: 
            case ONE_TO_MANY: 
            case EMBEDDED: 
            case EMBEDDED_ID: 
            case MANY_TO_ONE: 
            case ONE_TO_ONE: 
            case VARIABLE_ONE_TO_ONE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTransientMapping(IMapping mapping) {
        return MappingTypeHelper.mappingType(mapping) == IMappingType.TRANSIENT;
    }

    public static IMappingType mappingType(IMapping mapping) {
        return mapping != null ? mapping.getMappingType() : IMappingType.TRANSIENT;
    }
}

