/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.LangName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;

public class JavaName
extends LangName {
    static String m_defaultPackage;
    protected String m_useItfPackage;
    protected String m_useItf;
    protected String m_declItfPackage;
    protected String m_declItf;
    protected String m_usePackage;

    public JavaName(String packageName, String useName, String useItf, String declName, String declItf) {
        int dotPos;
        if (packageName == null) {
            packageName = "";
        }
        if ((dotPos = useName.lastIndexOf(46)) >= 0) {
            this.m_usePackage = JavaName.packageConcat(packageName, useName.substring(0, dotPos));
            this.m_useClass = useName.substring(dotPos + 1);
        } else {
            this.m_usePackage = packageName.length() > 0 ? packageName : m_defaultPackage;
            this.m_useClass = useName;
        }
        try {
            dotPos = useItf.lastIndexOf(46);
        }
        catch (Exception e) {
            dotPos = -1;
        }
        if (dotPos >= 0) {
            this.m_useItfPackage = JavaName.packageConcat(packageName, useItf.substring(0, dotPos));
            this.m_useItf = useItf.substring(dotPos + 1);
        } else {
            this.m_useItfPackage = packageName.length() > 0 ? packageName : m_defaultPackage;
            this.m_useItf = useItf;
        }
        if (declName == null) {
            this.m_context = this.m_usePackage;
            this.m_name = this.m_useClass;
            this.m_declItf = this.m_useItf;
            this.m_declItfPackage = this.m_useItfPackage;
            this.m_useItf = null;
        } else {
            dotPos = declName.lastIndexOf(46);
            if (dotPos >= 0) {
                this.m_context = JavaName.packageConcat(packageName, declName.substring(0, dotPos));
                this.m_name = declName.substring(dotPos + 1);
            } else {
                this.m_context = packageName.length() > 0 ? packageName : m_defaultPackage;
                this.m_name = declName;
            }
            try {
                dotPos = declItf.lastIndexOf(46);
            }
            catch (Exception e) {
                dotPos = -1;
            }
            if (dotPos >= 0 && this.m_useItf == null) {
                this.m_declItfPackage = JavaName.packageConcat(packageName, declItf.substring(0, dotPos));
                this.m_declItf = declItf.substring(dotPos + 1);
            } else {
                this.m_declItfPackage = packageName.length() > 0 ? packageName : m_defaultPackage;
                this.m_declItf = declItf;
            }
        }
        this.processUnicode();
    }

    public JavaName(String packageName, String typeName) {
        packageName = packageName == null ? "" : packageName;
        super(packageName, typeName);
        this.m_usePackage = packageName;
        this.m_useClass = typeName;
        this.processUnicode();
    }

    private void processUnicode() {
        this.m_name = JavaName.unicode2Ascii(this.m_name);
        this.m_context = JavaName.unicode2Ascii(this.m_context);
        this.m_declItf = JavaName.unicode2Ascii(this.m_declItf);
        this.m_declItfPackage = JavaName.unicode2Ascii(this.m_declItfPackage);
        this.m_useItf = JavaName.unicode2Ascii(this.m_useItf);
        this.m_useItfPackage = JavaName.unicode2Ascii(this.m_useItfPackage);
        this.m_useClass = JavaName.unicode2Ascii(this.m_useClass);
        this.m_usePackage = JavaName.unicode2Ascii(this.m_usePackage);
    }

    @Override
    public String toString() {
        return JavaName.packageConcat(this.getContextName(), this.getSimpleName());
    }

    @Override
    public String getDeclItfPackage() {
        return this.m_declItfPackage;
    }

    @Override
    public String getDeclItf() {
        return this.m_declItf;
    }

    public String getDeclItf(String currPackage) {
        if (currPackage == null) {
            return this.m_declItf;
        }
        return currPackage.equals(this.m_declItfPackage) ? this.m_declItf : JavaName.packageConcat(this.m_declItfPackage, this.m_declItf);
    }

    public String getDeclClass(String currPackage) {
        if (currPackage == null) {
            return this.m_name;
        }
        return currPackage.equals(this.m_context) ? this.m_useClass : JavaName.packageConcat(this.m_context, this.m_name);
    }

    @Override
    public String getUseClass() {
        return this.m_useClass;
    }

    @Override
    public String getUseClass(boolean full) {
        if (full) {
            return JavaName.packageConcat(this.m_usePackage, this.m_useClass);
        }
        return this.m_useClass;
    }

    @Override
    public String getUsePackage() {
        return this.m_usePackage;
    }

    @Override
    public String getUseItfPackage() {
        return this.m_useItfPackage;
    }

    @Override
    public boolean hasUseClass() {
        boolean has = true;
        if (this.m_name == null || this.m_context == null || this.m_useClass == null) {
            has = false;
        } else if (this.m_name.equals(this.m_useClass) && this.m_context.equals(this.m_usePackage)) {
            has = false;
        }
        return has;
    }

    @Override
    public String getUseClass(String currPackage) {
        if (currPackage == null) {
            return this.m_useClass;
        }
        return currPackage.equals(this.m_usePackage) ? this.m_useClass : JavaName.packageConcat(this.m_usePackage, this.m_useClass);
    }

    public void ungenPattern(String simpleName) {
        this.m_useClass = this.m_name = SqlName.sqlIdToJavaId(simpleName, true);
        this.m_usePackage = this.m_context;
        this.m_useItf = null;
        this.m_useItfPackage = this.m_declItfPackage;
    }

    @Override
    public String getUseItf() {
        return this.m_useItf;
    }

    public String getUseItf(String currPackage) {
        if (currPackage == null) {
            return JavaName.packageConcat(this.m_useItfPackage, this.m_useItf);
        }
        return currPackage.equals(this.m_useItfPackage) ? this.m_useItf : JavaName.packageConcat(this.m_useItfPackage, this.m_useItf);
    }

    public static void setDefaultPackage(String defaultPackage) {
        m_defaultPackage = defaultPackage;
    }

    public static String getDefaultPackage() {
        return m_defaultPackage;
    }
}

