/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;

public class MethodInfo {
    public String methodName;
    public String methodNo;
    public String methodType;
    public int parameters;
    public int results;

    public MethodInfo(UserArguments row) throws SQLException {
        this.methodName = row.OBJECT_NAME;
        this.methodNo = row.OVERLOAD;
        this.methodType = "PUBLIC";
        this.parameters = row.sequence == 0 ? 0 : row.POSITION;
        if (this.parameters < 0) {
            this.parameters = 0;
        }
        this.results = 1 - row.POSITION;
        if (this.results < 0) {
            this.results = 0;
        }
    }

    public MethodInfo(AllTypeMethods row) throws SQLException {
        this.methodName = row.methodName;
        this.methodNo = row.methodNo;
        this.methodType = row.methodType;
        this.parameters = row.parameters;
        this.results = row.results;
    }

    public static MethodInfo[] getMethodInfo(Iterator<ViewRow> iter) throws SQLException {
        ArrayList<MethodInfo> a = new ArrayList<MethodInfo>();
        while (iter.hasNext()) {
            ViewRow vr = iter.next();
            if (vr.isAllArguments() || vr.isUserArguments()) {
                a.add(new MethodInfo((AllArguments)vr));
                continue;
            }
            if (!vr.isAllTypeMethods()) continue;
            a.add(new MethodInfo((AllTypeMethods)vr));
        }
        return a.toArray(new MethodInfo[a.size()]);
    }

    public static MethodInfo[] groupBy(Iterator<ViewRow> iter) throws SQLException {
        MethodInfo[] minfo = MethodInfo.getMethodInfo(iter);
        HashMap<String, MethodInfo> miMap = new HashMap<String, MethodInfo>();
        for (int i = 0; i < minfo.length; ++i) {
            String key = minfo[i].methodName + "," + minfo[i].methodNo;
            MethodInfo mi = (MethodInfo)miMap.get(key);
            if (mi == null) {
                miMap.put(key, minfo[i]);
            }
            if (mi != null && mi.parameters < minfo[i].parameters) {
                mi.parameters = minfo[i].parameters;
            }
            if (mi == null || mi.results >= minfo[i].results) continue;
            mi.results = minfo[i].results;
        }
        return miMap.values().toArray(new MethodInfo[miMap.size()]);
    }
}

